/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import java.io.Serializable;
import javax.annotation.Nullable;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BlockSnapshot
implements Serializable {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("forge.debugBlockSnapshot", "false"));
    private final et pos;
    private final int dimId;
    private transient awt replacedBlock;
    private int flag;
    @Nullable
    private final fy nbt;
    private transient amu world;
    private final nf registryName;
    private final int meta;

    public BlockSnapshot(amu world, et pos, awt state) {
        this.setWorld(world);
        this.dimId = world.s.getDimension();
        this.pos = pos;
        this.setReplacedBlock(state);
        this.registryName = state.u().getRegistryName();
        this.meta = state.u().e(state);
        this.setFlag(3);
        avj te = world.r(pos);
        if (te != null) {
            this.nbt = new fy();
            te.b(this.getNbt());
        } else {
            this.nbt = null;
        }
        if (DEBUG) {
            System.out.printf("Created BlockSnapshot - [World: %s ][Location: %d,%d,%d ][Block: %s ][Meta: %d ]", world.V().j(), pos.p(), pos.q(), pos.r(), this.getRegistryName(), this.getMeta());
        }
    }

    public BlockSnapshot(amu world, et pos, awt state, @Nullable fy nbt) {
        this.setWorld(world);
        this.dimId = world.s.getDimension();
        this.pos = pos.h();
        this.setReplacedBlock(state);
        this.registryName = state.u().getRegistryName();
        this.meta = state.u().e(state);
        this.setFlag(3);
        this.nbt = nbt;
        if (DEBUG) {
            System.out.printf("Created BlockSnapshot - [World: %s ][Location: %d,%d,%d ][Block: %s ][Meta: %d ]", world.V().j(), pos.p(), pos.q(), pos.r(), this.getRegistryName(), this.getMeta());
        }
    }

    public BlockSnapshot(amu world, et pos, awt state, int flag) {
        this(world, pos, state);
        this.setFlag(flag);
    }

    public BlockSnapshot(int dimension, et pos, String modId, String blockName, int meta, int flag, @Nullable fy nbt) {
        this.dimId = dimension;
        this.pos = pos.h();
        this.setFlag(flag);
        this.registryName = new nf(modId, blockName);
        this.meta = meta;
        this.nbt = nbt;
    }

    public static BlockSnapshot getBlockSnapshot(amu world, et pos) {
        return new BlockSnapshot(world, pos, world.o(pos));
    }

    public static BlockSnapshot getBlockSnapshot(amu world, et pos, int flag) {
        return new BlockSnapshot(world, pos, world.o(pos), flag);
    }

    public static BlockSnapshot readFromNBT(fy tag) {
        fy nbt = tag.q("hasTE") ? null : tag.p("tileEntity");
        return new BlockSnapshot(tag.h("dimension"), new et(tag.h("posX"), tag.h("posY"), tag.h("posZ")), tag.l("blockMod"), tag.l("blockName"), tag.h("metadata"), tag.h("flag"), nbt);
    }

    public awt getCurrentBlock() {
        return this.getWorld().o(this.getPos());
    }

    public amu getWorld() {
        if (this.world == null) {
            this.world = DimensionManager.getWorld(this.getDimId());
        }
        return this.world;
    }

    public awt getReplacedBlock() {
        if (this.replacedBlock == null) {
            this.replacedBlock = ForgeRegistries.BLOCKS.getValue(this.getRegistryName()).a(this.getMeta());
        }
        return this.replacedBlock;
    }

    public avj getTileEntity() {
        if (this.getNbt() != null) {
            return avj.a((amu)this.getWorld(), (fy)this.getNbt());
        }
        return null;
    }

    public boolean restore() {
        return this.restore(false);
    }

    public boolean restore(boolean force) {
        return this.restore(force, true);
    }

    public boolean restore(boolean force, boolean applyPhysics) {
        awt current = this.getCurrentBlock();
        awt replaced = this.getReplacedBlock();
        if (current.u() != replaced.u() || current.u().e(current) != replaced.u().e(replaced)) {
            if (force) {
                this.getWorld().a(this.getPos(), replaced, applyPhysics ? 3 : 2);
            } else {
                return false;
            }
        }
        this.getWorld().a(this.getPos(), replaced, applyPhysics ? 3 : 2);
        this.getWorld().a(this.getPos(), current, replaced, applyPhysics ? 3 : 2);
        avj te = null;
        if (this.getNbt() != null && (te = this.getWorld().r(this.getPos())) != null) {
            te.a(this.getNbt());
            te.y_();
        }
        if (DEBUG) {
            System.out.printf("Restored BlockSnapshot with data [World: %s ][Location: %d,%d,%d ][Meta: %d ][Block: %s ][TileEntity: %s ][force: %s ][applyPhysics: %s]", this.getWorld().V().j(), this.getPos().p(), this.getPos().q(), this.getPos().r(), replaced.u().e(replaced), replaced.u().delegate.name(), te, force, applyPhysics);
        }
        return true;
    }

    public boolean restoreToLocation(amu world, et pos, boolean force, boolean applyPhysics) {
        awt current = this.getCurrentBlock();
        awt replaced = this.getReplacedBlock();
        if (current.u() != replaced.u() || current.u().e(current) != replaced.u().e(replaced)) {
            if (force) {
                world.a(pos, replaced, applyPhysics ? 3 : 2);
            } else {
                return false;
            }
        }
        world.a(pos, replaced, applyPhysics ? 3 : 2);
        world.a(pos, current, replaced, applyPhysics ? 3 : 2);
        avj te = null;
        if (this.getNbt() != null && (te = world.r(pos)) != null) {
            te.a(this.getNbt());
            te.y_();
        }
        if (DEBUG) {
            System.out.printf("Restored BlockSnapshot with data [World: %s ][Location: %d,%d,%d ][Meta: %d ][Block: %s ][TileEntity: %s ][force: %s ][applyPhysics: %s]", world.V().j(), pos.p(), pos.q(), pos.r(), replaced.u().e(replaced), replaced.u().delegate.name(), te, force, applyPhysics);
        }
        return true;
    }

    public void writeToNBT(fy compound) {
        compound.a("blockMod", this.getRegistryName().b());
        compound.a("blockName", this.getRegistryName().a());
        compound.a("posX", this.getPos().p());
        compound.a("posY", this.getPos().q());
        compound.a("posZ", this.getPos().r());
        compound.a("flag", this.getFlag());
        compound.a("dimension", this.getDimId());
        compound.a("metadata", this.getMeta());
        compound.a("hasTE", this.getNbt() != null);
        if (this.getNbt() != null) {
            compound.a("tileEntity", (gn)this.getNbt());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockSnapshot other = (BlockSnapshot)obj;
        if (!this.getPos().equals((Object)other.getPos())) {
            return false;
        }
        if (this.getMeta() != other.getMeta()) {
            return false;
        }
        if (this.getDimId() != other.getDimId()) {
            return false;
        }
        if (!(this.getNbt() == other.getNbt() || this.getNbt() != null && this.getNbt().equals((Object)other.getNbt()))) {
            return false;
        }
        if (!(this.getWorld() == other.getWorld() || this.getWorld() != null && this.getWorld().equals(other.getWorld()))) {
            return false;
        }
        return this.getRegistryName() == other.getRegistryName() || this.getRegistryName() != null && this.getRegistryName().equals((Object)other.getRegistryName());
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + this.getPos().p();
        hash = 73 * hash + this.getPos().q();
        hash = 73 * hash + this.getPos().r();
        hash = 73 * hash + this.getMeta();
        hash = 73 * hash + this.getDimId();
        hash = 73 * hash + (this.getNbt() != null ? this.getNbt().hashCode() : 0);
        hash = 73 * hash + (this.getWorld() != null ? this.getWorld().hashCode() : 0);
        hash = 73 * hash + (this.getRegistryName() != null ? this.getRegistryName().hashCode() : 0);
        return hash;
    }

    public et getPos() {
        return this.pos;
    }

    public int getDimId() {
        return this.dimId;
    }

    public void setReplacedBlock(awt replacedBlock) {
        this.replacedBlock = replacedBlock;
    }

    public int getFlag() {
        return this.flag;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    @Nullable
    public fy getNbt() {
        return this.nbt;
    }

    public void setWorld(amu world) {
        this.world = world;
    }

    public nf getRegistryName() {
        return this.registryName;
    }

    public int getMeta() {
        return this.meta;
    }
}

