/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.PropertyFloat;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockFluidBase
extends aow
implements IFluidBlock {
    protected static final Map<aow, Boolean> defaultDisplacements = Maps.newHashMap();
    protected Map<aow, Boolean> displacements = Maps.newHashMap();
    public static final axi LEVEL;
    public static final PropertyFloat[] LEVEL_CORNERS;
    public static final PropertyFloat FLOW_DIRECTION;
    public static final ImmutableList<IUnlistedProperty<Float>> FLUID_RENDER_PROPS;
    protected int quantaPerBlock = 8;
    protected float quantaPerBlockFloat = 8.0f;
    protected int density = 1;
    protected int densityDir = -1;
    protected int temperature = 295;
    protected int tickRate = 20;
    protected amm renderLayer = amm.d;
    protected int maxScaledLight = 0;
    protected final String fluidName;
    protected final Fluid definedFluid;

    public BlockFluidBase(Fluid fluid, bcz material) {
        super(material);
        this.a(true);
        this.p();
        this.fluidName = fluid.getName();
        this.density = fluid.density;
        this.temperature = fluid.temperature;
        this.maxScaledLight = fluid.luminosity;
        this.tickRate = fluid.viscosity / 200;
        this.densityDir = fluid.density > 0 ? -1 : 1;
        fluid.setBlock(this);
        this.definedFluid = fluid;
        this.displacements.putAll(defaultDisplacements);
        this.w(this.A.b().a((axj)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    @Nonnull
    protected awu b() {
        return new ExtendedBlockState(this, new axj[]{LEVEL}, (IUnlistedProperty[])FLUID_RENDER_PROPS.toArray((Object[])new IUnlistedProperty[0]));
    }

    public int e(@Nonnull awt state) {
        return (Integer)state.c((axj)LEVEL);
    }

    @Deprecated
    @Nonnull
    public awt a(int meta) {
        return this.t().a((axj)LEVEL, (Comparable)Integer.valueOf(meta));
    }

    public BlockFluidBase setQuantaPerBlock(int quantaPerBlock) {
        if (quantaPerBlock > 16 || quantaPerBlock < 1) {
            quantaPerBlock = 8;
        }
        this.quantaPerBlock = quantaPerBlock;
        this.quantaPerBlockFloat = quantaPerBlock;
        return this;
    }

    public BlockFluidBase setDensity(int density) {
        if (density == 0) {
            density = 1;
        }
        this.density = density;
        this.densityDir = density > 0 ? -1 : 1;
        return this;
    }

    public BlockFluidBase setTemperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public BlockFluidBase setTickRate(int tickRate) {
        if (tickRate <= 0) {
            tickRate = 20;
        }
        this.tickRate = tickRate;
        return this;
    }

    public BlockFluidBase setRenderLayer(amm renderLayer) {
        this.renderLayer = renderLayer;
        return this;
    }

    public BlockFluidBase setMaxScaledLight(int maxScaledLight) {
        this.maxScaledLight = maxScaledLight;
        return this;
    }

    public boolean canDisplace(amy world, et pos) {
        if (world.d(pos)) {
            return true;
        }
        awt state = world.o(pos);
        if (state.u() == this) {
            return false;
        }
        if (this.displacements.containsKey(state.u())) {
            return this.displacements.get(state.u());
        }
        bcz material = state.a();
        if (material.c() || material == bcz.E) {
            return false;
        }
        int density = BlockFluidBase.getDensity(world, pos);
        if (density == Integer.MAX_VALUE) {
            return true;
        }
        return this.density > density;
    }

    public boolean displaceIfPossible(amu world, et pos) {
        if (world.d(pos)) {
            return true;
        }
        awt state = world.o(pos);
        aow block = state.u();
        if (block == this) {
            return false;
        }
        if (this.displacements.containsKey(block)) {
            if (this.displacements.get(block).booleanValue()) {
                if (state.u() != aox.aH) {
                    block.b(world, pos, state, 0);
                }
                return true;
            }
            return false;
        }
        bcz material = state.a();
        if (material.c() || material == bcz.E) {
            return false;
        }
        int density = BlockFluidBase.getDensity((amy)world, pos);
        if (density == Integer.MAX_VALUE) {
            block.b(world, pos, state, 0);
            return true;
        }
        return this.density > density;
    }

    public abstract int getQuantaValue(amy var1, et var2);

    public abstract boolean a(@Nonnull awt var1, boolean var2);

    public abstract int getMaxRenderHeightMeta();

    public void c(@Nonnull amu world, @Nonnull et pos, @Nonnull awt state) {
        world.a(pos, (aow)this, this.tickRate);
    }

    public void a(@Nonnull awt state, @Nonnull amu world, @Nonnull et pos, @Nonnull aow neighborBlock, @Nonnull et neighbourPos) {
        world.a(pos, (aow)this, this.tickRate);
    }

    public boolean r() {
        return false;
    }

    public boolean b(@Nonnull amy world, @Nonnull et pos) {
        return true;
    }

    @Nonnull
    public ain a(@Nonnull awt state, @Nonnull Random rand, int fortune) {
        return air.a;
    }

    public int a(@Nonnull Random par1Random) {
        return 0;
    }

    public int a(@Nonnull amu world) {
        return this.tickRate;
    }

    @Nonnull
    public bhe a(@Nonnull amu world, @Nonnull et pos, @Nonnull vg entity, @Nonnull bhe vec) {
        if (this.densityDir > 0) {
            return vec;
        }
        bhe vec_flow = this.getFlowVector((amy)world, pos);
        return vec.b(vec_flow.b * (double)(this.quantaPerBlock * 4), vec_flow.c * (double)(this.quantaPerBlock * 4), vec_flow.d * (double)(this.quantaPerBlock * 4));
    }

    public int getLightValue(@Nonnull awt state, @Nonnull amy world, @Nonnull et pos) {
        if (this.maxScaledLight == 0) {
            return super.getLightValue(state, world, pos);
        }
        int data = (Integer)state.c((axj)LEVEL);
        return (int)((float)data / this.quantaPerBlockFloat * (float)this.maxScaledLight);
    }

    public boolean b(@Nonnull awt state) {
        return false;
    }

    public boolean c(@Nonnull awt state) {
        return false;
    }

    public int e(@Nonnull awt state, @Nonnull amy world, @Nonnull et pos) {
        int lightThis = world.b(pos, 0);
        int lightUp = world.b(pos.a(), 0);
        int lightThisBase = lightThis & 0xFF;
        int lightUpBase = lightUp & 0xFF;
        int lightThisExt = lightThis >> 16 & 0xFF;
        int lightUpExt = lightUp >> 16 & 0xFF;
        return (lightThisBase > lightUpBase ? lightThisBase : lightUpBase) | (lightThisExt > lightUpExt ? lightThisExt : lightUpExt) << 16;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public amm f() {
        return this.renderLayer;
    }

    public boolean a(@Nonnull awt state, @Nonnull amy world, @Nonnull et pos, @Nonnull fa side) {
        awt neighbor = world.o(pos.a(side));
        if (neighbor.a() == state.a()) {
            return false;
        }
        if (this.densityDir == -1 && side == fa.b) {
            return true;
        }
        if (this.densityDir == 1 && side == fa.a) {
            return true;
        }
        return super.a(state, world, pos, side);
    }

    private boolean isFluid(@Nonnull awt blockstate) {
        return blockstate.a().d() || blockstate.u() instanceof IFluidBlock;
    }

    @Nonnull
    public awt getExtendedState(@Nonnull awt oldState, @Nonnull amy worldIn, @Nonnull et pos) {
        IExtendedBlockState state = (IExtendedBlockState)oldState;
        state = state.withProperty(FLOW_DIRECTION, Float.valueOf((float)BlockFluidBase.getFlowDirection(worldIn, pos)));
        awt[][] upBlockState = new awt[3][3];
        float[][] height = new float[3][3];
        float[][] corner = new float[2][2];
        upBlockState[1][1] = worldIn.o(pos.c(this.densityDir));
        height[1][1] = this.getFluidHeightForRender(worldIn, pos, upBlockState[1][1]);
        if (height[1][1] == 1.0f) {
            for (int i2 = 0; i2 < 2; ++i2) {
                for (int j = 0; j < 2; ++j) {
                    corner[i2][j] = 1.0f;
                }
            }
        } else {
            int j;
            int i3;
            for (i3 = 0; i3 < 3; ++i3) {
                for (j = 0; j < 3; ++j) {
                    if (i3 == 1 && j == 1) continue;
                    upBlockState[i3][j] = worldIn.o(pos.a(i3 - 1, 0, j - 1).c(this.densityDir));
                    height[i3][j] = this.getFluidHeightForRender(worldIn, pos.a(i3 - 1, 0, j - 1), upBlockState[i3][j]);
                }
            }
            for (i3 = 0; i3 < 2; ++i3) {
                for (j = 0; j < 2; ++j) {
                    corner[i3][j] = this.getFluidHeightAverage(height[i3][j], height[i3][j + 1], height[i3 + 1][j], height[i3 + 1][j + 1]);
                }
            }
            boolean n = this.isFluid(upBlockState[0][1]);
            boolean s = this.isFluid(upBlockState[2][1]);
            boolean w = this.isFluid(upBlockState[1][0]);
            boolean e = this.isFluid(upBlockState[1][2]);
            boolean nw = this.isFluid(upBlockState[0][0]);
            boolean ne = this.isFluid(upBlockState[0][2]);
            boolean sw = this.isFluid(upBlockState[2][0]);
            boolean se = this.isFluid(upBlockState[2][2]);
            if (nw || n || w) {
                corner[0][0] = 1.0f;
            }
            if (ne || n || e) {
                corner[0][1] = 1.0f;
            }
            if (sw || s || w) {
                corner[1][0] = 1.0f;
            }
            if (se || s || e) {
                corner[1][1] = 1.0f;
            }
        }
        state = state.withProperty(LEVEL_CORNERS[0], Float.valueOf(corner[0][0]));
        state = state.withProperty(LEVEL_CORNERS[1], Float.valueOf(corner[0][1]));
        state = state.withProperty(LEVEL_CORNERS[2], Float.valueOf(corner[1][1]));
        state = state.withProperty(LEVEL_CORNERS[3], Float.valueOf(corner[1][0]));
        return state;
    }

    public static final int getDensity(amy world, et pos) {
        aow block = world.o(pos).u();
        if (!(block instanceof BlockFluidBase)) {
            return Integer.MAX_VALUE;
        }
        return ((BlockFluidBase)block).density;
    }

    public static final int getTemperature(amy world, et pos) {
        aow block = world.o(pos).u();
        if (!(block instanceof BlockFluidBase)) {
            return Integer.MAX_VALUE;
        }
        return ((BlockFluidBase)block).temperature;
    }

    public static double getFlowDirection(amy world, et pos) {
        awt state = world.o(pos);
        if (!state.a().d()) {
            return -1000.0;
        }
        bhe vec = ((BlockFluidBase)state.u()).getFlowVector(world, pos);
        return vec.b == 0.0 && vec.d == 0.0 ? -1000.0 : Math.atan2(vec.d, vec.b) - 1.5707963267948966;
    }

    public final int getQuantaValueBelow(amy world, et pos, int belowThis) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        if (quantaRemaining >= belowThis) {
            return -1;
        }
        return quantaRemaining;
    }

    public final int getQuantaValueAbove(amy world, et pos, int aboveThis) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        if (quantaRemaining <= aboveThis) {
            return -1;
        }
        return quantaRemaining;
    }

    public final float getQuantaPercentage(amy world, et pos) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        return (float)quantaRemaining / this.quantaPerBlockFloat;
    }

    public float getFluidHeightAverage(float ... flow) {
        float total = 0.0f;
        int count = 0;
        float end = 0.0f;
        for (int i2 = 0; i2 < flow.length; ++i2) {
            if (flow[i2] >= 0.875f) {
                total += flow[i2] * 10.0f;
                count += 10;
            }
            if (!(flow[i2] >= 0.0f)) continue;
            total += flow[i2];
            ++count;
        }
        if (end == 0.0f) {
            end = total / (float)count;
        }
        return end;
    }

    public float getFluidHeightForRender(amy world, et pos, @Nonnull awt up2) {
        awt here = world.o(pos);
        if (here.u() == this) {
            if (up2.a().d() || up2.u() instanceof IFluidBlock) {
                return 1.0f;
            }
            if (this.e(here) == this.getMaxRenderHeightMeta()) {
                return 0.875f;
            }
        }
        if (here.u() instanceof aru) {
            return Math.min(1.0f - aru.b((int)((Integer)here.c((axj)aru.b))), 0.875f);
        }
        return !here.a().a() && up2.u() == this ? 1.0f : this.getQuantaPercentage(world, pos) * 0.875f;
    }

    public bhe getFlowVector(amy world, et pos) {
        bhe vec = new bhe(0.0, 0.0, 0.0);
        int decay = this.quantaPerBlock - this.getQuantaValue(world, pos);
        for (int side = 0; side < 4; ++side) {
            int power;
            int x2 = pos.p();
            int z2 = pos.r();
            switch (side) {
                case 0: {
                    --x2;
                    break;
                }
                case 1: {
                    --z2;
                    break;
                }
                case 2: {
                    ++x2;
                    break;
                }
                case 3: {
                    ++z2;
                }
            }
            et pos2 = new et(x2, pos.q(), z2);
            int otherDecay = this.quantaPerBlock - this.getQuantaValue(world, pos2);
            if (otherDecay >= this.quantaPerBlock) {
                if (world.o(pos2).a().c() || (otherDecay = this.quantaPerBlock - this.getQuantaValue(world, pos2.b())) < 0) continue;
                power = otherDecay - (decay - this.quantaPerBlock);
                vec = vec.b((double)((pos2.p() - pos.p()) * power), 0.0, (double)((pos2.r() - pos.r()) * power));
                continue;
            }
            if (otherDecay < 0) continue;
            power = otherDecay - decay;
            vec = vec.b((double)((pos2.p() - pos.p()) * power), 0.0, (double)((pos2.r() - pos.r()) * power));
        }
        if (world.o(pos.a()).u() == this) {
            boolean flag;
            boolean bl = flag = this.isBlockSolid(world, pos.a(0, 0, -1), fa.c) || this.isBlockSolid(world, pos.a(0, 0, 1), fa.d) || this.isBlockSolid(world, pos.a(-1, 0, 0), fa.e) || this.isBlockSolid(world, pos.a(1, 0, 0), fa.f) || this.isBlockSolid(world, pos.a(0, 1, -1), fa.c) || this.isBlockSolid(world, pos.a(0, 1, 1), fa.d) || this.isBlockSolid(world, pos.a(-1, 1, 0), fa.e) || this.isBlockSolid(world, pos.a(1, 1, 0), fa.f);
            if (flag) {
                vec = vec.a().b(0.0, -6.0, 0.0);
            }
        }
        vec = vec.a();
        return vec;
    }

    private boolean isBlockSolid(amy world, et pos, fa face) {
        return world.o(pos).d(world, pos, face) == awr.a;
    }

    @Override
    public Fluid getFluid() {
        return FluidRegistry.getFluid(this.fluidName);
    }

    @Override
    public float getFilledPercentage(amu world, et pos) {
        int quantaRemaining = this.getQuantaValue((amy)world, pos) + 1;
        float remaining = (float)quantaRemaining / this.quantaPerBlockFloat;
        if (remaining > 1.0f) {
            remaining = 1.0f;
        }
        return remaining * (float)(this.density > 0 ? 1 : -1);
    }

    public bhb a(@Nonnull awt blockState, @Nonnull amy worldIn, @Nonnull et pos) {
        return k;
    }

    static {
        defaultDisplacements.put((aow)aox.ao, false);
        defaultDisplacements.put((aow)aox.ap, false);
        defaultDisplacements.put((aow)aox.aq, false);
        defaultDisplacements.put((aow)aox.ar, false);
        defaultDisplacements.put((aow)aox.as, false);
        defaultDisplacements.put((aow)aox.at, false);
        defaultDisplacements.put(aox.bd, false);
        defaultDisplacements.put(aox.cw, false);
        defaultDisplacements.put(aox.aO, false);
        defaultDisplacements.put(aox.aP, false);
        defaultDisplacements.put(aox.aQ, false);
        defaultDisplacements.put(aox.aR, false);
        defaultDisplacements.put(aox.aS, false);
        defaultDisplacements.put(aox.aT, false);
        defaultDisplacements.put(aox.bz, false);
        defaultDisplacements.put(aox.bo, false);
        defaultDisplacements.put(aox.bp, false);
        defaultDisplacements.put(aox.bq, false);
        defaultDisplacements.put(aox.br, false);
        defaultDisplacements.put(aox.bs, false);
        defaultDisplacements.put(aox.bt, false);
        defaultDisplacements.put(aox.aB, false);
        defaultDisplacements.put(aox.az, false);
        defaultDisplacements.put(aox.ch, false);
        defaultDisplacements.put(aox.ci, false);
        defaultDisplacements.put(aox.au, false);
        defaultDisplacements.put(aox.bi, false);
        defaultDisplacements.put(aox.bj, false);
        defaultDisplacements.put((aow)aox.cH, false);
        defaultDisplacements.put((aow)aox.aY, false);
        defaultDisplacements.put(aox.bF, false);
        defaultDisplacements.put(aox.bZ, false);
        defaultDisplacements.put(aox.cv, false);
        defaultDisplacements.put(aox.cK, false);
        defaultDisplacements.put(aox.cL, false);
        defaultDisplacements.put(aox.ba, false);
        defaultDisplacements.put((aow)aox.aA, false);
        defaultDisplacements.put(aox.an, false);
        defaultDisplacements.put(aox.ax, false);
        defaultDisplacements.put((aow)aox.aM, false);
        LEVEL = axi.a((String)"level", (int)0, (int)15);
        LEVEL_CORNERS = new PropertyFloat[4];
        FLOW_DIRECTION = new PropertyFloat("flow_direction");
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)FLOW_DIRECTION);
        for (int i2 = 0; i2 < 4; ++i2) {
            BlockFluidBase.LEVEL_CORNERS[i2] = new PropertyFloat("level_corner_" + i2);
            builder.add((Object)LEVEL_CORNERS[i2]);
        }
        FLUID_RENDER_PROPS = builder.build();
    }
}

