/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.asm.transformers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class SideTransformer
implements IClassTransformer {
    private static String SIDE = FMLLaunchHandler.side().name();
    private static final boolean DEBUG = false;

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        if (this.remove(classNode.visibleAnnotations, SIDE)) {
            throw new RuntimeException(String.format("Attempted to load class %s for invalid side %s", classNode.name, SIDE));
        }
        Iterator fields = classNode.fields.iterator();
        while (fields.hasNext()) {
            FieldNode field = (FieldNode)fields.next();
            if (!this.remove(field.visibleAnnotations, SIDE)) continue;
            fields.remove();
        }
        LambdaGatherer lambdaGatherer = new LambdaGatherer();
        Iterator methods = classNode.methods.iterator();
        while (methods.hasNext()) {
            MethodNode method = (MethodNode)methods.next();
            if (!this.remove(method.visibleAnnotations, SIDE)) continue;
            methods.remove();
            lambdaGatherer.accept(method);
        }
        List<Handle> dynamicLambdaHandles = lambdaGatherer.getDynamicLambdaHandles();
        if (!dynamicLambdaHandles.isEmpty()) {
            methods = classNode.methods.iterator();
            while (methods.hasNext()) {
                MethodNode method = (MethodNode)methods.next();
                for (Handle dynamicLambdaHandle : dynamicLambdaHandles) {
                    if (!method.name.equals(dynamicLambdaHandle.getName()) || !method.desc.equals(dynamicLambdaHandle.getDesc())) continue;
                    methods.remove();
                }
            }
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private boolean remove(List<AnnotationNode> anns, String side) {
        if (anns == null) {
            return false;
        }
        for (AnnotationNode ann : anns) {
            if (!ann.desc.equals(Type.getDescriptor(SideOnly.class)) || ann.values == null) continue;
            for (int x = 0; x < ann.values.size() - 1; x += 2) {
                Object key = ann.values.get(x);
                Object value = ann.values.get(x + 1);
                if (!(key instanceof String) || !key.equals("value") || !(value instanceof String[]) || ((String[])value)[1].equals(side)) continue;
                return true;
            }
        }
        return false;
    }

    private static class LambdaGatherer
    extends MethodVisitor {
        private static final Handle META_FACTORY = new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;");
        private final List<Handle> dynamicLambdaHandles = new ArrayList<Handle>();

        public LambdaGatherer() {
            super(327680);
        }

        public void accept(MethodNode method) {
            for (AbstractInsnNode insnNode : method.instructions) {
                if (insnNode.getType() != 6) continue;
                insnNode.accept((MethodVisitor)this);
            }
        }

        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            if (META_FACTORY.equals((Object)bsm)) {
                Handle dynamicLambdaHandle = (Handle)bsmArgs[1];
                this.dynamicLambdaHandles.add(dynamicLambdaHandle);
            }
        }

        public List<Handle> getDynamicLambdaHandles() {
            return this.dynamicLambdaHandles;
        }
    }
}

