/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network.handshake;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.handshake.FMLHandshakeMessage;
import net.minecraftforge.fml.common.network.handshake.IHandshakeState;
import net.minecraftforge.fml.common.network.handshake.NetworkDispatcher;
import net.minecraftforge.fml.common.network.internal.FMLMessage;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.RegistryManager;

enum FMLHandshakeServerState implements IHandshakeState<FMLHandshakeServerState>
{
    START{

        @Override
        public void accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg, Consumer<? super FMLHandshakeServerState> cons) {
            cons.accept(HELLO);
            NetworkDispatcher dispatcher = (NetworkDispatcher)((Object)ctx.channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
            int overrideDim = dispatcher.serverInitiateHandshake();
            ctx.writeAndFlush((Object)FMLHandshakeMessage.makeCustomChannelRegistration(NetworkRegistry.INSTANCE.channelNamesFor(Side.SERVER))).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            ctx.writeAndFlush((Object)new FMLHandshakeMessage.ServerHello(overrideDim)).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        }
    }
    ,
    HELLO{

        @Override
        public void accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg, Consumer<? super FMLHandshakeServerState> cons) {
            if (msg instanceof FMLHandshakeMessage.ClientHello) {
                FMLLog.log.info("Client protocol version {}", (Object)Integer.toHexString(((FMLHandshakeMessage.ClientHello)msg).protocolVersion()));
                return;
            }
            FMLHandshakeMessage.ModList client = (FMLHandshakeMessage.ModList)msg;
            NetworkDispatcher dispatcher = (NetworkDispatcher)((Object)ctx.channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
            dispatcher.setModList(client.modList());
            FMLLog.log.info("Client attempting to join with {} mods : {}", (Object)client.modListSize(), (Object)client.modListAsString());
            String result = FMLNetworkHandler.checkModList(client, Side.CLIENT);
            if (result != null) {
                cons.accept(ERROR);
                dispatcher.rejectHandshake(result);
                return;
            }
            cons.accept(WAITINGCACK);
            ctx.writeAndFlush((Object)new FMLHandshakeMessage.ModList(Loader.instance().getActiveModList()));
        }
    }
    ,
    WAITINGCACK{

        @Override
        public void accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg, Consumer<? super FMLHandshakeServerState> cons) {
            cons.accept(COMPLETE);
            if (!((Boolean)ctx.channel().attr(NetworkDispatcher.IS_LOCAL).get()).booleanValue()) {
                Map<nf, ForgeRegistry.Snapshot> snapshot = RegistryManager.ACTIVE.takeSnapshot(false);
                Iterator<Map.Entry<nf, ForgeRegistry.Snapshot>> itr = snapshot.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry<nf, ForgeRegistry.Snapshot> e = itr.next();
                    ctx.writeAndFlush((Object)new FMLHandshakeMessage.RegistryData(itr.hasNext(), e.getKey(), e.getValue())).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
                }
            }
            ctx.writeAndFlush((Object)new FMLHandshakeMessage.HandshakeAck(this.ordinal())).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            NetworkRegistry.INSTANCE.fireNetworkHandshake((NetworkDispatcher)((Object)ctx.channel().attr(NetworkDispatcher.FML_DISPATCHER).get()), Side.SERVER);
        }
    }
    ,
    COMPLETE{

        @Override
        public void accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg, Consumer<? super FMLHandshakeServerState> cons) {
            cons.accept(DONE);
            ctx.writeAndFlush((Object)new FMLHandshakeMessage.HandshakeAck(this.ordinal())).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            FMLMessage.CompleteHandshake complete = new FMLMessage.CompleteHandshake(Side.SERVER);
            ctx.fireChannelRead((Object)complete);
        }
    }
    ,
    DONE{

        @Override
        public void accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg, Consumer<? super FMLHandshakeServerState> cons) {
        }
    }
    ,
    ERROR{

        @Override
        public void accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg, Consumer<? super FMLHandshakeServerState> cons) {
        }
    };

}

