/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.network.internal.FMLMessage;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class EntityRegistry {
    private static final EntityRegistry INSTANCE = new EntityRegistry();
    private ListMultimap<ModContainer, EntityRegistration> entityRegistrations = ArrayListMultimap.create();
    private BiMap<Class<? extends vg>, EntityRegistration> entityClassRegistrations = HashBiMap.create();

    public static EntityRegistry instance() {
        return INSTANCE;
    }

    private EntityRegistry() {
    }

    public static void registerModEntity(nf registryName, Class<? extends vg> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.instance().doModEntityRegistration(registryName, entityClass, entityName, id, mod, trackingRange, updateFrequency, sendsVelocityUpdates);
    }

    public static void registerModEntity(nf registryName, Class<? extends vg> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int eggPrimary, int eggSecondary) {
        EntityRegistry.instance().doModEntityRegistration(registryName, entityClass, entityName, id, mod, trackingRange, updateFrequency, sendsVelocityUpdates);
        EntityRegistry.registerEgg(registryName, eggPrimary, eggSecondary);
    }

    private void doModEntityRegistration(nf registryName, Class<? extends vg> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        ModContainer mc = FMLCommonHandler.instance().findContainerFor(mod);
        EntityRegistration er = new EntityRegistration(mc, registryName, entityClass, entityName, id, trackingRange, updateFrequency, sendsVelocityUpdates);
        try {
            this.entityClassRegistrations.put(entityClass, (Object)er);
            if (!ForgeRegistries.ENTITIES.containsKey(registryName)) {
                EntityEntry entry = (EntityEntry)new EntityEntry(entityClass, entityName).setRegistryName(registryName);
                ForgeRegistries.ENTITIES.register(entry);
                FMLLog.log.trace("Automatically registered mod {} entity {} as {}", (Object)mc.getModId(), (Object)entityName, (Object)entry.getRegistryName());
            } else {
                FMLLog.log.debug("Skipping automatic mod {} entity registration for already registered entry {} class {}", (Object)mc.getModId(), (Object)registryName, (Object)entityClass.getName());
            }
        }
        catch (IllegalArgumentException e) {
            FMLLog.log.warn("The mod {} tried to register the entity (registry,name,class) ({},{},{}) one or both of which are already registered", (Object)mc.getModId(), (Object)registryName, (Object)entityName, (Object)entityClass.getName(), (Object)e);
            return;
        }
        this.entityRegistrations.put((Object)mc, (Object)er);
    }

    public static void registerEgg(nf name, int primary, int secondary) {
        EntityEntry entry = ForgeRegistries.ENTITIES.getValue(name);
        if (entry == null) {
            FMLLog.bigWarning("Attempted to registry a entity egg for entity ({}) that is not in the Entity Registry", name);
            return;
        }
        entry.setEgg(new vi.a(name, primary, secondary));
    }

    public static void addSpawn(Class<? extends vq> entityClass, int weightedProb, int min, int max, vr typeOfCreature, anh ... biomes) {
        for (anh biome : biomes) {
            List spawns = biome.a(typeOfCreature);
            boolean found = false;
            for (anh.c entry : spawns) {
                if (entry.b != entityClass) continue;
                entry.a = weightedProb;
                entry.c = min;
                entry.d = max;
                found = true;
                break;
            }
            if (found) continue;
            spawns.add(new anh.c(entityClass, weightedProb, min, max));
        }
    }

    public static void addSpawn(String entityName, int weightedProb, int min, int max, vr typeOfCreature, anh ... biomes) {
        Class<?> entityClazz = null;
        if (vq.class.isAssignableFrom(entityClazz)) {
            EntityRegistry.addSpawn(entityClazz, weightedProb, min, max, typeOfCreature, biomes);
        }
    }

    public static void removeSpawn(Class<? extends vq> entityClass, vr typeOfCreature, anh ... biomes) {
        for (anh biome : biomes) {
            biome.a(typeOfCreature).removeIf(entry -> entry.b == entityClass);
        }
    }

    public static void removeSpawn(String entityName, vr typeOfCreature, anh ... biomes) {
        Class<?> entityClazz = null;
        if (vq.class.isAssignableFrom(entityClazz)) {
            EntityRegistry.removeSpawn(entityClazz, typeOfCreature, biomes);
        }
    }

    @Nullable
    public EntityRegistration lookupModSpawn(Class<? extends vg> clazz, boolean keepLooking) {
        Class<? extends vg> localClazz = clazz;
        do {
            EntityRegistration er;
            if ((er = (EntityRegistration)this.entityClassRegistrations.get(localClazz)) == null) continue;
            return er;
        } while (keepLooking &= !Object.class.equals(localClazz = localClazz.getSuperclass()));
        return null;
    }

    @Nullable
    public EntityRegistration lookupModSpawn(ModContainer mc, int modEntityId) {
        for (EntityRegistration er : this.entityRegistrations.get((Object)mc)) {
            if (er.getModEntityId() != modEntityId) continue;
            return er;
        }
        return null;
    }

    public boolean tryTrackingEntity(ol entityTracker, vg entity) {
        EntityRegistration er = this.lookupModSpawn(entity.getClass(), true);
        if (er != null) {
            entityTracker.a(entity, er.getTrackingRange(), er.getUpdateFrequency(), er.sendsVelocityUpdates());
            return true;
        }
        return false;
    }

    @Nullable
    public static EntityEntry getEntry(Class<? extends vg> entry) {
        for (EntityEntry e : ForgeRegistries.ENTITIES) {
            if (e.getEntityClass() != entry) continue;
            return e;
        }
        return null;
    }

    final void insert(Class<? extends vg> entity, EntityRegistration registration) {
        this.entityClassRegistrations.put(entity, (Object)registration);
        this.entityRegistrations.put((Object)registration.container, (Object)registration);
    }

    public class EntityRegistration {
        private Class<? extends vg> entityClass;
        private ModContainer container;
        private nf regName;
        private String entityName;
        private int modId;
        private int trackingRange;
        private int updateFrequency;
        private boolean sendsVelocityUpdates;
        private Function<FMLMessage.EntitySpawnMessage, vg> customSpawnCallback;
        private boolean usesVanillaSpawning;

        public EntityRegistration(ModContainer mc, nf registryName, Class<? extends vg> entityClass, String entityName, int id, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
            this.container = mc;
            this.regName = registryName;
            this.entityClass = entityClass;
            this.entityName = entityName;
            this.modId = id;
            this.trackingRange = trackingRange;
            this.updateFrequency = updateFrequency;
            this.sendsVelocityUpdates = sendsVelocityUpdates;
        }

        public nf getRegistryName() {
            return this.regName;
        }

        public Class<? extends vg> getEntityClass() {
            return this.entityClass;
        }

        public ModContainer getContainer() {
            return this.container;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public int getModEntityId() {
            return this.modId;
        }

        public int getTrackingRange() {
            return this.trackingRange;
        }

        public int getUpdateFrequency() {
            return this.updateFrequency;
        }

        public boolean sendsVelocityUpdates() {
            return this.sendsVelocityUpdates;
        }

        public boolean usesVanillaSpawning() {
            return this.usesVanillaSpawning;
        }

        public boolean hasCustomSpawning() {
            return this.customSpawnCallback != null;
        }

        public vg doCustomSpawning(FMLMessage.EntitySpawnMessage spawnMsg) throws Exception {
            return this.customSpawnCallback.apply(spawnMsg);
        }

        public void setCustomSpawning(Function<FMLMessage.EntitySpawnMessage, vg> callable, boolean usesVanillaSpawning) {
            this.customSpawnCallback = callable;
            this.usesVanillaSpawning = usesVanillaSpawning;
        }
    }
}

