/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.relauncher;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.FMLInjectionData;

public class ModListHelper {
    private static File mcDirectory;
    private static Set<File> visitedFiles;
    public static final Map<String, File> additionalMods;

    static void parseModList(File minecraftDirectory) {
        String extraMods;
        FMLLog.log.debug("Attempting to load commandline specified mods, relative to {}", (Object)minecraftDirectory.getAbsolutePath());
        mcDirectory = minecraftDirectory;
        Map args = (Map)Launch.blackboard.get("launchArgs");
        String listFile = (String)args.get("--modListFile");
        if (listFile != null) {
            ModListHelper.parseListFile(listFile);
        }
        if ((extraMods = (String)args.get("--mods")) != null) {
            String[] split;
            for (String modFile : split = extraMods.split(",")) {
                ModListHelper.tryAddFile(modFile, null, modFile);
            }
        }
        String[] extras = new String[]{"mods/mod_list.json", "mods/" + FMLInjectionData.mccversion + "/mod_list.json"};
        for (String extra : extras) {
            if (!new File(mcDirectory, extra).exists()) continue;
            ModListHelper.parseListFile(extra);
        }
    }

    private static void parseListFile(String listFile) {
        File repoRoot;
        JsonModList modList;
        String json;
        File f2;
        try {
            f2 = listFile.startsWith("absolute:") ? new File(listFile.substring(9)).getCanonicalFile() : new File(mcDirectory, listFile).getCanonicalFile();
        }
        catch (IOException e2) {
            FMLLog.log.info(FMLLog.log.getMessageFactory().newMessage("Unable to canonicalize path {} relative to {}", new Object[]{listFile, mcDirectory.getAbsolutePath()}), (Throwable)e2);
            return;
        }
        if (!f2.exists()) {
            FMLLog.log.info("Failed to find modList file {}", (Object)f2.getAbsolutePath());
            return;
        }
        if (visitedFiles.contains(f2)) {
            FMLLog.log.fatal("There appears to be a loop in the modListFile hierarchy. You shouldn't do this!");
            throw new RuntimeException("Loop detected, impossible to load modlistfile");
        }
        try {
            json = Files.asCharSource((File)f2, (Charset)StandardCharsets.UTF_8).read();
        }
        catch (IOException e1) {
            FMLLog.log.info(FMLLog.log.getMessageFactory().newMessage("Failed to read modList json file {}.", new Object[]{listFile}), (Throwable)e1);
            return;
        }
        Gson gsonParser = new Gson();
        try {
            modList = (JsonModList)gsonParser.fromJson(json, JsonModList.class);
        }
        catch (JsonSyntaxException e2) {
            FMLLog.log.info(FMLLog.log.getMessageFactory().newMessage("Failed to parse modList json file {}.", new Object[]{listFile}), (Throwable)e2);
            return;
        }
        visitedFiles.add(f2);
        if (modList.parentList != null) {
            ModListHelper.parseListFile(modList.parentList);
        }
        if (!(repoRoot = new File(modList.repositoryRoot)).exists()) {
            FMLLog.log.info("Failed to find the specified repository root {}", (Object)modList.repositoryRoot);
            return;
        }
        for (String s : modList.modRef) {
            StringBuilder fileName = new StringBuilder();
            StringBuilder genericName = new StringBuilder();
            String[] parts = s.split(":");
            fileName.append(parts[0].replace('.', File.separatorChar));
            genericName.append(parts[0]);
            fileName.append(File.separatorChar);
            fileName.append(parts[1]).append(File.separatorChar);
            genericName.append(":").append(parts[1]);
            fileName.append(parts[2]).append(File.separatorChar);
            fileName.append(parts[1]).append('-').append(parts[2]);
            if (parts.length == 4) {
                fileName.append('-').append(parts[3]);
                genericName.append(":").append(parts[3]);
            }
            fileName.append(".jar");
            ModListHelper.tryAddFile(fileName.toString(), repoRoot, genericName.toString());
        }
    }

    private static void tryAddFile(String modFileName, @Nullable File repoRoot, String descriptor) {
        File modFile;
        File file = modFile = repoRoot != null ? new File(repoRoot, modFileName) : new File(mcDirectory, modFileName);
        if (!modFile.exists()) {
            FMLLog.log.info("Failed to find mod file {} ({})", (Object)descriptor, (Object)modFile.getAbsolutePath());
        } else {
            FMLLog.log.debug("Adding {} ({}) to the mod list", (Object)descriptor, (Object)modFile.getAbsolutePath());
            additionalMods.put(descriptor, modFile);
        }
    }

    static {
        visitedFiles = Sets.newHashSet();
        additionalMods = Maps.newLinkedHashMap();
    }

    public static class JsonModList {
        public String repositoryRoot;
        public List<String> modRef;
        public String parentList;
    }
}

