/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import com.google.common.collect.Maps;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.WorldWorkerManager;
import net.minecraftforge.server.ForgeTimeTracker;
import net.minecraftforge.server.command.ChunkGenWorker;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ForgeCommand
extends bi {
    private static final DecimalFormat timeFormatter = new DecimalFormat("########0.000");

    public String c() {
        return "forge";
    }

    public String b(bn icommandsender) {
        return "commands.forge.usage";
    }

    public int a() {
        return 2;
    }

    public void a(MinecraftServer server, bn sender, String[] args) throws ei {
        if (args.length == 0) {
            throw new ep("commands.forge.usage", new Object[0]);
        }
        if ("help".equals(args[0])) {
            throw new ep("commands.forge.usage", new Object[0]);
        }
        if ("tps".equals(args[0])) {
            this.displayTPS(server, sender, args);
        } else if ("track".equals(args[0])) {
            this.handleTracking(server, sender, args);
        } else if ("gen".equals(args[0])) {
            this.handleGen(server, sender, args);
        } else if ("entity".equals(args[0])) {
            this.handleEntity(server, sender, args);
        } else {
            throw new ep("commands.forge.usage", new Object[0]);
        }
    }

    public List<String> a(MinecraftServer server, bn sender, String[] args, @Nullable et targetPos) {
        if (args.length <= 1) {
            return ForgeCommand.a((String[])args, (String[])new String[]{"help", "tps", "track", "gen", "entity"});
        }
        switch (args[0].toLowerCase(Locale.ENGLISH)) {
            case "gen": {
                if (args.length > 1 && args.length <= 4) {
                    return ForgeCommand.a((String[])args, (int)1, (et)targetPos);
                }
                if (args.length == 5) {
                    return Collections.emptyList();
                }
                if (args.length != 6) break;
                return Collections.emptyList();
            }
            case "entity": {
                if (args.length == 2) {
                    return ForgeCommand.a((String[])args, (String[])new String[]{"help", "list"});
                }
                if (args.length != 3) break;
                return ForgeCommand.a((String[])args, (String[])((String[])vi.a().stream().map(e2 -> e2.toString()).sorted().toArray(String[]::new)));
            }
        }
        return Collections.emptyList();
    }

    private void handleTracking(MinecraftServer server, bn sender, String[] args) throws ei {
        if (args.length != 3) {
            throw new ep("commands.forge.usage.tracking", new Object[0]);
        }
        String type = args[1];
        int duration = ForgeCommand.a((String)args[2], (int)1, (int)60);
        if (!"te".equals(type)) {
            throw new ep("commands.forge.usage.tracking", new Object[0]);
        }
        this.doTurnOnTileEntityTracking(server, sender, duration);
    }

    private void doTurnOnTileEntityTracking(MinecraftServer server, bn sender, int duration) {
        ForgeTimeTracker.tileEntityTrackingDuration = duration;
        ForgeTimeTracker.tileEntityTracking = true;
        sender.a((hh)new hp("commands.forge.tracking.te.enabled", new Object[]{duration}));
    }

    private void doTPSLog(MinecraftServer server, bn sender, String[] args) {
    }

    private void displayTPS(MinecraftServer server, bn sender, String[] args) throws ei {
        int dim = 0;
        boolean summary = true;
        if (args.length > 1) {
            dim = ForgeCommand.a((String)args[1]);
            summary = false;
        }
        if (summary) {
            for (Integer dimId : DimensionManager.getIDs()) {
                double worldTickTime = (double)ForgeCommand.mean((long[])server.worldTickTimes.get(dimId)) * 1.0E-6;
                double worldTPS = Math.min(1000.0 / worldTickTime, 20.0);
                sender.a((hh)new hp("commands.forge.tps.summary", new Object[]{String.format("Dim %d", dimId), timeFormatter.format(worldTickTime), timeFormatter.format(worldTPS)}));
            }
            double meanTickTime = (double)ForgeCommand.mean(server.h) * 1.0E-6;
            double meanTPS = Math.min(1000.0 / meanTickTime, 20.0);
            sender.a((hh)new hp("commands.forge.tps.summary", new Object[]{"Overall", timeFormatter.format(meanTickTime), timeFormatter.format(meanTPS)}));
        } else {
            double worldTickTime = (double)ForgeCommand.mean((long[])server.worldTickTimes.get(dim)) * 1.0E-6;
            double worldTPS = Math.min(1000.0 / worldTickTime, 20.0);
            sender.a((hh)new hp("commands.forge.tps.summary", new Object[]{String.format("Dim %d", dim), timeFormatter.format(worldTickTime), timeFormatter.format(worldTPS)}));
        }
    }

    private void handleGen(MinecraftServer server, bn sender, String[] args) throws ei {
        if (args.length < 5) {
            throw new ep("commands.forge.gen.usage", new Object[0]);
        }
        et blockpos = ForgeCommand.a((bn)sender, (String[])args, (int)1, (boolean)false);
        int count = ForgeCommand.a((String)args[4], (int)10);
        int dim = args.length >= 6 ? ForgeCommand.a((String)args[5]) : sender.e().s.getDimension();
        int interval = args.length >= 7 ? ForgeCommand.a((String)args[6]) : -1;
        et chunkpos = new et(blockpos.p() >> 4, 0, blockpos.r() >> 4);
        ChunkGenWorker worker = new ChunkGenWorker(sender, chunkpos, count, dim, interval);
        sender.a((hh)worker.getStartMessage());
        WorldWorkerManager.addWorker(worker);
    }

    private static long mean(long[] values) {
        long sum = 0L;
        for (long v : values) {
            sum += v;
        }
        return sum / (long)values.length;
    }

    private void handleEntity(MinecraftServer server, bn sender, String[] args) throws ei {
        if (args.length < 2 || args[1].toLowerCase(Locale.ENGLISH).equals("help")) {
            throw new ep("commands.forge.entity.usage", new Object[0]);
        }
        switch (args[1].toLowerCase(Locale.ENGLISH)) {
            case "list": {
                String filter = "*";
                if (args.length > 2) {
                    if (args[2].toLowerCase(Locale.ENGLISH).equals("help")) {
                        throw new ep("commands.forge.entity.list.usage", new Object[0]);
                    }
                    filter = args[2];
                }
                String cleanfilter = filter.replace("?", ".?").replace("*", ".*?");
                Set names = vi.a().stream().filter(n2 -> n2.toString().matches(cleanfilter)).collect(Collectors.toSet());
                if (names.isEmpty()) {
                    throw new ep("commands.forge.entity.list.invalid", new Object[0]);
                }
                int dim = args.length > 3 ? ForgeCommand.a((String)args[3]) : sender.e().s.getDimension();
                HashMap list = Maps.newHashMap();
                oo world = DimensionManager.getWorld(dim);
                if (world == null) {
                    throw new ep("commands.forge.entity.list.invalidworld", new Object[]{dim});
                }
                List entities = world.L();
                entities.forEach(e2 -> {
                    nf key = vi.a((vg)e2);
                    MutablePair info = (MutablePair)list.get(key);
                    if (info == null) {
                        info = MutablePair.of((Object)0, (Object)Maps.newHashMap());
                        list.put(key, info);
                    }
                    amn chunk = new amn(e2.c());
                    MutablePair mutablePair = info;
                    Integer n2 = (Integer)mutablePair.left;
                    mutablePair.left = (Integer)mutablePair.left + 1;
                    Integer n3 = mutablePair.left;
                    ((Map)info.right).put(chunk, ((Map)info.right).getOrDefault(chunk, 0) + 1);
                });
                if (names.size() == 1) {
                    nf name = (nf)names.iterator().next();
                    Pair info = (Pair)list.get(name);
                    if (info == null) {
                        throw new ep("commands.forge.entity.list.none", new Object[0]);
                    }
                    sender.a((hh)new hp("commands.forge.entity.list.single.header", new Object[]{name, info.getLeft()}));
                    ((Map)info.getRight()).entrySet().stream().sorted((a2, b2) -> a2.getValue() != b2.getValue() ? (Integer)b2.getValue() - (Integer)a2.getValue() : ((amn)a2.getKey()).toString().compareTo(((amn)b2.getKey()).toString())).limit(10L).forEach(e2 -> sender.a((hh)new ho("  " + e2.getValue() + ": " + ((amn)e2.getKey()).a + ", " + ((amn)e2.getKey()).b)));
                    break;
                }
                List<Pair> info = list.entrySet().stream().filter(e2 -> names.contains(e2.getKey())).map(e2 -> Pair.of(e2.getKey(), (Object)((MutablePair)e2.getValue()).left)).sorted((a2, b2) -> a2.getRight() != b2.getRight() ? (Integer)b2.getRight() - (Integer)a2.getRight() : ((nf)a2.getKey()).toString().compareTo(((nf)b2.getKey()).toString())).collect(Collectors.toList());
                if (info == null || info.size() == 0) {
                    throw new ep("commands.forge.entity.list.none", new Object[0]);
                }
                int count = info.stream().mapToInt(a2 -> (Integer)a2.getRight()).sum();
                sender.a((hh)new hp("commands.forge.entity.list.multiple.header", new Object[]{count}));
                info.forEach(e2 -> sender.a((hh)new ho("  " + e2.getValue() + ": " + e2.getKey())));
            }
        }
    }
}

