/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.ItemFilter;
import mezz.jei.JustEnoughItems;
import mezz.jei.api.IItemListOverlay;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.config.Config;
import mezz.jei.config.Constants;
import mezz.jei.config.JEIModConfigGui;
import mezz.jei.gui.Focus;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.ingredients.GuiItemStackFast;
import mezz.jei.gui.ingredients.GuiItemStackFastList;
import mezz.jei.gui.ingredients.GuiItemStackGroup;
import mezz.jei.input.GuiTextFieldFilter;
import mezz.jei.input.ICloseable;
import mezz.jei.input.IKeyable;
import mezz.jei.input.IMouseHandler;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.network.packets.PacketDeletePlayerItem;
import mezz.jei.util.ItemStackElement;
import mezz.jei.util.Log;
import mezz.jei.util.MathUtil;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.HoverChecker;
import org.lwjgl.input.Keyboard;

public class ItemListOverlay
implements IItemListOverlay,
IShowsRecipeFocuses,
IMouseHandler,
IKeyable,
ICloseable {
    private static final int borderPadding = 2;
    private static final int searchHeight = 16;
    private static final int buttonSize = 20;
    private static final String nextLabel = ">";
    private static final String backLabel = "<";
    private static final int itemStackPadding = 1;
    private static final int itemStackWidth = GuiItemStackGroup.getWidth(1);
    private static final int itemStackHeight = GuiItemStackGroup.getHeight(1);
    private static int firstItemIndex = 0;
    @Nonnull
    private final ItemFilter itemFilter;
    @Nonnull
    private final List<IAdvancedGuiHandler<?>> advancedGuiHandlers;
    private final GuiItemStackFastList guiItemStacks = new GuiItemStackFastList();
    private GuiButton nextButton;
    private GuiButton backButton;
    private GuiButton configButton;
    private IDrawable configButtonIcon;
    private HoverChecker configButtonHoverChecker;
    private GuiTextFieldFilter searchField;
    private String pageNumDisplayString;
    private int pageNumDisplayX;
    private int pageNumDisplayY;
    private GuiItemStackFast hovered = null;
    private int guiLeft;
    private int guiXSize;
    private int screenWidth;
    private int screenHeight;
    @Nullable
    private List<Rectangle> guiAreas;
    @Nullable
    IAdvancedGuiHandler advancedGuiHandler;
    private boolean open = false;

    public ItemListOverlay(@Nonnull ItemFilter itemFilter, @Nonnull List<IAdvancedGuiHandler<?>> advancedGuiHandlers) {
        this.itemFilter = itemFilter;
        this.advancedGuiHandlers = advancedGuiHandlers;
    }

    public void initGui(@Nonnull GuiContainer guiContainer) {
        this.guiLeft = guiContainer.field_147003_i;
        this.guiXSize = guiContainer.field_146999_f;
        this.screenWidth = guiContainer.field_146294_l;
        this.screenHeight = guiContainer.field_146295_m;
        this.advancedGuiHandler = this.getAdvancedGuiHandler(guiContainer);
        this.guiAreas = this.advancedGuiHandler == null ? null : this.advancedGuiHandler.getGuiExtraAreas(guiContainer);
        int columns = this.getColumns();
        if (columns < 4) {
            this.close();
            return;
        }
        int rows = this.getRows();
        int xSize = columns * itemStackWidth;
        int xEmptySpace = this.screenWidth - this.guiLeft - this.guiXSize - xSize;
        int leftEdge = this.guiLeft + this.guiXSize + xEmptySpace / 2;
        int rightEdge = leftEdge + xSize;
        int yItemButtonSpace = this.getItemButtonYSpace();
        int itemButtonsHeight = rows * itemStackHeight;
        int buttonStartY = 24 + (yItemButtonSpace - itemButtonsHeight) / 2;
        ItemListOverlay.createItemButtons(this.guiItemStacks, this.guiAreas, leftEdge, buttonStartY, columns, rows);
        this.nextButton = new GuiButtonExt(0, rightEdge - 20, 2, 20, 20, nextLabel);
        this.backButton = new GuiButtonExt(1, leftEdge, 2, 20, 20, backLabel);
        int configButtonX = rightEdge - 20 + 1;
        int configButtonY = this.screenHeight - 20 - 2;
        this.configButton = new GuiButtonExt(2, configButtonX, configButtonY, 20, 20, null);
        ResourceLocation configButtonIconLocation = new ResourceLocation(Constants.RESOURCE_DOMAIN, "textures/gui/recipeBackground.png");
        this.configButtonIcon = Internal.getHelpers().getGuiHelper().createDrawable(configButtonIconLocation, 0, 166, 16, 16);
        this.configButtonHoverChecker = new HoverChecker(this.configButton, 0);
        int searchFieldY = this.screenHeight - 16 - 2 - 2;
        int searchFieldWidth = rightEdge - leftEdge - 20 - 1;
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.searchField = new GuiTextFieldFilter(0, fontRenderer, leftEdge, searchFieldY, searchFieldWidth, 16);
        this.setKeyboardFocus(false);
        this.searchField.setItemFilter(this.itemFilter);
        this.updateLayout();
        this.open();
    }

    @Nullable
    private IAdvancedGuiHandler<?> getAdvancedGuiHandler(@Nonnull GuiContainer guiContainer) {
        for (IAdvancedGuiHandler<?> advancedGuiHandler : this.advancedGuiHandlers) {
            if (!advancedGuiHandler.getGuiContainerClass().isAssignableFrom(guiContainer.getClass())) continue;
            return advancedGuiHandler;
        }
        return null;
    }

    public void updateGui(@Nonnull GuiContainer guiContainer) {
        List<Rectangle> guiAreas;
        if (this.guiLeft != guiContainer.field_147003_i || this.guiXSize != guiContainer.field_146999_f || this.screenWidth != guiContainer.field_146294_l || this.screenHeight != guiContainer.field_146295_m) {
            this.initGui(guiContainer);
        } else if (this.advancedGuiHandler != null && !Objects.equals(this.guiAreas, guiAreas = this.advancedGuiHandler.getGuiExtraAreas(guiContainer))) {
            this.initGui(guiContainer);
        }
    }

    private static void createItemButtons(@Nonnull GuiItemStackFastList guiItemStacks, @Nullable List<Rectangle> guiAreas, int xStart, int yStart, int columnCount, int rowCount) {
        guiItemStacks.clear();
        for (int row = 0; row < rowCount; ++row) {
            int y = yStart + row * itemStackHeight;
            for (int column = 0; column < columnCount; ++column) {
                Rectangle stackArea;
                int x = xStart + column * itemStackWidth;
                GuiItemStackFast guiItemStackFast = new GuiItemStackFast(x, y, 1);
                if (guiAreas != null && ItemListOverlay.intersects(guiAreas, stackArea = guiItemStackFast.getArea())) continue;
                guiItemStacks.add(guiItemStackFast);
            }
        }
    }

    private static boolean intersects(List<Rectangle> areas, Rectangle comparisonArea) {
        for (Rectangle area : areas) {
            if (!area.intersects(comparisonArea)) continue;
            return true;
        }
        return false;
    }

    private void updateLayout() {
        ImmutableList<ItemStackElement> itemList = this.itemFilter.getItemList();
        this.guiItemStacks.set(firstItemIndex, (List<ItemStackElement>)itemList);
        FontRenderer fontRendererObj = Minecraft.func_71410_x().field_71466_p;
        this.pageNumDisplayString = this.getPageNum() + 1 + "/" + this.getPageCount();
        int pageDisplayWidth = fontRendererObj.func_78256_a(this.pageNumDisplayString);
        this.pageNumDisplayX = (this.backButton.field_146128_h + this.backButton.field_146120_f + this.nextButton.field_146128_h) / 2 - pageDisplayWidth / 2;
        this.pageNumDisplayY = this.backButton.field_146129_i + Math.round((float)(this.backButton.field_146121_g - fontRendererObj.field_78288_b) / 2.0f);
        this.searchField.update();
    }

    private void nextPage() {
        int itemsCount = this.itemFilter.size();
        if (itemsCount == 0) {
            firstItemIndex = 0;
            return;
        }
        if ((firstItemIndex += this.guiItemStacks.size()) >= itemsCount) {
            firstItemIndex = 0;
        }
        this.updateLayout();
    }

    private void previousPage() {
        int itemsPerPage = this.guiItemStacks.size();
        if (itemsPerPage == 0) {
            firstItemIndex = 0;
            return;
        }
        int itemsCount = this.itemFilter.size();
        int pageNum = firstItemIndex / itemsPerPage;
        pageNum = pageNum == 0 ? itemsCount / itemsPerPage : --pageNum;
        firstItemIndex = itemsPerPage * pageNum;
        this.updateLayout();
    }

    public void drawScreen(@Nonnull Minecraft minecraft, int mouseX, int mouseY) {
        if (!this.isOpen()) {
            return;
        }
        GlStateManager.func_179140_f();
        minecraft.field_71466_p.func_175065_a(this.pageNumDisplayString, (float)this.pageNumDisplayX, (float)this.pageNumDisplayY, Color.white.getRGB(), true);
        this.searchField.func_146194_f();
        this.nextButton.func_146112_a(minecraft, mouseX, mouseY);
        this.backButton.func_146112_a(minecraft, mouseX, mouseY);
        this.configButton.func_146112_a(minecraft, mouseX, mouseY);
        this.configButtonIcon.draw(minecraft, this.configButton.field_146128_h + 2, this.configButton.field_146129_i + 2);
        GlStateManager.func_179084_k();
        if (this.shouldShowDeleteItemTooltip(minecraft)) {
            this.hovered = this.guiItemStacks.render(minecraft, false, mouseX, mouseY);
        } else {
            boolean mouseOver = this.isMouseOver(mouseX, mouseY);
            this.hovered = this.guiItemStacks.render(minecraft, mouseOver, mouseX, mouseY);
        }
        GlStateManager.func_179141_d();
    }

    private boolean shouldShowDeleteItemTooltip(Minecraft minecraft) {
        if (Config.isDeleteItemsInCheatModeActive()) {
            EntityPlayerSP player = minecraft.field_71439_g;
            if (player.field_71071_by.func_70445_o() != null) {
                return true;
            }
        }
        return false;
    }

    public void drawHovered(@Nonnull Minecraft minecraft, int mouseX, int mouseY) {
        if (!this.isOpen()) {
            return;
        }
        boolean mouseOver = this.isMouseOver(mouseX, mouseY);
        if (mouseOver && this.shouldShowDeleteItemTooltip(minecraft)) {
            String deleteItem = Translator.translateToLocal("jei.tooltip.delete.item");
            TooltipRenderer.drawHoveringText(minecraft, deleteItem, mouseX, mouseY);
        }
        if (this.hovered != null) {
            RenderHelper.func_74520_c();
            this.hovered.drawHovered(minecraft, mouseX, mouseY);
            RenderHelper.func_74518_a();
        }
        if (this.configButtonHoverChecker.checkHover(mouseX, mouseY)) {
            String configString = Translator.translateToLocal("jei.tooltip.config");
            TooltipRenderer.drawHoveringText(minecraft, configString, mouseX, mouseY);
        }
    }

    public void handleTick() {
        if (this.searchField != null) {
            this.searchField.func_146178_a();
        }
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        if (!this.isOpen() || mouseX < this.guiLeft + this.guiXSize) {
            return false;
        }
        if (this.guiAreas != null) {
            for (Rectangle guiArea : this.guiAreas) {
                if (!guiArea.contains(mouseX, mouseY)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @Nullable
    public Focus getFocusUnderMouse(int mouseX, int mouseY) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return null;
        }
        Focus focus = this.guiItemStacks.getFocusUnderMouse(mouseX, mouseY);
        if (focus != null) {
            this.setKeyboardFocus(false);
            focus.setAllowsCheating();
        }
        return focus;
    }

    @Override
    public boolean canSetFocusWithMouse() {
        return true;
    }

    @Override
    public boolean handleMouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean buttonClicked;
        if (!this.isMouseOver(mouseX, mouseY)) {
            this.setKeyboardFocus(false);
            return false;
        }
        if (Config.isDeleteItemsInCheatModeActive()) {
            Minecraft minecraft = Minecraft.func_71410_x();
            EntityPlayerSP player = minecraft.field_71439_g;
            ItemStack itemStack = player.field_71071_by.func_70445_o();
            if (itemStack != null) {
                player.field_71071_by.func_70437_b(null);
                PacketDeletePlayerItem packet = new PacketDeletePlayerItem(itemStack);
                JustEnoughItems.getProxy().sendPacketToServer(packet);
                return true;
            }
        }
        if (buttonClicked = this.handleMouseClickedButtons(mouseX, mouseY)) {
            this.setKeyboardFocus(false);
            return true;
        }
        return this.handleMouseClickedSearch(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean handleMouseScrolled(int mouseX, int mouseY, int scrollDelta) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        if (scrollDelta < 0) {
            this.nextPage();
            return true;
        }
        if (scrollDelta > 0) {
            this.previousPage();
            return true;
        }
        return false;
    }

    private boolean handleMouseClickedButtons(int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (this.nextButton.func_146116_c(minecraft, mouseX, mouseY)) {
            this.nextPage();
            this.nextButton.func_146113_a(minecraft.func_147118_V());
            return true;
        }
        if (this.backButton.func_146116_c(minecraft, mouseX, mouseY)) {
            this.previousPage();
            this.backButton.func_146113_a(minecraft.func_147118_V());
            return true;
        }
        if (this.configButton.func_146116_c(minecraft, mouseX, mouseY)) {
            this.close();
            this.configButton.func_146113_a(minecraft.func_147118_V());
            JEIModConfigGui configScreen = new JEIModConfigGui(minecraft.field_71462_r);
            minecraft.func_147108_a((GuiScreen)configScreen);
            return true;
        }
        return false;
    }

    private boolean handleMouseClickedSearch(int mouseX, int mouseY, int mouseButton) {
        boolean searchClicked = this.searchField.isMouseOver(mouseX, mouseY);
        this.setKeyboardFocus(searchClicked);
        if (searchClicked && this.searchField.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            this.updateLayout();
        }
        return searchClicked;
    }

    @Override
    public boolean hasKeyboardFocus() {
        return this.searchField != null && this.searchField.func_146206_l();
    }

    @Override
    public void setKeyboardFocus(boolean keyboardFocus) {
        if (this.searchField != null) {
            this.searchField.func_146195_b(keyboardFocus);
        }
    }

    @Override
    public boolean onKeyPressed(int keyCode) {
        if (this.hasKeyboardFocus()) {
            char character = Keyboard.getEventCharacter();
            boolean changed = this.searchField.func_146201_a(character, Keyboard.getEventKey());
            if (changed) {
                while (firstItemIndex >= this.itemFilter.size() && firstItemIndex > 0) {
                    this.previousPage();
                }
                this.updateLayout();
            }
            return changed || ChatAllowedCharacters.func_71566_a((char)character);
        }
        return false;
    }

    private int getItemButtonXSpace() {
        return this.screenWidth - (this.guiLeft + this.guiXSize + 4);
    }

    private int getItemButtonYSpace() {
        return this.screenHeight - 46;
    }

    private int getColumns() {
        return this.getItemButtonXSpace() / itemStackWidth;
    }

    private int getRows() {
        return this.getItemButtonYSpace() / itemStackHeight;
    }

    private int getPageCount() {
        int itemCount = this.itemFilter.size();
        int stacksPerPage = this.guiItemStacks.size();
        if (stacksPerPage == 0) {
            return 1;
        }
        int pageCount = MathUtil.divideCeil(itemCount, stacksPerPage);
        pageCount = Math.max(1, pageCount);
        return pageCount;
    }

    private int getPageNum() {
        int stacksPerPage = this.guiItemStacks.size();
        if (stacksPerPage == 0) {
            return 1;
        }
        return firstItemIndex / stacksPerPage;
    }

    public void open() {
        this.open = true;
        this.setKeyboardFocus(false);
    }

    @Override
    public void close() {
        this.open = false;
        this.setKeyboardFocus(false);
    }

    @Override
    public boolean isOpen() {
        return this.open && Config.isOverlayEnabled();
    }

    @Override
    @Nullable
    public ItemStack getStackUnderMouse() {
        if (this.hovered == null) {
            return null;
        }
        return this.hovered.getItemStack();
    }

    @Override
    public void setFilterText(@Nullable String filterText) {
        if (filterText == null) {
            Log.error("null filterText", new NullPointerException());
            return;
        }
        ItemFilter.setFilterText(filterText);
    }

    @Override
    @Nonnull
    public String getFilterText() {
        return this.itemFilter.getFilterText();
    }
}

