/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ingredients;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.gui.Focus;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.ingredients.IGuiIngredient;
import mezz.jei.gui.ingredients.IIngredientHelper;
import mezz.jei.gui.ingredients.IIngredientRenderer;
import mezz.jei.util.CycleTimer;
import mezz.jei.util.Log;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;

public class GuiIngredient<T>
extends Gui
implements IGuiIngredient<T> {
    private final int slotIndex;
    private final boolean input;
    private final int xPosition;
    private final int yPosition;
    private final int width;
    private final int height;
    private final int padding;
    @Nonnull
    private final CycleTimer cycleTimer;
    @Nonnull
    private final List<T> displayIngredients = new ArrayList<T>();
    @Nonnull
    private final List<T> allIngredients = new ArrayList<T>();
    @Nonnull
    private final IIngredientRenderer<T> ingredientRenderer;
    @Nonnull
    private final IIngredientHelper<T> ingredientHelper;
    @Nullable
    private ITooltipCallback<T> tooltipCallback;
    private boolean enabled;

    public GuiIngredient(@Nonnull IIngredientRenderer<T> ingredientRenderer, @Nonnull IIngredientHelper<T> ingredientHelper, int slotIndex, boolean input, int xPosition, int yPosition, int width, int height, int padding, int itemCycleOffset) {
        this.ingredientRenderer = ingredientRenderer;
        this.ingredientHelper = ingredientHelper;
        this.slotIndex = slotIndex;
        this.input = input;
        this.xPosition = xPosition;
        this.yPosition = yPosition;
        this.width = width;
        this.height = height;
        this.padding = padding;
        this.cycleTimer = new CycleTimer(itemCycleOffset);
    }

    @Override
    public void clear() {
        this.enabled = false;
        this.displayIngredients.clear();
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.enabled && mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
    }

    @Nullable
    public T getIngredient() {
        return this.cycleTimer.getCycledItem(this.displayIngredients);
    }

    @Override
    public Focus getFocus() {
        T ingredient = this.getIngredient();
        if (ingredient == null) {
            return null;
        }
        return this.ingredientHelper.createFocus(ingredient);
    }

    @Override
    @Nonnull
    public List<T> getAllIngredients() {
        return this.allIngredients;
    }

    @Override
    public void set(@Nonnull T ingredient, @Nonnull Focus focus) {
        this.set((Collection<T>)Collections.singleton(ingredient), focus);
    }

    @Override
    public void set(@Nonnull Collection<T> ingredients, @Nonnull Focus focus) {
        this.displayIngredients.clear();
        this.allIngredients.clear();
        ingredients = this.ingredientHelper.expandSubtypes(ingredients);
        Object match = null;
        if (this.isInput() && focus.getMode() == Focus.Mode.INPUT || !this.isInput() && focus.getMode() == Focus.Mode.OUTPUT) {
            match = this.ingredientHelper.getMatch(ingredients, focus);
        }
        if (match != null) {
            this.displayIngredients.add(match);
        } else {
            this.displayIngredients.addAll(ingredients);
        }
        this.ingredientRenderer.setIngredients(ingredients);
        this.allIngredients.addAll(ingredients);
        this.enabled = !this.displayIngredients.isEmpty();
    }

    public void setTooltipCallback(@Nullable ITooltipCallback<T> tooltipCallback) {
        this.tooltipCallback = tooltipCallback;
    }

    @Override
    public void draw(@Nonnull Minecraft minecraft) {
        this.cycleTimer.onDraw();
        T value = this.getIngredient();
        this.ingredientRenderer.draw(minecraft, this.xPosition + this.padding, this.yPosition + this.padding, value);
    }

    @Override
    public void drawHovered(@Nonnull Minecraft minecraft, int mouseX, int mouseY) {
        T value = this.getIngredient();
        if (value == null) {
            return;
        }
        this.draw(minecraft);
        this.drawTooltip(minecraft, mouseX, mouseY, value);
    }

    @Override
    public void drawHighlight(@Nonnull Minecraft minecraft, Color color, int xOffset, int yOffset) {
        int x = this.xPosition + xOffset + this.padding;
        int y = this.yPosition + yOffset + this.padding;
        GlStateManager.func_179140_f();
        GuiScreen.func_73734_a((int)x, (int)y, (int)(x + this.width - this.padding * 2), (int)(y + this.height - this.padding * 2), (int)color.getRGB());
    }

    private void drawTooltip(@Nonnull Minecraft minecraft, int mouseX, int mouseY, @Nonnull T value) {
        try {
            GlStateManager.func_179097_i();
            RenderHelper.func_74518_a();
            GuiIngredient.func_73734_a((int)(this.xPosition + this.padding), (int)(this.yPosition + this.padding), (int)(this.xPosition + this.width - this.padding), (int)(this.yPosition + this.height - this.padding), (int)Integer.MAX_VALUE);
            List<String> tooltip = this.ingredientRenderer.getTooltip(minecraft, value);
            if (this.tooltipCallback != null) {
                this.tooltipCallback.onTooltip(this.slotIndex, this.input, value, tooltip);
            }
            FontRenderer fontRenderer = this.ingredientRenderer.getFontRenderer(minecraft, value);
            TooltipRenderer.drawHoveringText(minecraft, tooltip, mouseX, mouseY, fontRenderer);
            GlStateManager.func_179126_j();
        }
        catch (RuntimeException e) {
            Log.error("Exception when rendering tooltip on {}.", value, e);
        }
    }

    @Override
    public boolean isInput() {
        return this.input;
    }
}

