/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ingredients;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.gui.ingredients.IIngredientRenderer;
import mezz.jei.util.StackHelper;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.oredict.OreDictionary;

public class ItemStackRenderer
implements IIngredientRenderer<ItemStack> {
    private static final String oreDictionaryIngredient = Translator.translateToLocal("jei.tooltip.recipe.ore.dict");
    @Nullable
    private String oreDictEquivalent;

    @Override
    public void setIngredients(@Nonnull Collection<ItemStack> itemStacks) {
        this.oreDictEquivalent = ItemStackRenderer.getOreDictEquivalent(itemStacks);
    }

    @Nullable
    private static String getOreDictEquivalent(@Nonnull Collection<ItemStack> itemStacks) {
        if (itemStacks.size() < 2) {
            return null;
        }
        StackHelper stackHelper = Internal.getStackHelper();
        ItemStack firstStack = itemStacks.iterator().next();
        if (firstStack != null) {
            for (int oreId : OreDictionary.getOreIDs((ItemStack)firstStack)) {
                String oreName = OreDictionary.getOreName((int)oreId);
                List<ItemStack> ores = OreDictionary.getOres((String)oreName);
                if (!stackHelper.containsSameStacks(itemStacks, ores = stackHelper.getAllSubtypes(ores))) continue;
                return oreName;
            }
        }
        return null;
    }

    @Override
    public void draw(@Nonnull Minecraft minecraft, int xPosition, int yPosition, @Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        FontRenderer font = this.getFontRenderer(minecraft, itemStack);
        minecraft.func_175599_af().func_180450_b(itemStack, xPosition, yPosition);
        minecraft.func_175599_af().func_180453_a(font, itemStack, xPosition, yPosition, null);
        GlStateManager.func_179084_k();
    }

    @Override
    @Nonnull
    public List<String> getTooltip(@Nonnull Minecraft minecraft, @Nonnull ItemStack itemStack) {
        List list = itemStack.func_82840_a((EntityPlayer)minecraft.field_71439_g, minecraft.field_71474_y.field_82882_x);
        for (int k = 0; k < list.size(); ++k) {
            if (k == 0) {
                list.set(k, itemStack.func_77953_t().field_77937_e + (String)list.get(k));
                continue;
            }
            list.set(k, EnumChatFormatting.GRAY + (String)list.get(k));
        }
        if (this.oreDictEquivalent != null) {
            String acceptsAny = String.format(oreDictionaryIngredient, this.oreDictEquivalent);
            list.add(EnumChatFormatting.GRAY + acceptsAny);
        }
        return list;
    }

    @Override
    public FontRenderer getFontRenderer(@Nonnull Minecraft minecraft, @Nonnull ItemStack itemStack) {
        FontRenderer fontRenderer = itemStack.func_77973_b().getFontRenderer(itemStack);
        if (fontRenderer == null) {
            fontRenderer = minecraft.field_71466_p;
        }
        return fontRenderer;
    }
}

