/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla;

import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IItemRegistry;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.INbtIgnoreList;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import mezz.jei.plugins.vanilla.brewing.BrewingRecipeCategory;
import mezz.jei.plugins.vanilla.brewing.BrewingRecipeHandler;
import mezz.jei.plugins.vanilla.brewing.BrewingRecipeMaker;
import mezz.jei.plugins.vanilla.crafting.CraftingRecipeCategory;
import mezz.jei.plugins.vanilla.crafting.ShapedOreRecipeHandler;
import mezz.jei.plugins.vanilla.crafting.ShapedRecipesHandler;
import mezz.jei.plugins.vanilla.crafting.ShapelessOreRecipeHandler;
import mezz.jei.plugins.vanilla.crafting.ShapelessRecipesHandler;
import mezz.jei.plugins.vanilla.furnace.FuelRecipeHandler;
import mezz.jei.plugins.vanilla.furnace.FuelRecipeMaker;
import mezz.jei.plugins.vanilla.furnace.FurnaceFuelCategory;
import mezz.jei.plugins.vanilla.furnace.FurnaceSmeltingCategory;
import mezz.jei.plugins.vanilla.furnace.SmeltingRecipeHandler;
import mezz.jei.plugins.vanilla.furnace.SmeltingRecipeMaker;
import net.minecraft.client.gui.inventory.GuiBrewingStand;
import net.minecraft.client.gui.inventory.GuiCrafting;
import net.minecraft.client.gui.inventory.GuiFurnace;
import net.minecraft.inventory.ContainerBrewingStand;
import net.minecraft.inventory.ContainerFurnace;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.item.crafting.CraftingManager;

@JEIPlugin
public class VanillaPlugin
implements IModPlugin {
    private IItemRegistry itemRegistry;
    private IJeiHelpers jeiHelpers;

    @Override
    public void onJeiHelpersAvailable(IJeiHelpers jeiHelpers) {
        this.jeiHelpers = jeiHelpers;
        INbtIgnoreList nbtIgnoreList = jeiHelpers.getNbtIgnoreList();
        nbtIgnoreList.ignoreNbtTagNames("AttributeModifiers", "CanDestroy", "CanPlaceOn", "display", "HideFlags", "RepairCost", "Unbreakable");
    }

    @Override
    public void onItemRegistryAvailable(IItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    @Override
    public void register(IModRegistry registry) {
        IGuiHelper guiHelper = this.jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new CraftingRecipeCategory(guiHelper), new FurnaceFuelCategory(guiHelper), new FurnaceSmeltingCategory(guiHelper), new BrewingRecipeCategory(guiHelper));
        registry.addRecipeHandlers(new ShapedOreRecipeHandler(), new ShapedRecipesHandler(), new ShapelessOreRecipeHandler(), new ShapelessRecipesHandler(), new FuelRecipeHandler(), new SmeltingRecipeHandler(), new BrewingRecipeHandler());
        registry.addRecipeClickArea(GuiCrafting.class, 88, 32, 28, 23, "minecraft.crafting");
        registry.addRecipeClickArea(GuiBrewingStand.class, 97, 16, 14, 30, "minecraft.brewing");
        registry.addRecipeClickArea(GuiFurnace.class, 78, 32, 28, 23, "minecraft.smelting", "minecraft.fuel");
        IRecipeTransferRegistry recipeTransferRegistry = registry.getRecipeTransferRegistry();
        recipeTransferRegistry.addRecipeTransferHandler(ContainerWorkbench.class, "minecraft.crafting", 1, 9, 10, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerFurnace.class, "minecraft.smelting", 0, 1, 3, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerFurnace.class, "minecraft.fuel", 1, 1, 3, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerBrewingStand.class, "minecraft.brewing", 0, 4, 4, 36);
        registry.addRecipes(CraftingManager.func_77594_a().func_77592_b());
        registry.addRecipes(SmeltingRecipeMaker.getFurnaceRecipes(this.jeiHelpers));
        registry.addRecipes(FuelRecipeMaker.getFuelRecipes(this.itemRegistry, this.jeiHelpers));
        registry.addRecipes(BrewingRecipeMaker.getBrewingRecipes(this.itemRegistry));
    }

    @Override
    public void onRecipeRegistryAvailable(IRecipeRegistry recipeRegistry) {
    }

    @Override
    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
    }
}

