/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.furnace;

import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.plugins.vanilla.furnace.FurnaceRecipeCategory;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class FurnaceSmeltingCategory
extends FurnaceRecipeCategory {
    @Nonnull
    private final IDrawable background;
    @Nonnull
    private final String localizedName;

    public FurnaceSmeltingCategory(IGuiHelper guiHelper) {
        super(guiHelper);
        ResourceLocation location = new ResourceLocation("minecraft", "textures/gui/container/furnace.png");
        this.background = guiHelper.createDrawable(location, 55, 16, 82, 54);
        this.localizedName = Translator.translateToLocal("gui.jei.category.smelting");
    }

    @Override
    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public void drawExtras(Minecraft minecraft) {
    }

    @Override
    public void drawAnimations(Minecraft minecraft) {
        this.flame.draw(minecraft, 2, 20);
        this.arrow.draw(minecraft, 24, 18);
    }

    @Override
    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Override
    @Nonnull
    public String getUid() {
        return "minecraft.smelting";
    }

    @Override
    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IRecipeWrapper recipeWrapper) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 0);
        guiItemStacks.init(2, false, 60, 18);
        guiItemStacks.setFromRecipe(0, recipeWrapper.getInputs());
        guiItemStacks.setFromRecipe(2, recipeWrapper.getOutputs());
    }
}

