/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util.color;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.util.MathUtil;
import mezz.jei.util.color.ColorThief;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public class ColorGetter {
    private static final String[] defaultColors = new String[]{"White:EEEEEE", "LightBlue:7492cc", "Cyan:00EEEE", "Blue:2222dd", "LapisBlue:25418b", "Teal:008080", "Yellow:cacb58", "GoldenYellow:EED700", "Orange:d97634", "Pink:D1899D", "HotPink:FC0FC0", "Magenta:b24bbb", "Purple:813eb9", "JadedPurple:43324f", "EvilPurple:2e1649", "Lavender:B57EDC", "Indigo:480082", "Sand:dbd3a0", "Tan:bb9b63", "LightBrown:A0522D", "Brown:634b33", "DarkBrown:3a2d13", "LimeGreen:43b239", "SlimeGreen:83cb73", "Green:008000", "DarkGreen:224d22", "GrassGreen:548049", "Red:963430", "BrickRed:b0604b", "NetherBrick:2a1516", "Redstone:ce3e36", "Black:181515", "CharcoalGray:464646", "IronGray:646464", "Gray:808080", "Silver:C0C0C0"};

    private ColorGetter() {
    }

    @Nonnull
    public static String[] getColorDefaults() {
        return defaultColors;
    }

    @Nonnull
    public static List<Color> getColors(@Nonnull ItemStack itemStack, int colorCount) {
        Item item = itemStack.func_77973_b();
        if (item == null) {
            return Collections.emptyList();
        }
        if (item instanceof ItemBlock) {
            ItemBlock itemBlock = (ItemBlock)item;
            Block block = itemBlock.func_179223_d();
            if (block == null) {
                return Collections.emptyList();
            }
            return ColorGetter.getColors(itemStack, block, colorCount);
        }
        return ColorGetter.getColors(itemStack, item, colorCount);
    }

    @Nonnull
    private static List<Color> getColors(@Nonnull ItemStack itemStack, @Nonnull Item item, int colorCount) {
        int renderColor = item.func_82790_a(itemStack, 0);
        TextureAtlasSprite textureAtlasSprite = ColorGetter.getTextureAtlasSprite(itemStack);
        if (textureAtlasSprite == null) {
            return Collections.emptyList();
        }
        return ColorGetter.getColors(textureAtlasSprite, renderColor, colorCount);
    }

    @Nonnull
    private static List<Color> getColors(@Nonnull ItemStack itemStack, @Nonnull Block block, int colorCount) {
        IBlockState blockState;
        int meta = itemStack.func_77960_j();
        try {
            blockState = block.func_176203_a(meta);
        }
        catch (IllegalArgumentException ignored) {
            blockState = block.func_176223_P();
        }
        int renderColor = block.func_180644_h(blockState);
        TextureAtlasSprite textureAtlasSprite = ColorGetter.getTextureAtlasSprite(blockState);
        if (textureAtlasSprite == null) {
            return Collections.emptyList();
        }
        return ColorGetter.getColors(textureAtlasSprite, renderColor, colorCount);
    }

    @Nonnull
    private static List<Color> getColors(@Nonnull TextureAtlasSprite textureAtlasSprite, int renderColor, int colorCount) {
        ArrayList<Color> colors = new ArrayList<Color>(colorCount);
        BufferedImage bufferedImage = ColorGetter.getBufferedImage(textureAtlasSprite);
        int[][] palette = ColorThief.getPalette(bufferedImage, colorCount);
        if (palette != null) {
            for (int[] colorInt : palette) {
                int red = (int)((float)(colorInt[0] - 1) * (float)(renderColor >> 16 & 0xFF) / 255.0f);
                int green = (int)((float)(colorInt[1] - 1) * (float)(renderColor >> 8 & 0xFF) / 255.0f);
                int blue = (int)((float)(colorInt[2] - 1) * (float)(renderColor & 0xFF) / 255.0f);
                red = MathUtil.clamp(red, 0, 255);
                green = MathUtil.clamp(green, 0, 255);
                blue = MathUtil.clamp(blue, 0, 255);
                Color color = new Color(red, green, blue);
                colors.add(color);
            }
        }
        return colors;
    }

    @Nonnull
    private static BufferedImage getBufferedImage(@Nonnull TextureAtlasSprite textureAtlasSprite) {
        int iconWidth = textureAtlasSprite.func_94211_a();
        int iconHeight = textureAtlasSprite.func_94216_b();
        BufferedImage bufferedImage = new BufferedImage(iconWidth, iconHeight * textureAtlasSprite.func_110970_k(), 6);
        for (int i = 0; i < textureAtlasSprite.func_110970_k(); ++i) {
            int[][] frameTextureData = textureAtlasSprite.func_147965_a(i);
            int[] largestMipMapTextureData = frameTextureData[0];
            bufferedImage.setRGB(0, i * iconHeight, iconWidth, iconHeight, largestMipMapTextureData, 0, iconWidth);
        }
        return bufferedImage;
    }

    @Nullable
    private static TextureAtlasSprite getTextureAtlasSprite(IBlockState blockState) {
        Minecraft minecraft = Minecraft.func_71410_x();
        BlockRendererDispatcher blockRendererDispatcher = minecraft.func_175602_ab();
        BlockModelShapes blockModelShapes = blockRendererDispatcher.func_175023_a();
        TextureAtlasSprite textureAtlasSprite = blockModelShapes.func_178122_a(blockState);
        if (textureAtlasSprite == minecraft.func_147117_R().func_174944_f()) {
            return null;
        }
        return textureAtlasSprite;
    }

    @Nullable
    private static TextureAtlasSprite getTextureAtlasSprite(ItemStack itemStack) {
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        ItemModelMesher itemModelMesher = renderItem.func_175037_a();
        IBakedModel itemModel = itemModelMesher.func_178089_a(itemStack);
        return itemModel.func_177554_e();
    }
}

