/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.security.SecureRandom;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cmc.CMCPublicationInfo;
import org.bouncycastle.asn1.crmf.PKIPublicationInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.util.test.SimpleTest;

public class CMCPublicationInfoTest
extends SimpleTest {
    @Override
    public void performTest() throws Exception {
        SecureRandom secureRandom = new SecureRandom();
        AlgorithmIdentifier testIA = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.1.2.3"), DERNull.INSTANCE);
        byte[][] hashes = new byte[5][64];
        int i = 0;
        while (i < hashes.length) {
            secureRandom.nextBytes(hashes[i]);
            ++i;
        }
        PKIPublicationInfo pinfo = PKIPublicationInfo.getInstance(new DERSequence(new ASN1Encodable[]{new ASN1Integer(1L), new DERSequence(new ASN1Integer(0L))}));
        CMCPublicationInfo cmcPublicationInfo = new CMCPublicationInfo(testIA, hashes, pinfo);
        byte[] b = cmcPublicationInfo.getEncoded();
        CMCPublicationInfo resCmcPublicationInfo = CMCPublicationInfo.getInstance(b);
        this.isEquals(resCmcPublicationInfo, cmcPublicationInfo);
        try {
            CMCPublicationInfo.getInstance(new DERSequence(new ASN1Encodable[]{testIA}));
            this.fail("Expecting exception.");
        }
        catch (Exception t) {
            this.isEquals("Wrong exception: " + t.getMessage(), t.getClass(), IllegalArgumentException.class);
        }
    }

    @Override
    public String getName() {
        return "CMCPublicationInfo";
    }

    public static void main(String[] args) {
        CMCPublicationInfoTest.runTest(new CMCPublicationInfoTest());
    }
}

