/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERApplicationSpecific;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERVisibleString;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class DERApplicationSpecificTest
extends SimpleTest {
    private static final byte[] impData = Hex.decode("430109");
    private static final byte[] certData = Hex.decode("7F218201897F4E8201495F290100420E44454356434145504153533030317F4981FD060A04007F00070202020202811CD7C134AA264366862A18302575D1D787B09F075797DA89F57EC8C0FF821C68A5E62CA9CE6C1C299803A6C1530B514E182AD8B0042A59CAD29F43831C2580F63CCFE44138870713B1A92369E33E2135D266DBB372386C400B8439040D9029AD2C7E5CF4340823B2A87DC68C9E4CE3174C1E6EFDEE12C07D58AA56F772C0726F24C6B89E4ECDAC24354B9E99CAA3F6D3761402CD851CD7C134AA264366862A18302575D0FB98D116BC4B6DDEBCA3A5A7939F863904393EE8E06DB6C7F528F8B4260B49AA93309824D92CDB1807E5437EE2E26E29B73A7111530FA86B350037CB9415E153704394463797139E148701015F200E44454356434145504153533030317F4C0E060904007F0007030102015301C15F25060007000400015F24060009000400015F37384CCF25C59F3612EEE18875F6C5F2E2D21F0395683B532A26E4C189B71EFE659C3F26E0EB9AEAE99863107F9B0DADA16414FFA204516AEE2B");
    private static final byte[] sampleData = Hex.decode("613280020780a106060456000104a203020101a305a103020101be80288006025101020109a080b2800a01000000000000000000");

    @Override
    public String getName() {
        return "DERApplicationSpecific";
    }

    private void testTaggedObject() throws Exception {
        boolean explicit = false;
        DERVisibleString type1 = new DERVisibleString("Jones");
        if (!Arrays.areEqual(Hex.decode("1A054A6F6E6573"), type1.getEncoded())) {
            this.fail("ERROR: expected value doesn't match!");
        }
        explicit = false;
        DERApplicationSpecific type2 = new DERApplicationSpecific(explicit, 3, type1);
        if (!Arrays.areEqual(Hex.decode("43054A6F6E6573"), type2.getEncoded())) {
            this.fail("ERROR: expected value doesn't match!");
        }
        explicit = true;
        DERTaggedObject type3 = new DERTaggedObject(explicit, 2, type2);
        if (!Arrays.areEqual(Hex.decode("A20743054A6F6E6573"), type3.getEncoded())) {
            this.fail("ERROR: expected value doesn't match!");
        }
        explicit = false;
        DERApplicationSpecific type4 = new DERApplicationSpecific(explicit, 7, type3);
        if (!Arrays.areEqual(Hex.decode("670743054A6F6E6573"), type4.getEncoded())) {
            this.fail("ERROR: expected value doesn't match!");
        }
        explicit = false;
        DERTaggedObject type5 = new DERTaggedObject(explicit, 2, type2);
        if (!Arrays.areEqual(Hex.decode("82054A6F6E6573"), type5.getEncoded())) {
            this.fail("ERROR: expected value doesn't match!");
        }
    }

    @Override
    public void performTest() throws Exception {
        byte[] encoded;
        DERApplicationSpecific certObj;
        ASN1Integer recVal;
        ASN1Integer value;
        DERApplicationSpecific tagged;
        this.testTaggedObject();
        DERApplicationSpecific appSpec = (DERApplicationSpecific)ASN1Primitive.fromByteArray(sampleData);
        if (1 != appSpec.getApplicationTag()) {
            this.fail("wrong tag detected");
        }
        if (!this.areEqual(impData, (tagged = new DERApplicationSpecific(false, 3, value = new ASN1Integer(9L))).getEncoded())) {
            this.fail("implicit encoding failed");
        }
        if (!value.equals(recVal = (ASN1Integer)tagged.getObject(2))) {
            this.fail("implicit read back failed");
        }
        if (!(certObj = (DERApplicationSpecific)ASN1Primitive.fromByteArray(certData)).isConstructed() || certObj.getApplicationTag() != 33) {
            this.fail("parsing of certificate data failed");
        }
        if (!Arrays.areEqual(certData, encoded = certObj.getEncoded("DER"))) {
            this.fail("re-encoding of certificate data failed");
        }
    }

    public static void main(String[] args) {
        DERApplicationSpecificTest.runTest(new DERApplicationSpecificTest());
    }
}

