/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.util.test.SimpleTest;

public class SetTest
extends SimpleTest {
    @Override
    public String getName() {
        return "Set";
    }

    private void checkedSortedSet(int attempt, ASN1Set s) {
        if (s.getObjectAt(0) instanceof ASN1Boolean && s.getObjectAt(1) instanceof ASN1Integer && s.getObjectAt(2) instanceof DERBitString && s.getObjectAt(3) instanceof DEROctetString) {
            return;
        }
        this.fail("sorting failed on attempt: " + attempt);
    }

    @Override
    public void performTest() {
        DERTaggedObject tag;
        ASN1EncodableVector v = new ASN1EncodableVector();
        byte[] data = new byte[10];
        v.add(new DEROctetString(data));
        v.add(new DERBitString(data));
        v.add(new ASN1Integer(100L));
        v.add(ASN1Boolean.getInstance(true));
        this.checkedSortedSet(0, new DERSet(v));
        v = new ASN1EncodableVector();
        v.add(new ASN1Integer(100L));
        v.add(ASN1Boolean.getInstance(true));
        v.add(new DEROctetString(data));
        v.add(new DERBitString(data));
        this.checkedSortedSet(1, new DERSet(v));
        v = new ASN1EncodableVector();
        v.add(ASN1Boolean.getInstance(true));
        v.add(new DEROctetString(data));
        v.add(new DERBitString(data));
        v.add(new ASN1Integer(100L));
        this.checkedSortedSet(2, new DERSet(v));
        v = new ASN1EncodableVector();
        v.add(new DERBitString(data));
        v.add(new DEROctetString(data));
        v.add(new ASN1Integer(100L));
        v.add(ASN1Boolean.getInstance(true));
        this.checkedSortedSet(3, new DERSet(v));
        v = new ASN1EncodableVector();
        v.add(new DEROctetString(data));
        v.add(new DERBitString(data));
        v.add(new ASN1Integer(100L));
        v.add(ASN1Boolean.getInstance(true));
        ASN1Set s = new BERSet(v);
        if (!(s.getObjectAt(0) instanceof DEROctetString)) {
            this.fail("BER set sort order changed.");
        }
        if ((s = ASN1Set.getInstance(tag = new DERTaggedObject(false, 1, new DERSequence(v)), false)).getObjectAt(0) instanceof ASN1Boolean) {
            this.fail("sorted when shouldn't be.");
        }
        v = new ASN1EncodableVector();
        v.add(ASN1Boolean.getInstance(true));
        v.add(ASN1Boolean.getInstance(true));
        v.add(ASN1Boolean.getInstance(true));
        s = new DERSet(v);
    }

    public static void main(String[] args) {
        SetTest.runTest(new SetTest());
    }
}

