/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.agreement.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import junit.framework.TestCase;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.agreement.jpake.JPAKEParticipant;
import org.bouncycastle.crypto.agreement.jpake.JPAKEPrimeOrderGroup;
import org.bouncycastle.crypto.agreement.jpake.JPAKEPrimeOrderGroups;
import org.bouncycastle.crypto.agreement.jpake.JPAKERound1Payload;
import org.bouncycastle.crypto.agreement.jpake.JPAKERound2Payload;
import org.bouncycastle.crypto.agreement.jpake.JPAKERound3Payload;
import org.bouncycastle.crypto.digests.SHA256Digest;

public class JPAKEParticipantTest
extends TestCase {
    public void testConstruction() throws CryptoException {
        JPAKEPrimeOrderGroup group = JPAKEPrimeOrderGroups.SUN_JCE_1024;
        SecureRandom random = new SecureRandom();
        SHA256Digest digest = new SHA256Digest();
        String participantId = "participantId";
        char[] password = "password".toCharArray();
        new JPAKEParticipant(participantId, password, group, digest, random);
        try {
            new JPAKEParticipant(null, password, group, digest, random);
            JPAKEParticipantTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new JPAKEParticipant(participantId, null, group, digest, random);
            JPAKEParticipantTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new JPAKEParticipant(participantId, "".toCharArray(), group, digest, random);
            JPAKEParticipantTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new JPAKEParticipant(participantId, password, null, digest, random);
            JPAKEParticipantTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new JPAKEParticipant(participantId, password, group, null, random);
            JPAKEParticipantTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new JPAKEParticipant(participantId, password, group, digest, null);
            JPAKEParticipantTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testSuccessfulExchange() throws CryptoException {
        JPAKEParticipant alice = this.createAlice();
        JPAKEParticipant bob = this.createBob();
        ExchangeAfterRound2Creation exchange = this.runExchangeUntilRound2Creation(alice, bob);
        alice.validateRound2PayloadReceived(exchange.bobRound2Payload);
        bob.validateRound2PayloadReceived(exchange.aliceRound2Payload);
        BigInteger aliceKeyingMaterial = alice.calculateKeyingMaterial();
        BigInteger bobKeyingMaterial = bob.calculateKeyingMaterial();
        JPAKERound3Payload aliceRound3Payload = alice.createRound3PayloadToSend(aliceKeyingMaterial);
        JPAKERound3Payload bobRound3Payload = bob.createRound3PayloadToSend(bobKeyingMaterial);
        alice.validateRound3PayloadReceived(bobRound3Payload, aliceKeyingMaterial);
        bob.validateRound3PayloadReceived(aliceRound3Payload, bobKeyingMaterial);
        JPAKEParticipantTest.assertEquals((Object)aliceKeyingMaterial, (Object)bobKeyingMaterial);
    }

    public void testIncorrectPassword() throws CryptoException {
        JPAKEParticipant alice = this.createAlice();
        JPAKEParticipant bob = this.createBobWithWrongPassword();
        ExchangeAfterRound2Creation exchange = this.runExchangeUntilRound2Creation(alice, bob);
        alice.validateRound2PayloadReceived(exchange.bobRound2Payload);
        bob.validateRound2PayloadReceived(exchange.aliceRound2Payload);
        BigInteger aliceKeyingMaterial = alice.calculateKeyingMaterial();
        BigInteger bobKeyingMaterial = bob.calculateKeyingMaterial();
        JPAKERound3Payload aliceRound3Payload = alice.createRound3PayloadToSend(aliceKeyingMaterial);
        JPAKERound3Payload bobRound3Payload = bob.createRound3PayloadToSend(bobKeyingMaterial);
        try {
            alice.validateRound3PayloadReceived(bobRound3Payload, aliceKeyingMaterial);
            JPAKEParticipantTest.fail();
        }
        catch (CryptoException cryptoException) {
            // empty catch block
        }
        try {
            bob.validateRound3PayloadReceived(aliceRound3Payload, bobKeyingMaterial);
            JPAKEParticipantTest.fail();
        }
        catch (CryptoException cryptoException) {
            // empty catch block
        }
    }

    public void testStateValidation() throws CryptoException {
        JPAKEParticipant alice = this.createAlice();
        JPAKEParticipant bob = this.createBob();
        JPAKEParticipantTest.assertEquals((int)0, (int)alice.getState());
        try {
            alice.createRound2PayloadToSend();
            JPAKEParticipantTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        JPAKERound1Payload aliceRound1Payload = alice.createRound1PayloadToSend();
        JPAKEParticipantTest.assertEquals((int)10, (int)alice.getState());
        try {
            alice.createRound1PayloadToSend();
            JPAKEParticipantTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            alice.createRound2PayloadToSend();
            JPAKEParticipantTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            alice.validateRound2PayloadReceived(null);
            JPAKEParticipantTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        JPAKERound1Payload bobRound1Payload = bob.createRound1PayloadToSend();
        alice.validateRound1PayloadReceived(bobRound1Payload);
        JPAKEParticipantTest.assertEquals((int)20, (int)alice.getState());
        try {
            alice.validateRound1PayloadReceived(bobRound1Payload);
            JPAKEParticipantTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        bob.validateRound1PayloadReceived(aliceRound1Payload);
        JPAKERound2Payload aliceRound2Payload = alice.createRound2PayloadToSend();
        JPAKEParticipantTest.assertEquals((int)30, (int)alice.getState());
        try {
            alice.createRound2PayloadToSend();
            JPAKEParticipantTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            alice.calculateKeyingMaterial();
            JPAKEParticipantTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            alice.validateRound3PayloadReceived(null, null);
            JPAKEParticipantTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        JPAKERound2Payload bobRound2Payload = bob.createRound2PayloadToSend();
        alice.validateRound2PayloadReceived(bobRound2Payload);
        JPAKEParticipantTest.assertEquals((int)40, (int)alice.getState());
        try {
            alice.validateRound2PayloadReceived(bobRound2Payload);
            JPAKEParticipantTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        bob.validateRound2PayloadReceived(aliceRound2Payload);
        try {
            alice.createRound3PayloadToSend(BigInteger.ONE);
            JPAKEParticipantTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        BigInteger aliceKeyingMaterial = alice.calculateKeyingMaterial();
        JPAKEParticipantTest.assertEquals((int)50, (int)alice.getState());
        try {
            alice.calculateKeyingMaterial();
            JPAKEParticipantTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        BigInteger bobKeyingMaterial = bob.calculateKeyingMaterial();
        JPAKERound3Payload aliceRound3Payload = alice.createRound3PayloadToSend(aliceKeyingMaterial);
        JPAKEParticipantTest.assertEquals((int)60, (int)alice.getState());
        try {
            alice.createRound3PayloadToSend(aliceKeyingMaterial);
            JPAKEParticipantTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        JPAKERound3Payload bobRound3Payload = bob.createRound3PayloadToSend(bobKeyingMaterial);
        alice.validateRound3PayloadReceived(bobRound3Payload, aliceKeyingMaterial);
        JPAKEParticipantTest.assertEquals((int)70, (int)alice.getState());
        try {
            alice.validateRound3PayloadReceived(bobRound3Payload, aliceKeyingMaterial);
            JPAKEParticipantTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        bob.validateRound3PayloadReceived(aliceRound3Payload, bobKeyingMaterial);
    }

    public void testValidateRound1PayloadReceived() throws CryptoException {
        JPAKERound1Payload bobRound1Payload22;
        JPAKERound1Payload bobRound1Payload = this.createBob().createRound1PayloadToSend();
        this.createAlice().validateRound1PayloadReceived(bobRound1Payload);
        try {
            JPAKEParticipant alice = this.createAlice();
            alice.validateRound1PayloadReceived(alice.createRound1PayloadToSend());
            JPAKEParticipantTest.fail();
        }
        catch (CryptoException alice) {
            // empty catch block
        }
        try {
            this.createAlice().validateRound1PayloadReceived(new JPAKERound1Payload(bobRound1Payload.getParticipantId(), bobRound1Payload.getGx1(), BigInteger.ONE, bobRound1Payload.getKnowledgeProofForX1(), bobRound1Payload.getKnowledgeProofForX2()));
            JPAKEParticipantTest.fail();
        }
        catch (CryptoException alice) {
            // empty catch block
        }
        try {
            bobRound1Payload22 = this.createBob().createRound1PayloadToSend();
            this.createAlice().validateRound1PayloadReceived(new JPAKERound1Payload(bobRound1Payload.getParticipantId(), bobRound1Payload.getGx1(), bobRound1Payload.getGx2(), bobRound1Payload22.getKnowledgeProofForX1(), bobRound1Payload.getKnowledgeProofForX2()));
            JPAKEParticipantTest.fail();
        }
        catch (CryptoException bobRound1Payload22) {
            // empty catch block
        }
        try {
            bobRound1Payload22 = this.createBob().createRound1PayloadToSend();
            this.createAlice().validateRound1PayloadReceived(new JPAKERound1Payload(bobRound1Payload.getParticipantId(), bobRound1Payload.getGx1(), bobRound1Payload.getGx2(), bobRound1Payload.getKnowledgeProofForX1(), bobRound1Payload22.getKnowledgeProofForX2()));
            JPAKEParticipantTest.fail();
        }
        catch (CryptoException cryptoException) {
            // empty catch block
        }
    }

    public void testValidateRound2PayloadReceived() throws CryptoException {
        ExchangeAfterRound2Creation exchange1 = this.runExchangeUntilRound2Creation(this.createAlice(), this.createBob());
        exchange1.alice.validateRound2PayloadReceived(exchange1.bobRound2Payload);
        ExchangeAfterRound2Creation exchange2 = this.runExchangeUntilRound2Creation(this.createAlice(), this.createBob());
        try {
            exchange2.alice.validateRound2PayloadReceived(exchange2.aliceRound2Payload);
            JPAKEParticipantTest.fail();
        }
        catch (CryptoException cryptoException) {
            // empty catch block
        }
        ExchangeAfterRound2Creation exchange3 = this.runExchangeUntilRound2Creation(this.createAlice(), this.createBob());
        ExchangeAfterRound2Creation exchange4 = this.runExchangeUntilRound2Creation(this.createAlice(), this.createBob());
        try {
            exchange3.alice.validateRound2PayloadReceived(exchange4.bobRound2Payload);
            JPAKEParticipantTest.fail();
        }
        catch (CryptoException cryptoException) {
            // empty catch block
        }
    }

    private ExchangeAfterRound2Creation runExchangeUntilRound2Creation(JPAKEParticipant alice, JPAKEParticipant bob) throws CryptoException {
        JPAKERound1Payload aliceRound1Payload = alice.createRound1PayloadToSend();
        JPAKERound1Payload bobRound1Payload = bob.createRound1PayloadToSend();
        alice.validateRound1PayloadReceived(bobRound1Payload);
        bob.validateRound1PayloadReceived(aliceRound1Payload);
        JPAKERound2Payload aliceRound2Payload = alice.createRound2PayloadToSend();
        JPAKERound2Payload bobRound2Payload = bob.createRound2PayloadToSend();
        return new ExchangeAfterRound2Creation(alice, aliceRound2Payload, bobRound2Payload);
    }

    private JPAKEParticipant createAlice() {
        return this.createParticipant("alice", "password");
    }

    private JPAKEParticipant createBob() {
        return this.createParticipant("bob", "password");
    }

    private JPAKEParticipant createBobWithWrongPassword() {
        return this.createParticipant("bob", "wrong");
    }

    private JPAKEParticipant createParticipant(String participantId, String password) {
        return new JPAKEParticipant(participantId, password.toCharArray(), JPAKEPrimeOrderGroups.SUN_JCE_1024);
    }

    private static class ExchangeAfterRound2Creation {
        public JPAKEParticipant alice;
        public JPAKERound2Payload aliceRound2Payload;
        public JPAKERound2Payload bobRound2Payload;

        public ExchangeAfterRound2Creation(JPAKEParticipant alice, JPAKERound2Payload aliceRound2Payload, JPAKERound2Payload bobRound2Payload) {
            this.alice = alice;
            this.aliceRound2Payload = aliceRound2Payload;
            this.bobRound2Payload = bobRound2Payload;
        }
    }
}

