/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes.gcm;

import org.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import org.bouncycastle.crypto.modes.gcm.GCMUtil;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public class Tables8kGCMMultiplier
implements GCMMultiplier {
    private byte[] H;
    private long[][][] T;

    @Override
    public void init(byte[] H) {
        if (this.T == null) {
            this.T = new long[32][16][2];
        } else if (Arrays.areEqual(this.H, H)) {
            return;
        }
        this.H = Arrays.clone(H);
        int i = 0;
        while (i < 32) {
            long[][] t = this.T[i];
            if (i == 0) {
                GCMUtil.asLongs(this.H, t[1]);
                GCMUtil.multiplyP3(t[1], t[1]);
            } else {
                GCMUtil.multiplyP4(this.T[i - 1][1], t[1]);
            }
            int n = 2;
            while (n < 16) {
                GCMUtil.divideP(t[n >> 1], t[n]);
                GCMUtil.xor(t[n], t[1], t[n + 1]);
                n += 2;
            }
            ++i;
        }
    }

    @Override
    public void multiplyH(byte[] x) {
        long z0 = 0L;
        long z1 = 0L;
        int i = 15;
        while (i >= 0) {
            long[] u = this.T[i + i + 1][x[i] & 0xF];
            long[] v = this.T[i + i][(x[i] & 0xF0) >>> 4];
            z0 ^= u[0] ^ v[0];
            z1 ^= u[1] ^ v[1];
            --i;
        }
        Pack.longToBigEndian(z0, x, 0);
        Pack.longToBigEndian(z1, x, 8);
    }
}

