/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.prng.test;

import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.prng.EntropySource;
import org.bouncycastle.util.encoders.Hex;

public class DRBGTestVector {
    private Digest _digest;
    private BlockCipher _cipher;
    private int _keySizeInBits;
    private EntropySource _eSource;
    private boolean _pr;
    private String _nonce;
    private String _personalisation;
    private int _ss;
    private String[] _ev;
    private List _ai = new ArrayList();

    public DRBGTestVector(Digest digest, EntropySource eSource, boolean predictionResistance, String nonce, int securityStrength, String[] expected) {
        this._digest = digest;
        this._eSource = eSource;
        this._pr = predictionResistance;
        this._nonce = nonce;
        this._ss = securityStrength;
        this._ev = expected;
        this._personalisation = null;
    }

    public DRBGTestVector(BlockCipher cipher, int keySizeInBits, EntropySource eSource, boolean predictionResistance, String nonce, int securityStrength, String[] expected) {
        this._cipher = cipher;
        this._keySizeInBits = keySizeInBits;
        this._eSource = eSource;
        this._pr = predictionResistance;
        this._nonce = nonce;
        this._ss = securityStrength;
        this._ev = expected;
        this._personalisation = null;
    }

    public Digest getDigest() {
        return this._digest;
    }

    public BlockCipher getCipher() {
        return this._cipher;
    }

    public int keySizeInBits() {
        return this._keySizeInBits;
    }

    public DRBGTestVector addAdditionalInput(String input) {
        this._ai.add(input);
        return this;
    }

    public DRBGTestVector setPersonalizationString(String p) {
        this._personalisation = p;
        return this;
    }

    public EntropySource entropySource() {
        return this._eSource;
    }

    public boolean predictionResistance() {
        return this._pr;
    }

    public byte[] nonce() {
        if (this._nonce == null) {
            return null;
        }
        return Hex.decode(this._nonce);
    }

    public byte[] personalizationString() {
        if (this._personalisation == null) {
            return null;
        }
        return Hex.decode(this._personalisation);
    }

    public int securityStrength() {
        return this._ss;
    }

    public byte[] expectedValue(int index) {
        return Hex.decode(this._ev[index]);
    }

    public byte[] additionalInput(int position) {
        int len = this._ai.size();
        byte[] rv = position >= len ? null : Hex.decode((String)this._ai.get(position));
        return rv;
    }
}

