/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.asn1.pkcs.RSAPublicKey;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.encodings.OAEPEncoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class OAEPTest
extends SimpleTest {
    static byte[] pubKeyEnc1;
    static byte[] privKeyEnc1;
    static byte[] output1;
    static byte[] pubKeyEnc2;
    static byte[] privKeyEnc2;
    static byte[] output2;
    static byte[] pubKeyEnc3;
    static byte[] privKeyEnc3;
    static byte[] output3;
    byte[] seed = new byte[]{-86, -3, 18, -10, 89, -54, -26, 52, -119, -76, 121, -27, 7, 109, -34, -62, -16, 108, -75, -113};
    byte[] modulus_1024 = Hex.decode("a8b3b284af8eb50b387034a860f146c4919f318763cd6c5598c8ae4811a1e0abc4c7e0b082d693a5e7fced675cf4668512772c0cbc64a742c6c630f533c8cc72f62ae833c40bf25842e984bb78bdbf97c0107d55bdb662f5c4e0fab9845cb5148ef7392dd3aaff93ae1e6b667bb3d4247616d4f5ba10d4cfd226de88d39f16fb");
    byte[] pubExp_1024 = Hex.decode("010001");
    byte[] privExp_1024 = Hex.decode("53339cfdb79fc8466a655c7316aca85c55fd8f6dd898fdaf119517ef4f52e8fd8e258df93fee180fa0e4ab29693cd83b152a553d4ac4d1812b8b9fa5af0e7f55fe7304df41570926f3311f15c4d65a732c483116ee3d3d2d0af3549ad9bf7cbfb78ad884f84d5beb04724dc7369b31def37d0cf539e9cfcdd3de653729ead5d1");
    byte[] prime1_1024 = Hex.decode("d32737e7267ffe1341b2d5c0d150a81b586fb3132bed2f8d5262864a9cb9f30af38be448598d413a172efb802c21acf1c11c520c2f26a471dcad212eac7ca39d");
    byte[] prime2_1024 = Hex.decode("cc8853d1d54da630fac004f471f281c7b8982d8224a490edbeb33d3e3d5cc93c4765703d1dd791642f1f116a0dd852be2419b2af72bfe9a030e860b0288b5d77");
    byte[] primeExp1_1024 = Hex.decode("0e12bf1718e9cef5599ba1c3882fe8046a90874eefce8f2ccc20e4f2741fb0a33a3848aec9c9305fbecbd2d76819967d4671acc6431e4037968db37878e695c1");
    byte[] primeExp2_1024 = Hex.decode("95297b0f95a2fa67d00707d609dfd4fc05c89dafc2ef6d6ea55bec771ea333734d9251e79082ecda866efef13c459e1a631386b7e354c899f5f112ca85d71583");
    byte[] crtCoef_1024 = Hex.decode("4f456c502493bdc0ed2ab756a3a6ed4d67352a697d4216e93212b127a63d5411ce6fa98d5dbefd73263e3728142743818166ed7dd63687dd2a8ca1d2f4fbd8e1");
    byte[] input_1024_1 = Hex.decode("6628194e12073db03ba94cda9ef9532397d50dba79b987004afefe34");
    byte[] seed_1024_1 = Hex.decode("18b776ea21069d69776a33e96bad48e1dda0a5ef");
    byte[] output_1024_1 = Hex.decode("354fe67b4a126d5d35fe36c777791a3f7ba13def484e2d3908aff722fad468fb21696de95d0be911c2d3174f8afcc201035f7b6d8e69402de5451618c21a535fa9d7bfc5b8dd9fc243f8cf927db31322d6e881eaa91a996170e657a05a266426d98c88003f8477c1227094a0d9fa1e8c4024309ce1ecccb5210035d47ac72e8a");
    byte[] input_1024_2 = Hex.decode("750c4047f547e8e41411856523298ac9bae245efaf1397fbe56f9dd5");
    byte[] seed_1024_2 = Hex.decode("0cc742ce4a9b7f32f951bcb251efd925fe4fe35f");
    byte[] output_1024_2 = Hex.decode("640db1acc58e0568fe5407e5f9b701dff8c3c91e716c536fc7fcec6cb5b71c1165988d4a279e1577d730fc7a29932e3f00c81515236d8d8e31017a7a09df4352d904cdeb79aa583adcc31ea698a4c05283daba9089be5491f67c1a4ee48dc74bbbe6643aef846679b4cb395a352d5ed115912df696ffe0702932946d71492b44");
    byte[] input_1024_3 = Hex.decode("d94ae0832e6445ce42331cb06d531a82b1db4baad30f746dc916df24d4e3c2451fff59a6423eb0e1d02d4fe646cf699dfd818c6e97b051");
    byte[] seed_1024_3 = Hex.decode("2514df4695755a67b288eaf4905c36eec66fd2fd");
    byte[] output_1024_3 = Hex.decode("423736ed035f6026af276c35c0b3741b365e5f76ca091b4e8c29e2f0befee603595aa8322d602d2e625e95eb81b2f1c9724e822eca76db8618cf09c5343503a4360835b5903bc637e3879fb05e0ef32685d5aec5067cd7cc96fe4b2670b6eac3066b1fcf5686b68589aafb7d629b02d8f8625ca3833624d4800fb081b1cf94eb");
    byte[] input_1024_4 = Hex.decode("52e650d98e7f2a048b4f86852153b97e01dd316f346a19f67a85");
    byte[] seed_1024_4 = Hex.decode("c4435a3e1a18a68b6820436290a37cefb85db3fb");
    byte[] output_1024_4 = Hex.decode("45ead4ca551e662c9800f1aca8283b0525e6abae30be4b4aba762fa40fd3d38e22abefc69794f6ebbbc05ddbb11216247d2f412fd0fba87c6e3acd888813646fd0e48e785204f9c3f73d6d8239562722dddd8771fec48b83a31ee6f592c4cfd4bc88174f3b13a112aae3b9f7b80e0fc6f7255ba880dc7d8021e22ad6a85f0755");
    byte[] input_1024_5 = Hex.decode("8da89fd9e5f974a29feffb462b49180f6cf9e802");
    byte[] seed_1024_5 = Hex.decode("b318c42df3be0f83fea823f5a7b47ed5e425a3b5");
    byte[] output_1024_5 = Hex.decode("36f6e34d94a8d34daacba33a2139d00ad85a9345a86051e73071620056b920e219005855a213a0f23897cdcd731b45257c777fe908202befdd0b58386b1244ea0cf539a05d5d10329da44e13030fd760dcd644cfef2094d1910d3f433e1c7c6dd18bc1f2df7f643d662fb9dd37ead9059190f4fa66ca39e869c4eb449cbdc439");
    byte[] input_1024_6 = Hex.decode("26521050844271");
    byte[] seed_1024_6 = Hex.decode("e4ec0982c2336f3a677f6a356174eb0ce887abc2");
    byte[] output_1024_6 = Hex.decode("42cee2617b1ecea4db3f4829386fbd61dafbf038e180d837c96366df24c097b4ab0fac6bdf590d821c9f10642e681ad05b8d78b378c0f46ce2fad63f74e0ad3df06b075d7eb5f5636f8d403b9059ca761b5c62bb52aa45002ea70baace08ded243b9d8cbd62a68ade265832b56564e43a6fa42ed199a099769742df1539e8255");
    byte[] modulus_1027 = Hex.decode("051240b6cc0004fa48d0134671c078c7c8dec3b3e2f25bc2564467339db38853d06b85eea5b2de353bff42ac2e46bc97fae6ac9618da9537a5c8f553c1e357625991d6108dcd7885fb3a25413f53efcad948cb35cd9b9ae9c1c67626d113d57dde4c5bea76bb5bb7de96c00d07372e9685a6d75cf9d239fa148d70931b5f3fb039");
    byte[] pubExp_1027 = Hex.decode("010001");
    byte[] privExp_1027 = Hex.decode("0411ffca3b7ca5e9e9be7fe38a85105e353896db05c5796aecd2a725161eb3651c8629a9b862b904d7b0c7b37f8cb5a1c2b54001018a00a1eb2cafe4ee4e9492c348bc2bedab4b9ebbf064e8eff322b9009f8eec653905f40df88a3cdc49d4567f75627d41aca624129b46a0b7c698e5e65f2b7ba102c749a10135b6540d0401");
    byte[] prime1_1027 = Hex.decode("027458c19ec1636919e736c9af25d609a51b8f561d19c6bf6943dd1ee1ab8a4a3f232100bd40b88decc6ba235548b6ef792a11c9de823d0a7922c7095b6eba5701");
    byte[] prime2_1027 = Hex.decode("0210ee9b33ab61716e27d251bd465f4b35a1a232e2da00901c294bf22350ce490d099f642b5375612db63ba1f20386492bf04d34b3c22bceb909d13441b53b5139");
    byte[] primeExp1_1027 = Hex.decode("39fa028b826e88c1121b750a8b242fa9a35c5b66bdfd1fa637d3cc48a84a4f457a194e7727e49f7bcc6e5a5a412657fc470c7322ebc37416ef458c307a8c0901");
    byte[] primeExp2_1027 = Hex.decode("015d99a84195943979fa9e1be2c3c1b69f432f46fd03e47d5befbbbfd6b1d1371d83efb330a3e020942b2fed115e5d02be24fd92c9019d1cecd6dd4cf1e54cc899");
    byte[] crtCoef_1027 = Hex.decode("01f0b7015170b3f5e42223ba30301c41a6d87cbb70e30cb7d3c67d25473db1f6cbf03e3f9126e3e97968279a865b2c2b426524cfc52a683d31ed30eb984be412ba");
    byte[] input_1027_1 = Hex.decode("4a86609534ee434a6cbca3f7e962e76d455e3264c19f605f6e5ff6137c65c56d7fb344cd52bc93374f3d166c9f0c6f9c506bad19330972d2");
    byte[] seed_1027_1 = Hex.decode("1cac19ce993def55f98203f6852896c95ccca1f3");
    byte[] output_1027_1 = Hex.decode("04cce19614845e094152a3fe18e54e3330c44e5efbc64ae16886cb1869014cc5781b1f8f9e045384d0112a135ca0d12e9c88a8e4063416deaae3844f60d6e96fe155145f4525b9a34431ca3766180f70e15a5e5d8e8b1a516ff870609f13f896935ced188279a58ed13d07114277d75c6568607e0ab092fd803a223e4a8ee0b1a8");
    byte[] input_1027_2 = Hex.decode("b0adc4f3fe11da59ce992773d9059943c03046497ee9d9f9a06df1166db46d98f58d27ec074c02eee6cbe2449c8b9fc5080c5c3f4433092512ec46aa793743c8");
    byte[] seed_1027_2 = Hex.decode("f545d5897585e3db71aa0cb8da76c51d032ae963");
    byte[] output_1027_2 = Hex.decode("0097b698c6165645b303486fbf5a2a4479c0ee85889b541a6f0b858d6b6597b13b854eb4f839af03399a80d79bda6578c841f90d645715b280d37143992dd186c80b949b775cae97370e4ec97443136c6da484e970ffdb1323a20847821d3b18381de13bb49aaea66530c4a4b8271f3eae172cd366e07e6636f1019d2a28aed15e");
    byte[] input_1027_3 = Hex.decode("bf6d42e701707b1d0206b0c8b45a1c72641ff12889219a82bdea965b5e79a96b0d0163ed9d578ec9ada20f2fbcf1ea3c4089d83419ba81b0c60f3606da99");
    byte[] seed_1027_3 = Hex.decode("ad997feef730d6ea7be60d0dc52e72eacbfdd275");
    byte[] output_1027_3 = Hex.decode("0301f935e9c47abcb48acbbe09895d9f5971af14839da4ff95417ee453d1fd77319072bb7297e1b55d7561cd9d1bb24c1a9a37c619864308242804879d86ebd001dce5183975e1506989b70e5a83434154d5cbfd6a24787e60eb0c658d2ac193302d1192c6e622d4a12ad4b53923bca246df31c6395e37702c6a78ae081fb9d065");
    byte[] input_1027_4 = Hex.decode("fb2ef112f5e766eb94019297934794f7be2f6fc1c58e");
    byte[] seed_1027_4 = Hex.decode("136454df5730f73c807a7e40d8c1a312ac5b9dd3");
    byte[] output_1027_4 = Hex.decode("02d110ad30afb727beb691dd0cf17d0af1a1e7fa0cc040ec1a4ba26a42c59d0a796a2e22c8f357ccc98b6519aceb682e945e62cb734614a529407cd452bee3e44fece8423cc19e55548b8b994b849c7ecde4933e76037e1d0ce44275b08710c68e430130b929730ed77e09b015642c5593f04e4ffb9410798102a8e96ffdfe11e4");
    byte[] input_1027_5 = Hex.decode("28ccd447bb9e85166dabb9e5b7d1adadc4b9d39f204e96d5e440ce9ad928bc1c2284");
    byte[] seed_1027_5 = Hex.decode("bca8057f824b2ea257f2861407eef63d33208681");
    byte[] output_1027_5 = Hex.decode("00dbb8a7439d90efd919a377c54fae8fe11ec58c3b858362e23ad1b8a44310799066b99347aa525691d2adc58d9b06e34f288c170390c5f0e11c0aa3645959f18ee79e8f2be8d7ac5c23d061f18dd74b8c5f2a58fcb5eb0c54f99f01a83247568292536583340948d7a8c97c4acd1e98d1e29dc320e97a260532a8aa7a758a1ec2");
    byte[] input_1027_6 = Hex.decode("f22242751ec6b1");
    byte[] seed_1027_6 = Hex.decode("2e7e1e17f647b5ddd033e15472f90f6812f3ac4e");
    byte[] output_1027_6 = Hex.decode("00a5ffa4768c8bbecaee2db77e8f2eec99595933545520835e5ba7db9493d3e17cddefe6a5f567624471908db4e2d83a0fbee60608fc84049503b2234a07dc83b27b22847ad8920ff42f674ef79b76280b00233d2b51b8cb2703a9d42bfbc8250c96ec32c051e57f1b4ba528db89c37e4c54e27e6e64ac69635ae887d9541619a9");

    static {
        byte[] byArray = new byte[92];
        byArray[0] = 48;
        byArray[1] = 90;
        byArray[2] = 48;
        byArray[3] = 13;
        byArray[4] = 6;
        byArray[5] = 9;
        byArray[6] = 42;
        byArray[7] = -122;
        byArray[8] = 72;
        byArray[9] = -122;
        byArray[10] = -9;
        byArray[11] = 13;
        byArray[12] = 1;
        byArray[13] = 1;
        byArray[14] = 1;
        byArray[15] = 5;
        byArray[17] = 3;
        byArray[18] = 73;
        byArray[20] = 48;
        byArray[21] = 70;
        byArray[22] = 2;
        byArray[23] = 65;
        byArray[25] = -86;
        byArray[26] = 54;
        byArray[27] = -85;
        byArray[28] = -50;
        byArray[29] = -120;
        byArray[30] = -84;
        byArray[31] = -3;
        byArray[32] = -1;
        byArray[33] = 85;
        byArray[34] = 82;
        byArray[35] = 60;
        byArray[36] = 127;
        byArray[37] = -60;
        byArray[38] = 82;
        byArray[39] = 63;
        byArray[40] = -112;
        byArray[41] = -17;
        byArray[42] = -96;
        byArray[43] = 13;
        byArray[44] = -13;
        byArray[45] = 119;
        byArray[46] = 74;
        byArray[47] = 37;
        byArray[48] = -97;
        byArray[49] = 46;
        byArray[50] = 98;
        byArray[51] = -76;
        byArray[52] = -59;
        byArray[53] = -39;
        byArray[54] = -100;
        byArray[55] = -75;
        byArray[56] = -83;
        byArray[57] = -77;
        byArray[59] = -96;
        byArray[60] = 40;
        byArray[61] = 94;
        byArray[62] = 83;
        byArray[63] = 1;
        byArray[64] = -109;
        byArray[65] = 14;
        byArray[66] = 12;
        byArray[67] = 112;
        byArray[68] = -5;
        byArray[69] = 104;
        byArray[70] = 118;
        byArray[71] = -109;
        byArray[72] = -100;
        byArray[73] = -26;
        byArray[74] = 22;
        byArray[75] = -50;
        byArray[76] = 98;
        byArray[77] = 74;
        byArray[78] = 17;
        byArray[79] = -32;
        byArray[80] = 8;
        byArray[81] = 109;
        byArray[82] = 52;
        byArray[83] = 30;
        byArray[84] = -68;
        byArray[85] = -84;
        byArray[86] = -96;
        byArray[87] = -95;
        byArray[88] = -11;
        byArray[89] = 2;
        byArray[90] = 1;
        byArray[91] = 17;
        pubKeyEnc1 = byArray;
        byte[] byArray2 = new byte[342];
        byArray2[0] = 48;
        byArray2[1] = -126;
        byArray2[2] = 1;
        byArray2[3] = 82;
        byArray2[4] = 2;
        byArray2[5] = 1;
        byArray2[7] = 48;
        byArray2[8] = 13;
        byArray2[9] = 6;
        byArray2[10] = 9;
        byArray2[11] = 42;
        byArray2[12] = -122;
        byArray2[13] = 72;
        byArray2[14] = -122;
        byArray2[15] = -9;
        byArray2[16] = 13;
        byArray2[17] = 1;
        byArray2[18] = 1;
        byArray2[19] = 1;
        byArray2[20] = 5;
        byArray2[22] = 4;
        byArray2[23] = -126;
        byArray2[24] = 1;
        byArray2[25] = 60;
        byArray2[26] = 48;
        byArray2[27] = -126;
        byArray2[28] = 1;
        byArray2[29] = 56;
        byArray2[30] = 2;
        byArray2[31] = 1;
        byArray2[33] = 2;
        byArray2[34] = 65;
        byArray2[36] = -86;
        byArray2[37] = 54;
        byArray2[38] = -85;
        byArray2[39] = -50;
        byArray2[40] = -120;
        byArray2[41] = -84;
        byArray2[42] = -3;
        byArray2[43] = -1;
        byArray2[44] = 85;
        byArray2[45] = 82;
        byArray2[46] = 60;
        byArray2[47] = 127;
        byArray2[48] = -60;
        byArray2[49] = 82;
        byArray2[50] = 63;
        byArray2[51] = -112;
        byArray2[52] = -17;
        byArray2[53] = -96;
        byArray2[54] = 13;
        byArray2[55] = -13;
        byArray2[56] = 119;
        byArray2[57] = 74;
        byArray2[58] = 37;
        byArray2[59] = -97;
        byArray2[60] = 46;
        byArray2[61] = 98;
        byArray2[62] = -76;
        byArray2[63] = -59;
        byArray2[64] = -39;
        byArray2[65] = -100;
        byArray2[66] = -75;
        byArray2[67] = -83;
        byArray2[68] = -77;
        byArray2[70] = -96;
        byArray2[71] = 40;
        byArray2[72] = 94;
        byArray2[73] = 83;
        byArray2[74] = 1;
        byArray2[75] = -109;
        byArray2[76] = 14;
        byArray2[77] = 12;
        byArray2[78] = 112;
        byArray2[79] = -5;
        byArray2[80] = 104;
        byArray2[81] = 118;
        byArray2[82] = -109;
        byArray2[83] = -100;
        byArray2[84] = -26;
        byArray2[85] = 22;
        byArray2[86] = -50;
        byArray2[87] = 98;
        byArray2[88] = 74;
        byArray2[89] = 17;
        byArray2[90] = -32;
        byArray2[91] = 8;
        byArray2[92] = 109;
        byArray2[93] = 52;
        byArray2[94] = 30;
        byArray2[95] = -68;
        byArray2[96] = -84;
        byArray2[97] = -96;
        byArray2[98] = -95;
        byArray2[99] = -11;
        byArray2[100] = 2;
        byArray2[101] = 1;
        byArray2[102] = 17;
        byArray2[103] = 2;
        byArray2[104] = 64;
        byArray2[105] = 10;
        byArray2[106] = 3;
        byArray2[107] = 55;
        byArray2[108] = 72;
        byArray2[109] = 98;
        byArray2[110] = 100;
        byArray2[111] = -121;
        byArray2[112] = 105;
        byArray2[113] = 95;
        byArray2[114] = 95;
        byArray2[115] = 48;
        byArray2[116] = -68;
        byArray2[117] = 56;
        byArray2[118] = -71;
        byArray2[119] = -117;
        byArray2[120] = 68;
        byArray2[121] = -62;
        byArray2[122] = -51;
        byArray2[123] = 45;
        byArray2[124] = -1;
        byArray2[125] = 67;
        byArray2[126] = 64;
        byArray2[127] = -104;
        byArray2[128] = -51;
        byArray2[129] = 32;
        byArray2[130] = -40;
        byArray2[131] = -95;
        byArray2[132] = 56;
        byArray2[133] = -48;
        byArray2[134] = -112;
        byArray2[135] = -65;
        byArray2[136] = 100;
        byArray2[137] = 121;
        byArray2[138] = 124;
        byArray2[139] = 63;
        byArray2[140] = -89;
        byArray2[141] = -94;
        byArray2[142] = -51;
        byArray2[143] = -53;
        byArray2[144] = 60;
        byArray2[145] = -47;
        byArray2[146] = -32;
        byArray2[147] = -67;
        byArray2[148] = -70;
        byArray2[149] = 38;
        byArray2[150] = 84;
        byArray2[151] = -76;
        byArray2[152] = -7;
        byArray2[153] = -33;
        byArray2[154] = -114;
        byArray2[155] = -118;
        byArray2[156] = -27;
        byArray2[157] = -99;
        byArray2[158] = 115;
        byArray2[159] = 61;
        byArray2[160] = -97;
        byArray2[161] = 51;
        byArray2[162] = -77;
        byArray2[163] = 1;
        byArray2[164] = 98;
        byArray2[165] = 74;
        byArray2[166] = -3;
        byArray2[167] = 29;
        byArray2[168] = 81;
        byArray2[169] = 2;
        byArray2[170] = 33;
        byArray2[172] = -40;
        byArray2[173] = 64;
        byArray2[174] = -76;
        byArray2[175] = 22;
        byArray2[176] = 102;
        byArray2[177] = -76;
        byArray2[178] = 46;
        byArray2[179] = -110;
        byArray2[180] = -22;
        byArray2[181] = 13;
        byArray2[182] = -93;
        byArray2[183] = -76;
        byArray2[184] = 50;
        byArray2[185] = 4;
        byArray2[186] = -75;
        byArray2[187] = -49;
        byArray2[188] = -50;
        byArray2[189] = 51;
        byArray2[190] = 82;
        byArray2[191] = 82;
        byArray2[192] = 77;
        byArray2[193] = 4;
        byArray2[194] = 22;
        byArray2[195] = -91;
        byArray2[196] = -92;
        byArray2[197] = 65;
        byArray2[198] = -25;
        byArray2[200] = -81;
        byArray2[201] = 70;
        byArray2[202] = 18;
        byArray2[203] = 13;
        byArray2[204] = 2;
        byArray2[205] = 33;
        byArray2[207] = -55;
        byArray2[208] = 127;
        byArray2[209] = -79;
        byArray2[210] = -16;
        byArray2[211] = 39;
        byArray2[212] = -12;
        byArray2[213] = 83;
        byArray2[214] = -10;
        byArray2[215] = 52;
        byArray2[216] = 18;
        byArray2[217] = 51;
        byArray2[218] = -22;
        byArray2[219] = -86;
        byArray2[220] = -47;
        byArray2[221] = -39;
        byArray2[222] = 53;
        byArray2[223] = 63;
        byArray2[224] = 108;
        byArray2[225] = 66;
        byArray2[226] = -48;
        byArray2[227] = -120;
        byArray2[228] = 102;
        byArray2[229] = -79;
        byArray2[230] = -48;
        byArray2[231] = 90;
        byArray2[232] = 15;
        byArray2[233] = 32;
        byArray2[234] = 53;
        byArray2[235] = 2;
        byArray2[236] = -117;
        byArray2[237] = -99;
        byArray2[238] = -119;
        byArray2[239] = 2;
        byArray2[240] = 32;
        byArray2[241] = 89;
        byArray2[242] = 11;
        byArray2[243] = -107;
        byArray2[244] = 114;
        byArray2[245] = -94;
        byArray2[246] = -62;
        byArray2[247] = -87;
        byArray2[248] = -60;
        byArray2[249] = 6;
        byArray2[250] = 5;
        byArray2[251] = -99;
        byArray2[252] = -62;
        byArray2[253] = -85;
        byArray2[254] = 47;
        byArray2[255] = 29;
        byArray2[256] = -81;
        byArray2[257] = -21;
        byArray2[258] = 126;
        byArray2[259] = -117;
        byArray2[260] = 79;
        byArray2[261] = 16;
        byArray2[262] = -89;
        byArray2[263] = 84;
        byArray2[264] = -98;
        byArray2[265] = -114;
        byArray2[266] = -19;
        byArray2[267] = -11;
        byArray2[268] = -76;
        byArray2[269] = -4;
        byArray2[270] = -32;
        byArray2[271] = -98;
        byArray2[272] = 5;
        byArray2[273] = 2;
        byArray2[274] = 33;
        byArray2[276] = -114;
        byArray2[277] = 60;
        byArray2[278] = 5;
        byArray2[279] = 33;
        byArray2[280] = -2;
        byArray2[281] = 21;
        byArray2[282] = -32;
        byArray2[283] = -22;
        byArray2[284] = 6;
        byArray2[285] = -93;
        byArray2[286] = 111;
        byArray2[287] = -16;
        byArray2[288] = -15;
        byArray2[289] = 12;
        byArray2[290] = -103;
        byArray2[291] = 82;
        byArray2[292] = -61;
        byArray2[293] = 91;
        byArray2[294] = 122;
        byArray2[295] = 117;
        byArray2[296] = 20;
        byArray2[297] = -3;
        byArray2[298] = 50;
        byArray2[299] = 56;
        byArray2[300] = -72;
        byArray2[301] = 10;
        byArray2[302] = -83;
        byArray2[303] = 82;
        byArray2[304] = -104;
        byArray2[305] = 98;
        byArray2[306] = -115;
        byArray2[307] = 81;
        byArray2[308] = 2;
        byArray2[309] = 32;
        byArray2[310] = 54;
        byArray2[311] = 63;
        byArray2[312] = -9;
        byArray2[313] = 24;
        byArray2[314] = -99;
        byArray2[315] = -88;
        byArray2[316] = -23;
        byArray2[317] = 11;
        byArray2[318] = 29;
        byArray2[319] = 52;
        byArray2[320] = 31;
        byArray2[321] = 113;
        byArray2[322] = -48;
        byArray2[323] = -101;
        byArray2[324] = 118;
        byArray2[325] = -88;
        byArray2[326] = -87;
        byArray2[327] = 67;
        byArray2[328] = -31;
        byArray2[329] = 29;
        byArray2[330] = 16;
        byArray2[331] = -78;
        byArray2[332] = 77;
        byArray2[333] = 36;
        byArray2[334] = -97;
        byArray2[335] = 45;
        byArray2[336] = -22;
        byArray2[337] = -2;
        byArray2[338] = -8;
        byArray2[339] = 12;
        byArray2[340] = 24;
        byArray2[341] = 38;
        privKeyEnc1 = byArray2;
        output1 = new byte[]{27, -113, 5, -7, -54, 26, 121, 82, 110, 83, -13, -52, 81, 79, -37, -119, 43, -5, -111, -109, 35, 30, 120, -71, -110, -26, -115, 80, -92, -128, -53, 82, 51, -119, 92, 116, -107, -115, 93, 2, -85, -116, 15, -48, 64, -21, 88, 68, -80, 5, -61, -98, -40, 39, 74, -99, -65, -88, 6, 113, 64, -108, 57, -46};
        byte[] byArray3 = new byte[78];
        byArray3[0] = 48;
        byArray3[1] = 76;
        byArray3[2] = 48;
        byArray3[3] = 13;
        byArray3[4] = 6;
        byArray3[5] = 9;
        byArray3[6] = 42;
        byArray3[7] = -122;
        byArray3[8] = 72;
        byArray3[9] = -122;
        byArray3[10] = -9;
        byArray3[11] = 13;
        byArray3[12] = 1;
        byArray3[13] = 1;
        byArray3[14] = 1;
        byArray3[15] = 5;
        byArray3[17] = 3;
        byArray3[18] = 59;
        byArray3[20] = 48;
        byArray3[21] = 56;
        byArray3[22] = 2;
        byArray3[23] = 51;
        byArray3[25] = -93;
        byArray3[26] = 7;
        byArray3[27] = -102;
        byArray3[28] = -112;
        byArray3[29] = -33;
        byArray3[30] = 13;
        byArray3[31] = -3;
        byArray3[32] = 114;
        byArray3[33] = -84;
        byArray3[34] = 9;
        byArray3[35] = 12;
        byArray3[36] = -52;
        byArray3[37] = 42;
        byArray3[38] = 120;
        byArray3[39] = -72;
        byArray3[40] = 116;
        byArray3[41] = 19;
        byArray3[42] = 19;
        byArray3[43] = 62;
        byArray3[44] = 64;
        byArray3[45] = 117;
        byArray3[46] = -100;
        byArray3[47] = -104;
        byArray3[48] = -6;
        byArray3[49] = -8;
        byArray3[50] = 32;
        byArray3[51] = 79;
        byArray3[52] = 53;
        byArray3[53] = -118;
        byArray3[54] = 11;
        byArray3[55] = 38;
        byArray3[56] = 60;
        byArray3[57] = 103;
        byArray3[58] = 112;
        byArray3[59] = -25;
        byArray3[60] = -125;
        byArray3[61] = -87;
        byArray3[62] = 59;
        byArray3[63] = 105;
        byArray3[64] = 113;
        byArray3[65] = -73;
        byArray3[66] = 55;
        byArray3[67] = 121;
        byArray3[68] = -46;
        byArray3[69] = 113;
        byArray3[70] = 123;
        byArray3[71] = -24;
        byArray3[72] = 52;
        byArray3[73] = 119;
        byArray3[74] = -49;
        byArray3[75] = 2;
        byArray3[76] = 1;
        byArray3[77] = 3;
        pubKeyEnc2 = byArray3;
        byte[] byArray4 = new byte[279];
        byArray4[0] = 48;
        byArray4[1] = -126;
        byArray4[2] = 1;
        byArray4[3] = 19;
        byArray4[4] = 2;
        byArray4[5] = 1;
        byArray4[7] = 48;
        byArray4[8] = 13;
        byArray4[9] = 6;
        byArray4[10] = 9;
        byArray4[11] = 42;
        byArray4[12] = -122;
        byArray4[13] = 72;
        byArray4[14] = -122;
        byArray4[15] = -9;
        byArray4[16] = 13;
        byArray4[17] = 1;
        byArray4[18] = 1;
        byArray4[19] = 1;
        byArray4[20] = 5;
        byArray4[22] = 4;
        byArray4[23] = -127;
        byArray4[24] = -2;
        byArray4[25] = 48;
        byArray4[26] = -127;
        byArray4[27] = -5;
        byArray4[28] = 2;
        byArray4[29] = 1;
        byArray4[31] = 2;
        byArray4[32] = 51;
        byArray4[34] = -93;
        byArray4[35] = 7;
        byArray4[36] = -102;
        byArray4[37] = -112;
        byArray4[38] = -33;
        byArray4[39] = 13;
        byArray4[40] = -3;
        byArray4[41] = 114;
        byArray4[42] = -84;
        byArray4[43] = 9;
        byArray4[44] = 12;
        byArray4[45] = -52;
        byArray4[46] = 42;
        byArray4[47] = 120;
        byArray4[48] = -72;
        byArray4[49] = 116;
        byArray4[50] = 19;
        byArray4[51] = 19;
        byArray4[52] = 62;
        byArray4[53] = 64;
        byArray4[54] = 117;
        byArray4[55] = -100;
        byArray4[56] = -104;
        byArray4[57] = -6;
        byArray4[58] = -8;
        byArray4[59] = 32;
        byArray4[60] = 79;
        byArray4[61] = 53;
        byArray4[62] = -118;
        byArray4[63] = 11;
        byArray4[64] = 38;
        byArray4[65] = 60;
        byArray4[66] = 103;
        byArray4[67] = 112;
        byArray4[68] = -25;
        byArray4[69] = -125;
        byArray4[70] = -87;
        byArray4[71] = 59;
        byArray4[72] = 105;
        byArray4[73] = 113;
        byArray4[74] = -73;
        byArray4[75] = 55;
        byArray4[76] = 121;
        byArray4[77] = -46;
        byArray4[78] = 113;
        byArray4[79] = 123;
        byArray4[80] = -24;
        byArray4[81] = 52;
        byArray4[82] = 119;
        byArray4[83] = -49;
        byArray4[84] = 2;
        byArray4[85] = 1;
        byArray4[86] = 3;
        byArray4[87] = 2;
        byArray4[88] = 50;
        byArray4[89] = 108;
        byArray4[90] = -81;
        byArray4[91] = -68;
        byArray4[92] = 96;
        byArray4[93] = -108;
        byArray4[94] = -77;
        byArray4[95] = -2;
        byArray4[96] = 76;
        byArray4[97] = 114;
        byArray4[98] = -80;
        byArray4[99] = -77;
        byArray4[100] = 50;
        byArray4[101] = -58;
        byArray4[102] = -5;
        byArray4[103] = 37;
        byArray4[104] = -94;
        byArray4[105] = -73;
        byArray4[106] = 98;
        byArray4[107] = 41;
        byArray4[108] = -128;
        byArray4[109] = 78;
        byArray4[110] = 104;
        byArray4[111] = 101;
        byArray4[112] = -4;
        byArray4[113] = -92;
        byArray4[114] = 90;
        byArray4[115] = 116;
        byArray4[116] = -33;
        byArray4[117] = 15;
        byArray4[118] = -113;
        byArray4[119] = -72;
        byArray4[120] = 65;
        byArray4[121] = 59;
        byArray4[122] = 82;
        byArray4[123] = -64;
        byArray4[124] = -48;
        byArray4[125] = -27;
        byArray4[126] = 61;
        byArray4[127] = -101;
        byArray4[128] = 89;
        byArray4[129] = 15;
        byArray4[130] = -15;
        byArray4[131] = -101;
        byArray4[132] = -25;
        byArray4[133] = -97;
        byArray4[134] = 73;
        byArray4[135] = -35;
        byArray4[136] = 33;
        byArray4[137] = -27;
        byArray4[138] = -21;
        byArray4[139] = 2;
        byArray4[140] = 26;
        byArray4[142] = -49;
        byArray4[143] = 32;
        byArray4[144] = 53;
        byArray4[145] = 2;
        byArray4[146] = -117;
        byArray4[147] = -99;
        byArray4[148] = -122;
        byArray4[149] = -104;
        byArray4[150] = 64;
        byArray4[151] = -76;
        byArray4[152] = 22;
        byArray4[153] = 102;
        byArray4[154] = -76;
        byArray4[155] = 46;
        byArray4[156] = -110;
        byArray4[157] = -22;
        byArray4[158] = 13;
        byArray4[159] = -93;
        byArray4[160] = -76;
        byArray4[161] = 50;
        byArray4[162] = 4;
        byArray4[163] = -75;
        byArray4[164] = -49;
        byArray4[165] = -50;
        byArray4[166] = -111;
        byArray4[167] = 2;
        byArray4[168] = 26;
        byArray4[170] = -55;
        byArray4[171] = 127;
        byArray4[172] = -79;
        byArray4[173] = -16;
        byArray4[174] = 39;
        byArray4[175] = -12;
        byArray4[176] = 83;
        byArray4[177] = -10;
        byArray4[178] = 52;
        byArray4[179] = 18;
        byArray4[180] = 51;
        byArray4[181] = -22;
        byArray4[182] = -86;
        byArray4[183] = -47;
        byArray4[184] = -39;
        byArray4[185] = 53;
        byArray4[186] = 63;
        byArray4[187] = 108;
        byArray4[188] = 66;
        byArray4[189] = -48;
        byArray4[190] = -120;
        byArray4[191] = 102;
        byArray4[192] = -79;
        byArray4[193] = -48;
        byArray4[194] = 95;
        byArray4[195] = 2;
        byArray4[196] = 26;
        byArray4[198] = -118;
        byArray4[199] = 21;
        byArray4[200] = 120;
        byArray4[201] = -84;
        byArray4[202] = 93;
        byArray4[203] = 19;
        byArray4[204] = -81;
        byArray4[205] = 16;
        byArray4[206] = 43;
        byArray4[207] = 34;
        byArray4[208] = -71;
        byArray4[209] = -103;
        byArray4[210] = -51;
        byArray4[211] = 116;
        byArray4[212] = 97;
        byArray4[213] = -15;
        byArray4[214] = 94;
        byArray4[215] = 109;
        byArray4[216] = 34;
        byArray4[217] = -52;
        byArray4[218] = 3;
        byArray4[219] = 35;
        byArray4[220] = -33;
        byArray4[221] = -33;
        byArray4[222] = 11;
        byArray4[223] = 2;
        byArray4[224] = 26;
        byArray4[226] = -122;
        byArray4[227] = 85;
        byArray4[228] = 33;
        byArray4[229] = 74;
        byArray4[230] = -59;
        byArray4[231] = 77;
        byArray4[232] = -115;
        byArray4[233] = 78;
        byArray4[234] = -51;
        byArray4[235] = 97;
        byArray4[236] = 119;
        byArray4[237] = -15;
        byArray4[238] = -57;
        byArray4[239] = 54;
        byArray4[240] = -112;
        byArray4[241] = -50;
        byArray4[242] = 42;
        byArray4[243] = 72;
        byArray4[244] = 44;
        byArray4[245] = -117;
        byArray4[246] = 5;
        byArray4[247] = -103;
        byArray4[248] = -53;
        byArray4[249] = -32;
        byArray4[250] = 63;
        byArray4[251] = 2;
        byArray4[252] = 26;
        byArray4[254] = -125;
        byArray4[255] = -17;
        byArray4[256] = -17;
        byArray4[257] = -72;
        byArray4[258] = -87;
        byArray4[259] = -92;
        byArray4[260] = 13;
        byArray4[261] = 29;
        byArray4[262] = -74;
        byArray4[263] = -19;
        byArray4[264] = -104;
        byArray4[265] = -83;
        byArray4[266] = -124;
        byArray4[267] = -19;
        byArray4[268] = 19;
        byArray4[269] = 53;
        byArray4[270] = -36;
        byArray4[271] = -63;
        byArray4[272] = 8;
        byArray4[273] = -13;
        byArray4[274] = 34;
        byArray4[275] = -48;
        byArray4[276] = 87;
        byArray4[277] = -49;
        byArray4[278] = -115;
        privKeyEnc2 = byArray4;
        output2 = new byte[]{20, -67, -35, 40, -55, -125, 53, 25, 35, -128, -24, -27, 73, -79, 88, 42, -117, 64, -76, 72, 109, 3, -90, -91, 49, 31, 31, -43, -16, -95, -128, -28, 23, 83, 3, 41, -87, 52, -112, 116, -79, 82, 19, 84, 41, 8, 36, 82, 98, 81};
        byte[] byArray5 = new byte[160];
        byArray5[0] = 48;
        byArray5[1] = -127;
        byArray5[2] = -99;
        byArray5[3] = 48;
        byArray5[4] = 13;
        byArray5[5] = 6;
        byArray5[6] = 9;
        byArray5[7] = 42;
        byArray5[8] = -122;
        byArray5[9] = 72;
        byArray5[10] = -122;
        byArray5[11] = -9;
        byArray5[12] = 13;
        byArray5[13] = 1;
        byArray5[14] = 1;
        byArray5[15] = 1;
        byArray5[16] = 5;
        byArray5[18] = 3;
        byArray5[19] = -127;
        byArray5[20] = -117;
        byArray5[22] = 48;
        byArray5[23] = -127;
        byArray5[24] = -121;
        byArray5[25] = 2;
        byArray5[26] = -127;
        byArray5[27] = -127;
        byArray5[29] = -69;
        byArray5[30] = -8;
        byArray5[31] = 47;
        byArray5[32] = 9;
        byArray5[33] = 6;
        byArray5[34] = -126;
        byArray5[35] = -50;
        byArray5[36] = -100;
        byArray5[37] = 35;
        byArray5[38] = 56;
        byArray5[39] = -84;
        byArray5[40] = 43;
        byArray5[41] = -99;
        byArray5[42] = -88;
        byArray5[43] = 113;
        byArray5[44] = -9;
        byArray5[45] = 54;
        byArray5[46] = -115;
        byArray5[47] = 7;
        byArray5[48] = -18;
        byArray5[49] = -44;
        byArray5[50] = 16;
        byArray5[51] = 67;
        byArray5[52] = -92;
        byArray5[53] = 64;
        byArray5[54] = -42;
        byArray5[55] = -74;
        byArray5[56] = -16;
        byArray5[57] = 116;
        byArray5[58] = 84;
        byArray5[59] = -11;
        byArray5[60] = 31;
        byArray5[61] = -72;
        byArray5[62] = -33;
        byArray5[63] = -70;
        byArray5[64] = -81;
        byArray5[65] = 3;
        byArray5[66] = 92;
        byArray5[67] = 2;
        byArray5[68] = -85;
        byArray5[69] = 97;
        byArray5[70] = -22;
        byArray5[71] = 72;
        byArray5[72] = -50;
        byArray5[73] = -21;
        byArray5[74] = 111;
        byArray5[75] = -51;
        byArray5[76] = 72;
        byArray5[77] = 118;
        byArray5[78] = -19;
        byArray5[79] = 82;
        byArray5[80] = 13;
        byArray5[81] = 96;
        byArray5[82] = -31;
        byArray5[83] = -20;
        byArray5[84] = 70;
        byArray5[85] = 25;
        byArray5[86] = 113;
        byArray5[87] = -99;
        byArray5[88] = -118;
        byArray5[89] = 91;
        byArray5[90] = -117;
        byArray5[91] = -128;
        byArray5[92] = 127;
        byArray5[93] = -81;
        byArray5[94] = -72;
        byArray5[95] = -32;
        byArray5[96] = -93;
        byArray5[97] = -33;
        byArray5[98] = -57;
        byArray5[99] = 55;
        byArray5[100] = 114;
        byArray5[101] = 62;
        byArray5[102] = -26;
        byArray5[103] = -76;
        byArray5[104] = -73;
        byArray5[105] = -39;
        byArray5[106] = 58;
        byArray5[107] = 37;
        byArray5[108] = -124;
        byArray5[109] = -18;
        byArray5[110] = 106;
        byArray5[111] = 100;
        byArray5[112] = -99;
        byArray5[113] = 6;
        byArray5[114] = 9;
        byArray5[115] = 83;
        byArray5[116] = 116;
        byArray5[117] = -120;
        byArray5[118] = 52;
        byArray5[119] = -78;
        byArray5[120] = 69;
        byArray5[121] = 69;
        byArray5[122] = -104;
        byArray5[123] = 57;
        byArray5[124] = 78;
        byArray5[125] = -32;
        byArray5[126] = -86;
        byArray5[127] = -79;
        byArray5[128] = 45;
        byArray5[129] = 123;
        byArray5[130] = 97;
        byArray5[131] = -91;
        byArray5[132] = 31;
        byArray5[133] = 82;
        byArray5[134] = 122;
        byArray5[135] = -102;
        byArray5[136] = 65;
        byArray5[137] = -10;
        byArray5[138] = -63;
        byArray5[139] = 104;
        byArray5[140] = 127;
        byArray5[141] = -30;
        byArray5[142] = 83;
        byArray5[143] = 114;
        byArray5[144] = -104;
        byArray5[145] = -54;
        byArray5[146] = 42;
        byArray5[147] = -113;
        byArray5[148] = 89;
        byArray5[149] = 70;
        byArray5[150] = -8;
        byArray5[151] = -27;
        byArray5[152] = -3;
        byArray5[153] = 9;
        byArray5[154] = 29;
        byArray5[155] = -67;
        byArray5[156] = -53;
        byArray5[157] = 2;
        byArray5[158] = 1;
        byArray5[159] = 17;
        pubKeyEnc3 = byArray5;
        byte[] byArray6 = new byte[633];
        byArray6[0] = 48;
        byArray6[1] = -126;
        byArray6[2] = 2;
        byArray6[3] = 117;
        byArray6[4] = 2;
        byArray6[5] = 1;
        byArray6[7] = 48;
        byArray6[8] = 13;
        byArray6[9] = 6;
        byArray6[10] = 9;
        byArray6[11] = 42;
        byArray6[12] = -122;
        byArray6[13] = 72;
        byArray6[14] = -122;
        byArray6[15] = -9;
        byArray6[16] = 13;
        byArray6[17] = 1;
        byArray6[18] = 1;
        byArray6[19] = 1;
        byArray6[20] = 5;
        byArray6[22] = 4;
        byArray6[23] = -126;
        byArray6[24] = 2;
        byArray6[25] = 95;
        byArray6[26] = 48;
        byArray6[27] = -126;
        byArray6[28] = 2;
        byArray6[29] = 91;
        byArray6[30] = 2;
        byArray6[31] = 1;
        byArray6[33] = 2;
        byArray6[34] = -127;
        byArray6[35] = -127;
        byArray6[37] = -69;
        byArray6[38] = -8;
        byArray6[39] = 47;
        byArray6[40] = 9;
        byArray6[41] = 6;
        byArray6[42] = -126;
        byArray6[43] = -50;
        byArray6[44] = -100;
        byArray6[45] = 35;
        byArray6[46] = 56;
        byArray6[47] = -84;
        byArray6[48] = 43;
        byArray6[49] = -99;
        byArray6[50] = -88;
        byArray6[51] = 113;
        byArray6[52] = -9;
        byArray6[53] = 54;
        byArray6[54] = -115;
        byArray6[55] = 7;
        byArray6[56] = -18;
        byArray6[57] = -44;
        byArray6[58] = 16;
        byArray6[59] = 67;
        byArray6[60] = -92;
        byArray6[61] = 64;
        byArray6[62] = -42;
        byArray6[63] = -74;
        byArray6[64] = -16;
        byArray6[65] = 116;
        byArray6[66] = 84;
        byArray6[67] = -11;
        byArray6[68] = 31;
        byArray6[69] = -72;
        byArray6[70] = -33;
        byArray6[71] = -70;
        byArray6[72] = -81;
        byArray6[73] = 3;
        byArray6[74] = 92;
        byArray6[75] = 2;
        byArray6[76] = -85;
        byArray6[77] = 97;
        byArray6[78] = -22;
        byArray6[79] = 72;
        byArray6[80] = -50;
        byArray6[81] = -21;
        byArray6[82] = 111;
        byArray6[83] = -51;
        byArray6[84] = 72;
        byArray6[85] = 118;
        byArray6[86] = -19;
        byArray6[87] = 82;
        byArray6[88] = 13;
        byArray6[89] = 96;
        byArray6[90] = -31;
        byArray6[91] = -20;
        byArray6[92] = 70;
        byArray6[93] = 25;
        byArray6[94] = 113;
        byArray6[95] = -99;
        byArray6[96] = -118;
        byArray6[97] = 91;
        byArray6[98] = -117;
        byArray6[99] = -128;
        byArray6[100] = 127;
        byArray6[101] = -81;
        byArray6[102] = -72;
        byArray6[103] = -32;
        byArray6[104] = -93;
        byArray6[105] = -33;
        byArray6[106] = -57;
        byArray6[107] = 55;
        byArray6[108] = 114;
        byArray6[109] = 62;
        byArray6[110] = -26;
        byArray6[111] = -76;
        byArray6[112] = -73;
        byArray6[113] = -39;
        byArray6[114] = 58;
        byArray6[115] = 37;
        byArray6[116] = -124;
        byArray6[117] = -18;
        byArray6[118] = 106;
        byArray6[119] = 100;
        byArray6[120] = -99;
        byArray6[121] = 6;
        byArray6[122] = 9;
        byArray6[123] = 83;
        byArray6[124] = 116;
        byArray6[125] = -120;
        byArray6[126] = 52;
        byArray6[127] = -78;
        byArray6[128] = 69;
        byArray6[129] = 69;
        byArray6[130] = -104;
        byArray6[131] = 57;
        byArray6[132] = 78;
        byArray6[133] = -32;
        byArray6[134] = -86;
        byArray6[135] = -79;
        byArray6[136] = 45;
        byArray6[137] = 123;
        byArray6[138] = 97;
        byArray6[139] = -91;
        byArray6[140] = 31;
        byArray6[141] = 82;
        byArray6[142] = 122;
        byArray6[143] = -102;
        byArray6[144] = 65;
        byArray6[145] = -10;
        byArray6[146] = -63;
        byArray6[147] = 104;
        byArray6[148] = 127;
        byArray6[149] = -30;
        byArray6[150] = 83;
        byArray6[151] = 114;
        byArray6[152] = -104;
        byArray6[153] = -54;
        byArray6[154] = 42;
        byArray6[155] = -113;
        byArray6[156] = 89;
        byArray6[157] = 70;
        byArray6[158] = -8;
        byArray6[159] = -27;
        byArray6[160] = -3;
        byArray6[161] = 9;
        byArray6[162] = 29;
        byArray6[163] = -67;
        byArray6[164] = -53;
        byArray6[165] = 2;
        byArray6[166] = 1;
        byArray6[167] = 17;
        byArray6[168] = 2;
        byArray6[169] = -127;
        byArray6[170] = -127;
        byArray6[172] = -91;
        byArray6[173] = -38;
        byArray6[174] = -4;
        byArray6[175] = 83;
        byArray6[176] = 65;
        byArray6[177] = -6;
        byArray6[178] = -14;
        byArray6[179] = -119;
        byArray6[180] = -60;
        byArray6[181] = -71;
        byArray6[182] = -120;
        byArray6[183] = -37;
        byArray6[184] = 48;
        byArray6[185] = -63;
        byArray6[186] = -51;
        byArray6[187] = -8;
        byArray6[188] = 63;
        byArray6[189] = 49;
        byArray6[190] = 37;
        byArray6[191] = 30;
        byArray6[192] = 6;
        byArray6[193] = 104;
        byArray6[194] = -76;
        byArray6[195] = 39;
        byArray6[196] = -124;
        byArray6[197] = -127;
        byArray6[198] = 56;
        byArray6[199] = 1;
        byArray6[200] = 87;
        byArray6[201] = -106;
        byArray6[202] = 65;
        byArray6[203] = -78;
        byArray6[204] = -108;
        byArray6[205] = 16;
        byArray6[206] = -77;
        byArray6[207] = -57;
        byArray6[208] = -103;
        byArray6[209] = -115;
        byArray6[210] = 107;
        byArray6[211] = -60;
        byArray6[212] = 101;
        byArray6[213] = 116;
        byArray6[214] = 94;
        byArray6[215] = 92;
        byArray6[216] = 57;
        byArray6[217] = 38;
        byArray6[218] = 105;
        byArray6[219] = -42;
        byArray6[220] = -121;
        byArray6[221] = 13;
        byArray6[222] = -94;
        byArray6[223] = -64;
        byArray6[224] = -126;
        byArray6[225] = -87;
        byArray6[226] = 57;
        byArray6[227] = -29;
        byArray6[228] = 127;
        byArray6[229] = -36;
        byArray6[230] = -72;
        byArray6[231] = 46;
        byArray6[232] = -55;
        byArray6[233] = 62;
        byArray6[234] = -38;
        byArray6[235] = -55;
        byArray6[236] = 127;
        byArray6[237] = -13;
        byArray6[238] = -83;
        byArray6[239] = 89;
        byArray6[240] = 80;
        byArray6[241] = -84;
        byArray6[242] = -49;
        byArray6[243] = -68;
        byArray6[244] = 17;
        byArray6[245] = 28;
        byArray6[246] = 118;
        byArray6[247] = -15;
        byArray6[248] = -87;
        byArray6[249] = 82;
        byArray6[250] = -108;
        byArray6[251] = 68;
        byArray6[252] = -27;
        byArray6[253] = 106;
        byArray6[254] = -81;
        byArray6[255] = 104;
        byArray6[256] = -59;
        byArray6[257] = 108;
        byArray6[258] = 9;
        byArray6[259] = 44;
        byArray6[260] = -45;
        byArray6[261] = -115;
        byArray6[262] = -61;
        byArray6[263] = -66;
        byArray6[264] = -11;
        byArray6[265] = -46;
        byArray6[266] = 10;
        byArray6[267] = -109;
        byArray6[268] = -103;
        byArray6[269] = 38;
        byArray6[270] = -19;
        byArray6[271] = 79;
        byArray6[272] = 116;
        byArray6[273] = -95;
        byArray6[274] = 62;
        byArray6[275] = -35;
        byArray6[276] = -5;
        byArray6[277] = -31;
        byArray6[278] = -95;
        byArray6[279] = -50;
        byArray6[280] = -52;
        byArray6[281] = 72;
        byArray6[282] = -108;
        byArray6[283] = -81;
        byArray6[284] = -108;
        byArray6[285] = 40;
        byArray6[286] = -62;
        byArray6[287] = -73;
        byArray6[288] = -72;
        byArray6[289] = -120;
        byArray6[290] = 63;
        byArray6[291] = -28;
        byArray6[292] = 70;
        byArray6[293] = 58;
        byArray6[294] = 75;
        byArray6[295] = -56;
        byArray6[296] = 91;
        byArray6[297] = 28;
        byArray6[298] = -77;
        byArray6[299] = -63;
        byArray6[300] = 2;
        byArray6[301] = 65;
        byArray6[303] = -18;
        byArray6[304] = -49;
        byArray6[305] = -82;
        byArray6[306] = -127;
        byArray6[307] = -79;
        byArray6[308] = -71;
        byArray6[309] = -77;
        byArray6[310] = -55;
        byArray6[311] = 8;
        byArray6[312] = -127;
        byArray6[313] = 11;
        byArray6[314] = 16;
        byArray6[315] = -95;
        byArray6[316] = -75;
        byArray6[317] = 96;
        byArray6[318] = 1;
        byArray6[319] = -103;
        byArray6[320] = -21;
        byArray6[321] = -97;
        byArray6[322] = 68;
        byArray6[323] = -82;
        byArray6[324] = -12;
        byArray6[325] = -3;
        byArray6[326] = -92;
        byArray6[327] = -109;
        byArray6[328] = -72;
        byArray6[329] = 26;
        byArray6[330] = -98;
        byArray6[331] = 61;
        byArray6[332] = -124;
        byArray6[333] = -10;
        byArray6[334] = 50;
        byArray6[335] = 18;
        byArray6[336] = 78;
        byArray6[337] = -16;
        byArray6[338] = 35;
        byArray6[339] = 110;
        byArray6[340] = 93;
        byArray6[341] = 30;
        byArray6[342] = 59;
        byArray6[343] = 126;
        byArray6[344] = 40;
        byArray6[345] = -6;
        byArray6[346] = -25;
        byArray6[347] = -86;
        byArray6[348] = 4;
        byArray6[349] = 10;
        byArray6[350] = 45;
        byArray6[351] = 91;
        byArray6[352] = 37;
        byArray6[353] = 33;
        byArray6[354] = 118;
        byArray6[355] = 69;
        byArray6[356] = -99;
        byArray6[357] = 31;
        byArray6[358] = 57;
        byArray6[359] = 117;
        byArray6[360] = 65;
        byArray6[361] = -70;
        byArray6[362] = 42;
        byArray6[363] = 88;
        byArray6[364] = -5;
        byArray6[365] = 101;
        byArray6[366] = -103;
        byArray6[367] = 2;
        byArray6[368] = 65;
        byArray6[370] = -55;
        byArray6[371] = 127;
        byArray6[372] = -79;
        byArray6[373] = -16;
        byArray6[374] = 39;
        byArray6[375] = -12;
        byArray6[376] = 83;
        byArray6[377] = -10;
        byArray6[378] = 52;
        byArray6[379] = 18;
        byArray6[380] = 51;
        byArray6[381] = -22;
        byArray6[382] = -86;
        byArray6[383] = -47;
        byArray6[384] = -39;
        byArray6[385] = 53;
        byArray6[386] = 63;
        byArray6[387] = 108;
        byArray6[388] = 66;
        byArray6[389] = -48;
        byArray6[390] = -120;
        byArray6[391] = 102;
        byArray6[392] = -79;
        byArray6[393] = -48;
        byArray6[394] = 90;
        byArray6[395] = 15;
        byArray6[396] = 32;
        byArray6[397] = 53;
        byArray6[398] = 2;
        byArray6[399] = -117;
        byArray6[400] = -99;
        byArray6[401] = -122;
        byArray6[402] = -104;
        byArray6[403] = 64;
        byArray6[404] = -76;
        byArray6[405] = 22;
        byArray6[406] = 102;
        byArray6[407] = -76;
        byArray6[408] = 46;
        byArray6[409] = -110;
        byArray6[410] = -22;
        byArray6[411] = 13;
        byArray6[412] = -93;
        byArray6[413] = -76;
        byArray6[414] = 50;
        byArray6[415] = 4;
        byArray6[416] = -75;
        byArray6[417] = -49;
        byArray6[418] = -50;
        byArray6[419] = 51;
        byArray6[420] = 82;
        byArray6[421] = 82;
        byArray6[422] = 77;
        byArray6[423] = 4;
        byArray6[424] = 22;
        byArray6[425] = -91;
        byArray6[426] = -92;
        byArray6[427] = 65;
        byArray6[428] = -25;
        byArray6[430] = -81;
        byArray6[431] = 70;
        byArray6[432] = 21;
        byArray6[433] = 3;
        byArray6[434] = 2;
        byArray6[435] = 64;
        byArray6[436] = 84;
        byArray6[437] = 73;
        byArray6[438] = 76;
        byArray6[439] = -90;
        byArray6[440] = 62;
        byArray6[441] = -70;
        byArray6[442] = 3;
        byArray6[443] = 55;
        byArray6[444] = -28;
        byArray6[445] = -30;
        byArray6[446] = 64;
        byArray6[447] = 35;
        byArray6[448] = -4;
        byArray6[449] = -42;
        byArray6[450] = -102;
        byArray6[451] = 90;
        byArray6[452] = -21;
        byArray6[453] = 7;
        byArray6[454] = -35;
        byArray6[455] = -36;
        byArray6[456] = 1;
        byArray6[457] = -125;
        byArray6[458] = -92;
        byArray6[459] = -48;
        byArray6[460] = -84;
        byArray6[461] = -101;
        byArray6[462] = 84;
        byArray6[463] = -80;
        byArray6[464] = 81;
        byArray6[465] = -14;
        byArray6[466] = -79;
        byArray6[467] = 62;
        byArray6[468] = -39;
        byArray6[469] = 73;
        byArray6[470] = 9;
        byArray6[471] = 117;
        byArray6[472] = -22;
        byArray6[473] = -73;
        byArray6[474] = 116;
        byArray6[475] = 20;
        byArray6[476] = -1;
        byArray6[477] = 89;
        byArray6[478] = -63;
        byArray6[479] = -9;
        byArray6[480] = 105;
        byArray6[481] = 46;
        byArray6[482] = -102;
        byArray6[483] = 46;
        byArray6[484] = 32;
        byArray6[485] = 43;
        byArray6[486] = 56;
        byArray6[487] = -4;
        byArray6[488] = -111;
        byArray6[489] = 10;
        byArray6[490] = 71;
        byArray6[491] = 65;
        byArray6[492] = 116;
        byArray6[493] = -83;
        byArray6[494] = -55;
        byArray6[495] = 60;
        byArray6[496] = 31;
        byArray6[497] = 103;
        byArray6[498] = -55;
        byArray6[499] = -127;
        byArray6[500] = 2;
        byArray6[501] = 64;
        byArray6[502] = 71;
        byArray6[503] = 30;
        byArray6[504] = 2;
        byArray6[505] = -112;
        byArray6[506] = -1;
        byArray6[507] = 10;
        byArray6[508] = -16;
        byArray6[509] = 117;
        byArray6[510] = 3;
        byArray6[511] = 81;
        byArray6[512] = -73;
        byArray6[513] = -8;
        byArray6[514] = 120;
        byArray6[515] = -122;
        byArray6[516] = 76;
        byArray6[517] = -87;
        byArray6[518] = 97;
        byArray6[519] = -83;
        byArray6[520] = -67;
        byArray6[521] = 58;
        byArray6[522] = -118;
        byArray6[523] = 126;
        byArray6[524] = -103;
        byArray6[525] = 28;
        byArray6[526] = 92;
        byArray6[527] = 5;
        byArray6[528] = 86;
        byArray6[529] = -87;
        byArray6[530] = 76;
        byArray6[531] = 49;
        byArray6[532] = 70;
        byArray6[533] = -89;
        byArray6[534] = -7;
        byArray6[535] = -128;
        byArray6[536] = 63;
        byArray6[537] = -113;
        byArray6[538] = 111;
        byArray6[539] = -118;
        byArray6[540] = -29;
        byArray6[541] = 66;
        byArray6[542] = -23;
        byArray6[543] = 49;
        byArray6[544] = -3;
        byArray6[545] = -118;
        byArray6[546] = -28;
        byArray6[547] = 122;
        byArray6[548] = 34;
        byArray6[549] = 13;
        byArray6[550] = 27;
        byArray6[551] = -103;
        byArray6[552] = -92;
        byArray6[553] = -107;
        byArray6[554] = -124;
        byArray6[555] = -104;
        byArray6[556] = 7;
        byArray6[557] = -2;
        byArray6[558] = 57;
        byArray6[559] = -7;
        byArray6[560] = 36;
        byArray6[561] = 90;
        byArray6[562] = -104;
        byArray6[563] = 54;
        byArray6[564] = -38;
        byArray6[565] = 61;
        byArray6[566] = 2;
        byArray6[567] = 65;
        byArray6[569] = -80;
        byArray6[570] = 108;
        byArray6[571] = 79;
        byArray6[572] = -38;
        byArray6[573] = -69;
        byArray6[574] = 99;
        byArray6[575] = 1;
        byArray6[576] = 25;
        byArray6[577] = -115;
        byArray6[578] = 38;
        byArray6[579] = 91;
        byArray6[580] = -37;
        byArray6[581] = -82;
        byArray6[582] = -108;
        byArray6[583] = 35;
        byArray6[584] = -77;
        byArray6[585] = -128;
        byArray6[586] = -14;
        byArray6[587] = 113;
        byArray6[588] = -9;
        byArray6[589] = 52;
        byArray6[590] = 83;
        byArray6[591] = -120;
        byArray6[592] = 80;
        byArray6[593] = -109;
        byArray6[594] = 7;
        byArray6[595] = 127;
        byArray6[596] = -51;
        byArray6[597] = 57;
        byArray6[598] = -30;
        byArray6[599] = 17;
        byArray6[600] = -97;
        byArray6[601] = -55;
        byArray6[602] = -122;
        byArray6[603] = 50;
        byArray6[604] = 21;
        byArray6[605] = 79;
        byArray6[606] = 88;
        byArray6[607] = -125;
        byArray6[608] = -79;
        byArray6[609] = 103;
        byArray6[610] = -87;
        byArray6[611] = 103;
        byArray6[612] = -65;
        byArray6[613] = 64;
        byArray6[614] = 43;
        byArray6[615] = 78;
        byArray6[616] = -98;
        byArray6[617] = 46;
        byArray6[618] = 15;
        byArray6[619] = -106;
        byArray6[620] = 86;
        byArray6[621] = -26;
        byArray6[622] = -104;
        byArray6[623] = -22;
        byArray6[624] = 54;
        byArray6[625] = 102;
        byArray6[626] = -19;
        byArray6[627] = -5;
        byArray6[628] = 37;
        byArray6[629] = 121;
        byArray6[630] = -128;
        byArray6[631] = 57;
        byArray6[632] = -9;
        privKeyEnc3 = byArray6;
        output3 = Hex.decode("b8246b56a6ed5881aeb585d9a25b2ad790c417e080681bf1ac2bc3deb69d8bcef0c4366fec400af052a72e9b0effb5b3f2f192dbeaca03c12740057113bf1f0669ac22e9f3a7852e3c15d913cab0b8863a95c99294ce8674214954610346f4d474b26f7c48b42ee68e1f572a1fc4026ac456b4f59f7b621ea1b9d88f64202fb1");
    }

    private void baseOaepTest(int id, byte[] pubKeyEnc, byte[] privKeyEnc, byte[] output) throws Exception {
        ByteArrayInputStream bIn = new ByteArrayInputStream(pubKeyEnc);
        ASN1InputStream dIn = new ASN1InputStream(bIn);
        RSAPublicKey pubStruct = RSAPublicKey.getInstance(SubjectPublicKeyInfo.getInstance(dIn.readObject()).parsePublicKey());
        bIn = new ByteArrayInputStream(privKeyEnc);
        dIn = new ASN1InputStream(bIn);
        RSAPrivateKey privStruct = RSAPrivateKey.getInstance(PrivateKeyInfo.getInstance(dIn.readObject()).parsePrivateKey());
        RSAKeyParameters pubParameters = new RSAKeyParameters(false, pubStruct.getModulus(), pubStruct.getPublicExponent());
        RSAPrivateCrtKeyParameters privParameters = new RSAPrivateCrtKeyParameters(privStruct.getModulus(), privStruct.getPublicExponent(), privStruct.getPrivateExponent(), privStruct.getPrime1(), privStruct.getPrime2(), privStruct.getExponent1(), privStruct.getExponent2(), privStruct.getCoefficient());
        byte[] input = new byte[]{84, -123, -101, 52, 44, 73, -22, 42};
        this.encDec("id(" + id + ")", pubParameters, privParameters, this.seed, input, output);
    }

    private void encDec(String label, RSAKeyParameters pubParameters, RSAKeyParameters privParameters, byte[] seed, byte[] input, byte[] output) throws InvalidCipherTextException {
        OAEPEncoding cipher = new OAEPEncoding(new RSAEngine());
        cipher.init(true, new ParametersWithRandom(pubParameters, new VecRand(seed)));
        byte[] out = cipher.processBlock(input, 0, input.length);
        int i = 0;
        while (i != output.length) {
            if (out[i] != output[i]) {
                this.fail(String.valueOf(label) + " failed encryption");
            }
            ++i;
        }
        cipher.init(false, privParameters);
        out = cipher.processBlock(output, 0, output.length);
        i = 0;
        while (i != input.length) {
            if (out[i] != input[i]) {
                this.fail(String.valueOf(label) + " failed decoding");
            }
            ++i;
        }
    }

    private void oaepVecTest(int keySize, int no, RSAKeyParameters pubParam, RSAKeyParameters privParam, byte[] seed, byte[] input, byte[] output) throws Exception {
        this.encDec(String.valueOf(keySize) + " " + no, pubParam, privParam, seed, input, output);
    }

    @Override
    public String getName() {
        return "OAEP";
    }

    @Override
    public void performTest() throws Exception {
        this.baseOaepTest(1, pubKeyEnc1, privKeyEnc1, output1);
        this.baseOaepTest(2, pubKeyEnc2, privKeyEnc2, output2);
        this.baseOaepTest(3, pubKeyEnc3, privKeyEnc3, output3);
        RSAKeyParameters pubParam = new RSAKeyParameters(false, new BigInteger(1, this.modulus_1024), new BigInteger(1, this.pubExp_1024));
        RSAPrivateCrtKeyParameters privParam = new RSAPrivateCrtKeyParameters(pubParam.getModulus(), pubParam.getExponent(), new BigInteger(1, this.privExp_1024), new BigInteger(1, this.prime1_1024), new BigInteger(1, this.prime2_1024), new BigInteger(1, this.primeExp1_1024), new BigInteger(1, this.primeExp2_1024), new BigInteger(1, this.crtCoef_1024));
        this.oaepVecTest(1024, 1, pubParam, privParam, this.seed_1024_1, this.input_1024_1, this.output_1024_1);
        this.oaepVecTest(1024, 2, pubParam, privParam, this.seed_1024_2, this.input_1024_2, this.output_1024_2);
        this.oaepVecTest(1024, 3, pubParam, privParam, this.seed_1024_3, this.input_1024_3, this.output_1024_3);
        this.oaepVecTest(1024, 4, pubParam, privParam, this.seed_1024_4, this.input_1024_4, this.output_1024_4);
        this.oaepVecTest(1024, 5, pubParam, privParam, this.seed_1024_5, this.input_1024_5, this.output_1024_5);
        this.oaepVecTest(1024, 6, pubParam, privParam, this.seed_1024_6, this.input_1024_6, this.output_1024_6);
        pubParam = new RSAKeyParameters(false, new BigInteger(1, this.modulus_1027), new BigInteger(1, this.pubExp_1027));
        privParam = new RSAPrivateCrtKeyParameters(pubParam.getModulus(), pubParam.getExponent(), new BigInteger(1, this.privExp_1027), new BigInteger(1, this.prime1_1027), new BigInteger(1, this.prime2_1027), new BigInteger(1, this.primeExp1_1027), new BigInteger(1, this.primeExp2_1027), new BigInteger(1, this.crtCoef_1027));
        this.oaepVecTest(1027, 1, pubParam, privParam, this.seed_1027_1, this.input_1027_1, this.output_1027_1);
        this.oaepVecTest(1027, 2, pubParam, privParam, this.seed_1027_2, this.input_1027_2, this.output_1027_2);
        this.oaepVecTest(1027, 3, pubParam, privParam, this.seed_1027_3, this.input_1027_3, this.output_1027_3);
        this.oaepVecTest(1027, 4, pubParam, privParam, this.seed_1027_4, this.input_1027_4, this.output_1027_4);
        this.oaepVecTest(1027, 5, pubParam, privParam, this.seed_1027_5, this.input_1027_5, this.output_1027_5);
        this.oaepVecTest(1027, 6, pubParam, privParam, this.seed_1027_6, this.input_1027_6, this.output_1027_6);
        OAEPEncoding cipher = new OAEPEncoding(new RSAEngine(), new SHA256Digest(), new SHA1Digest(), new byte[10]);
        cipher.init(true, new ParametersWithRandom(pubParam, new SecureRandom()));
        byte[] input = new byte[10];
        byte[] out = cipher.processBlock(input, 0, input.length);
        cipher.init(false, privParam);
        out = cipher.processBlock(out, 0, out.length);
        int i = 0;
        while (i != input.length) {
            if (out[i] != input[i]) {
                this.fail("mixed digest failed decoding");
            }
            ++i;
        }
        cipher = new OAEPEncoding(new RSAEngine(), new SHA1Digest(), new SHA256Digest(), new byte[10]);
        cipher.init(true, new ParametersWithRandom(pubParam, new SecureRandom()));
        out = cipher.processBlock(input, 0, input.length);
        cipher.init(false, privParam);
        out = cipher.processBlock(out, 0, out.length);
        i = 0;
        while (i != input.length) {
            if (out[i] != input[i]) {
                this.fail("mixed digest failed decoding");
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        OAEPTest.runTest(new OAEPTest());
    }

    private class VecRand
    extends SecureRandom {
        byte[] seed;

        VecRand(byte[] seed) {
            this.seed = seed;
        }

        @Override
        public void nextBytes(byte[] bytes) {
            System.arraycopy(this.seed, 0, bytes, 0, bytes.length);
        }
    }
}

