/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls.test;

import junit.framework.TestCase;
import org.bouncycastle.crypto.tls.ByteQueueInputStream;
import org.bouncycastle.util.Arrays;

public class ByteQueueInputStreamTest
extends TestCase {
    public void testAvailable() {
        ByteQueueInputStream in = new ByteQueueInputStream();
        ByteQueueInputStreamTest.assertEquals((int)0, (int)in.available());
        in.addBytes(new byte[10]);
        ByteQueueInputStreamTest.assertEquals((int)10, (int)in.available());
        in.addBytes(new byte[5]);
        ByteQueueInputStreamTest.assertEquals((int)15, (int)in.available());
        in.read();
        ByteQueueInputStreamTest.assertEquals((int)14, (int)in.available());
        in.read(new byte[4]);
        ByteQueueInputStreamTest.assertEquals((int)10, (int)in.available());
        in.close();
    }

    public void testSkip() {
        ByteQueueInputStream in = new ByteQueueInputStream();
        ByteQueueInputStreamTest.assertEquals((long)0L, (long)in.skip(10L));
        in.addBytes(new byte[2]);
        ByteQueueInputStreamTest.assertEquals((long)2L, (long)in.skip(2L));
        ByteQueueInputStreamTest.assertEquals((int)0, (int)in.available());
        in.addBytes(new byte[10]);
        ByteQueueInputStreamTest.assertEquals((long)5L, (long)in.skip(5L));
        ByteQueueInputStreamTest.assertEquals((int)5, (int)in.available());
        ByteQueueInputStreamTest.assertEquals((long)5L, (long)in.skip(20L));
        ByteQueueInputStreamTest.assertEquals((int)0, (int)in.available());
        in.close();
    }

    public void testRead() {
        ByteQueueInputStream in = new ByteQueueInputStream();
        in.addBytes(new byte[]{1, 2});
        in.addBytes(new byte[]{3});
        ByteQueueInputStreamTest.assertEquals((int)1, (int)in.read());
        ByteQueueInputStreamTest.assertEquals((int)2, (int)in.read());
        ByteQueueInputStreamTest.assertEquals((int)3, (int)in.read());
        ByteQueueInputStreamTest.assertEquals((int)-1, (int)in.read());
        in.close();
    }

    public void testReadArray() {
        ByteQueueInputStream in = new ByteQueueInputStream();
        in.addBytes(new byte[]{1, 2, 3, 4, 5, 6});
        byte[] buffer = new byte[5];
        ByteQueueInputStreamTest.assertEquals((int)1, (int)in.read(buffer, 2, 1));
        byte[] byArray = new byte[5];
        byArray[2] = 1;
        ByteQueueInputStreamTest.assertArrayEquals(byArray, buffer);
        ByteQueueInputStreamTest.assertEquals((int)5, (int)in.read(buffer));
        ByteQueueInputStreamTest.assertArrayEquals(new byte[]{2, 3, 4, 5, 6}, buffer);
        in.addBytes(new byte[]{1, 2, 3});
        ByteQueueInputStreamTest.assertEquals((int)3, (int)in.read(buffer));
        ByteQueueInputStreamTest.assertArrayEquals(new byte[]{1, 2, 3, 5, 6}, buffer);
        in.close();
    }

    public void testPeek() {
        ByteQueueInputStream in = new ByteQueueInputStream();
        byte[] buffer = new byte[5];
        ByteQueueInputStreamTest.assertEquals((int)0, (int)in.peek(buffer));
        ByteQueueInputStreamTest.assertArrayEquals(new byte[5], buffer);
        in.addBytes(new byte[]{1, 2, 3, 4, 5, 6});
        ByteQueueInputStreamTest.assertEquals((int)5, (int)in.peek(buffer));
        ByteQueueInputStreamTest.assertArrayEquals(new byte[]{1, 2, 3, 4, 5}, buffer);
        ByteQueueInputStreamTest.assertEquals((int)6, (int)in.available());
        in.read();
        ByteQueueInputStreamTest.assertEquals((int)5, (int)in.peek(buffer));
        ByteQueueInputStreamTest.assertArrayEquals(new byte[]{2, 3, 4, 5, 6}, buffer);
        ByteQueueInputStreamTest.assertEquals((int)5, (int)in.available());
        in.close();
    }

    private static void assertArrayEquals(byte[] a, byte[] b) {
        ByteQueueInputStreamTest.assertTrue((boolean)Arrays.areEqual(a, b));
    }
}

