/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls.test;

import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;
import org.bouncycastle.crypto.agreement.srp.SRP6StandardGroups;
import org.bouncycastle.crypto.agreement.srp.SRP6VerifierGenerator;
import org.bouncycastle.crypto.params.SRP6GroupParameters;
import org.bouncycastle.crypto.tls.AlertDescription;
import org.bouncycastle.crypto.tls.AlertLevel;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.SRPTlsServer;
import org.bouncycastle.crypto.tls.SimulatedTlsSRPIdentityManager;
import org.bouncycastle.crypto.tls.TlsSRPIdentityManager;
import org.bouncycastle.crypto.tls.TlsSRPLoginParameters;
import org.bouncycastle.crypto.tls.TlsSignerCredentials;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.crypto.tls.test.TlsTestUtils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

class MockSRPTlsServer
extends SRPTlsServer {
    static final SRP6GroupParameters TEST_GROUP = SRP6StandardGroups.rfc5054_1024;
    static final byte[] TEST_IDENTITY = Strings.toUTF8ByteArray("client");
    static final byte[] TEST_PASSWORD = Strings.toUTF8ByteArray("password");
    static final byte[] TEST_SALT = Strings.toUTF8ByteArray("salt");
    static final byte[] TEST_SEED_KEY = Strings.toUTF8ByteArray("seed_key");

    MockSRPTlsServer() {
        super(new MyIdentityManager());
    }

    @Override
    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
        PrintStream out = alertLevel == 2 ? System.err : System.out;
        out.println("TLS-SRP server raised alert: " + AlertLevel.getText(alertLevel) + ", " + AlertDescription.getText(alertDescription));
        if (message != null) {
            out.println("> " + message);
        }
        if (cause != null) {
            cause.printStackTrace(out);
        }
    }

    @Override
    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        PrintStream out = alertLevel == 2 ? System.err : System.out;
        out.println("TLS-SRP server received alert: " + AlertLevel.getText(alertLevel) + ", " + AlertDescription.getText(alertDescription));
    }

    @Override
    public void notifyHandshakeComplete() throws IOException {
        super.notifyHandshakeComplete();
        byte[] srpIdentity = this.context.getSecurityParameters().getSRPIdentity();
        if (srpIdentity != null) {
            String name = Strings.fromUTF8ByteArray(srpIdentity);
            System.out.println("TLS-SRP server completed handshake for SRP identity: " + name);
        }
    }

    @Override
    protected ProtocolVersion getMaximumVersion() {
        return ProtocolVersion.TLSv12;
    }

    @Override
    protected ProtocolVersion getMinimumVersion() {
        return ProtocolVersion.TLSv12;
    }

    @Override
    public ProtocolVersion getServerVersion() throws IOException {
        ProtocolVersion serverVersion = super.getServerVersion();
        System.out.println("TLS-SRP server negotiated " + serverVersion);
        return serverVersion;
    }

    @Override
    protected TlsSignerCredentials getDSASignerCredentials() throws IOException {
        return TlsTestUtils.loadSignerCredentials(this.context, this.supportedSignatureAlgorithms, (short)2, "x509-server-dsa.pem", "x509-server-key-dsa.pem");
    }

    @Override
    protected TlsSignerCredentials getRSASignerCredentials() throws IOException {
        return TlsTestUtils.loadSignerCredentials(this.context, this.supportedSignatureAlgorithms, (short)1, "x509-server.pem", "x509-server-key.pem");
    }

    static class MyIdentityManager
    implements TlsSRPIdentityManager {
        protected SimulatedTlsSRPIdentityManager unknownIdentityManager = SimulatedTlsSRPIdentityManager.getRFC5054Default(TEST_GROUP, TEST_SEED_KEY);

        MyIdentityManager() {
        }

        @Override
        public TlsSRPLoginParameters getLoginParameters(byte[] identity) {
            if (Arrays.areEqual(TEST_IDENTITY, identity)) {
                SRP6VerifierGenerator verifierGenerator = new SRP6VerifierGenerator();
                verifierGenerator.init(TEST_GROUP, TlsUtils.createHash((short)2));
                BigInteger verifier = verifierGenerator.generateVerifier(TEST_SALT, identity, TEST_PASSWORD);
                return new TlsSRPLoginParameters(TEST_GROUP, verifier, TEST_SALT);
            }
            return this.unknownIdentityManager.getLoginParameters(identity);
        }
    }
}

