/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls.test;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import org.bouncycastle.crypto.tls.AlertDescription;
import org.bouncycastle.crypto.tls.AlertLevel;
import org.bouncycastle.crypto.tls.Certificate;
import org.bouncycastle.crypto.tls.CertificateRequest;
import org.bouncycastle.crypto.tls.DefaultTlsClient;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.TlsAuthentication;
import org.bouncycastle.crypto.tls.TlsCredentials;
import org.bouncycastle.crypto.tls.TlsExtensionsUtils;
import org.bouncycastle.crypto.tls.TlsSession;
import org.bouncycastle.crypto.tls.test.TlsTestUtils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

class MockTlsClient
extends DefaultTlsClient {
    TlsSession session;

    MockTlsClient(TlsSession session) {
        this.session = session;
    }

    @Override
    public TlsSession getSessionToResume() {
        return this.session;
    }

    @Override
    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
        PrintStream out = alertLevel == 2 ? System.err : System.out;
        out.println("TLS client raised alert: " + AlertLevel.getText(alertLevel) + ", " + AlertDescription.getText(alertDescription));
        if (message != null) {
            out.println("> " + message);
        }
        if (cause != null) {
            cause.printStackTrace(out);
        }
    }

    @Override
    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        PrintStream out = alertLevel == 2 ? System.err : System.out;
        out.println("TLS client received alert: " + AlertLevel.getText(alertLevel) + ", " + AlertDescription.getText(alertDescription));
    }

    @Override
    public Hashtable getClientExtensions() throws IOException {
        Hashtable clientExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(super.getClientExtensions());
        TlsExtensionsUtils.addEncryptThenMACExtension(clientExtensions);
        TlsExtensionsUtils.addExtendedMasterSecretExtension(clientExtensions);
        TlsExtensionsUtils.addMaxFragmentLengthExtension(clientExtensions, (short)1);
        TlsExtensionsUtils.addPaddingExtension(clientExtensions, this.context.getSecureRandom().nextInt(16));
        TlsExtensionsUtils.addTruncatedHMacExtension(clientExtensions);
        return clientExtensions;
    }

    @Override
    public void notifyServerVersion(ProtocolVersion serverVersion) throws IOException {
        super.notifyServerVersion(serverVersion);
        System.out.println("TLS client negotiated " + serverVersion);
    }

    @Override
    public TlsAuthentication getAuthentication() throws IOException {
        return new TlsAuthentication(){

            @Override
            public void notifyServerCertificate(Certificate serverCertificate) throws IOException {
                org.bouncycastle.asn1.x509.Certificate[] chain = serverCertificate.getCertificateList();
                System.out.println("TLS client received server certificate chain of length " + chain.length);
                int i = 0;
                while (i != chain.length) {
                    org.bouncycastle.asn1.x509.Certificate entry = chain[i];
                    System.out.println("    fingerprint:SHA-256 " + TlsTestUtils.fingerprint(entry) + " (" + entry.getSubject() + ")");
                    ++i;
                }
            }

            @Override
            public TlsCredentials getClientCredentials(CertificateRequest certificateRequest) throws IOException {
                short[] certificateTypes = certificateRequest.getCertificateTypes();
                if (certificateTypes == null || !Arrays.contains(certificateTypes, (short)1)) {
                    return null;
                }
                return TlsTestUtils.loadSignerCredentials(MockTlsClient.this.context, certificateRequest.getSupportedSignatureAlgorithms(), (short)1, "x509-client.pem", "x509-client-key.pem");
            }
        };
    }

    @Override
    public void notifyHandshakeComplete() throws IOException {
        super.notifyHandshakeComplete();
        TlsSession newSession = this.context.getResumableSession();
        if (newSession != null) {
            byte[] newSessionID = newSession.getSessionID();
            String hex = Hex.toHexString(newSessionID);
            if (this.session != null && Arrays.areEqual(this.session.getSessionID(), newSessionID)) {
                System.out.println("Resumed session: " + hex);
            } else {
                System.out.println("Established session: " + hex);
            }
            this.session = newSession;
        }
    }
}

