/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls.test;

import java.io.IOException;
import java.util.Vector;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.crypto.tls.Certificate;
import org.bouncycastle.crypto.tls.CertificateRequest;
import org.bouncycastle.crypto.tls.DefaultTlsServer;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.crypto.tls.TlsEncryptionCredentials;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsSignerCredentials;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.crypto.tls.test.TlsTestConfig;
import org.bouncycastle.crypto.tls.test.TlsTestUtils;

class TlsTestServerImpl
extends DefaultTlsServer {
    protected final TlsTestConfig config;
    protected int firstFatalAlertConnectionEnd = -1;
    protected short firstFatalAlertDescription = (short)-1;

    TlsTestServerImpl(TlsTestConfig config) {
        this.config = config;
    }

    int getFirstFatalAlertConnectionEnd() {
        return this.firstFatalAlertConnectionEnd;
    }

    short getFirstFatalAlertDescription() {
        return this.firstFatalAlertDescription;
    }

    @Override
    protected ProtocolVersion getMaximumVersion() {
        if (this.config.serverMaximumVersion != null) {
            return this.config.serverMaximumVersion;
        }
        return super.getMaximumVersion();
    }

    @Override
    protected ProtocolVersion getMinimumVersion() {
        if (this.config.serverMinimumVersion != null) {
            return this.config.serverMinimumVersion;
        }
        return super.getMinimumVersion();
    }

    @Override
    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
        if (alertLevel == 2 && this.firstFatalAlertConnectionEnd == -1) {
            this.firstFatalAlertConnectionEnd = 0;
            this.firstFatalAlertDescription = alertDescription;
        }
    }

    @Override
    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        if (alertLevel == 2 && this.firstFatalAlertConnectionEnd == -1) {
            this.firstFatalAlertConnectionEnd = 1;
            this.firstFatalAlertDescription = alertDescription;
        }
    }

    @Override
    public ProtocolVersion getServerVersion() throws IOException {
        ProtocolVersion serverVersion = super.getServerVersion();
        return serverVersion;
    }

    @Override
    public CertificateRequest getCertificateRequest() throws IOException {
        if (this.config.serverCertReq == 0) {
            return null;
        }
        short[] certificateTypes = new short[]{1, 2, 64};
        Vector serverSigAlgs = null;
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(this.serverVersion) && (serverSigAlgs = this.config.serverCertReqSigAlgs) == null) {
            serverSigAlgs = TlsUtils.getDefaultSupportedSignatureAlgorithms();
        }
        Vector<X500Name> certificateAuthorities = new Vector<X500Name>();
        certificateAuthorities.addElement(TlsTestUtils.loadCertificateResource("x509-ca.pem").getSubject());
        return new CertificateRequest(certificateTypes, serverSigAlgs, certificateAuthorities);
    }

    @Override
    public void notifyClientCertificate(Certificate clientCertificate) throws IOException {
        boolean isEmpty = clientCertificate == null || clientCertificate.isEmpty();
        if (isEmpty != (this.config.clientAuth == 0)) {
            throw new IllegalStateException();
        }
        if (isEmpty && this.config.serverCertReq == 2) {
            throw new TlsFatalAlert(40);
        }
        org.bouncycastle.asn1.x509.Certificate[] chain = clientCertificate.getCertificateList();
        if (!(isEmpty || chain[0].equals(TlsTestUtils.loadCertificateResource("x509-client.pem")) || chain[0].equals(TlsTestUtils.loadCertificateResource("x509-client-dsa.pem")) || chain[0].equals(TlsTestUtils.loadCertificateResource("x509-client-ecdsa.pem")))) {
            throw new TlsFatalAlert(42);
        }
    }

    protected Vector getSupportedSignatureAlgorithms() {
        if (TlsUtils.isTLSv12(this.context) && this.config.serverAuthSigAlg != null) {
            Vector<SignatureAndHashAlgorithm> signatureAlgorithms = new Vector<SignatureAndHashAlgorithm>(1);
            signatureAlgorithms.addElement(this.config.serverAuthSigAlg);
            return signatureAlgorithms;
        }
        return this.supportedSignatureAlgorithms;
    }

    @Override
    protected TlsSignerCredentials getDSASignerCredentials() throws IOException {
        return TlsTestUtils.loadSignerCredentials(this.context, this.getSupportedSignatureAlgorithms(), (short)2, "x509-server-dsa.pem", "x509-server-key-dsa.pem");
    }

    @Override
    protected TlsSignerCredentials getECDSASignerCredentials() throws IOException {
        return TlsTestUtils.loadSignerCredentials(this.context, this.getSupportedSignatureAlgorithms(), (short)3, "x509-server-ecdsa.pem", "x509-server-key-ecdsa.pem");
    }

    @Override
    protected TlsEncryptionCredentials getRSAEncryptionCredentials() throws IOException {
        return TlsTestUtils.loadEncryptionCredentials(this.context, new String[]{"x509-server.pem", "x509-ca.pem"}, "x509-server-key.pem");
    }

    @Override
    protected TlsSignerCredentials getRSASignerCredentials() throws IOException {
        return TlsTestUtils.loadSignerCredentials(this.context, this.getSupportedSignatureAlgorithms(), (short)1, "x509-server.pem", "x509-server-key.pem");
    }
}

