/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.sphincs;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.pqc.crypto.MessageSigner;
import org.bouncycastle.pqc.crypto.sphincs.HashFunctions;
import org.bouncycastle.pqc.crypto.sphincs.Horst;
import org.bouncycastle.pqc.crypto.sphincs.SPHINCSPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.sphincs.SPHINCSPublicKeyParameters;
import org.bouncycastle.pqc.crypto.sphincs.Seed;
import org.bouncycastle.pqc.crypto.sphincs.Tree;
import org.bouncycastle.pqc.crypto.sphincs.Wots;
import org.bouncycastle.util.Pack;

public class SPHINCS256Signer
implements MessageSigner {
    private final HashFunctions hashFunctions;
    private byte[] keyData;

    public SPHINCS256Signer(Digest nDigest, Digest twoNDigest) {
        if (nDigest.getDigestSize() != 32) {
            throw new IllegalArgumentException("n-digest needs to produce 32 bytes of output");
        }
        if (twoNDigest.getDigestSize() != 64) {
            throw new IllegalArgumentException("2n-digest needs to produce 64 bytes of output");
        }
        this.hashFunctions = new HashFunctions(nDigest, twoNDigest);
    }

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        this.keyData = forSigning ? ((SPHINCSPrivateKeyParameters)param).getKeyData() : ((SPHINCSPublicKeyParameters)param).getKeyData();
    }

    @Override
    public byte[] generateSignature(byte[] message) {
        return this.crypto_sign(this.hashFunctions, message, this.keyData);
    }

    @Override
    public boolean verifySignature(byte[] message, byte[] signature) {
        return this.verify(this.hashFunctions, message, signature, this.keyData);
    }

    static void validate_authpath(HashFunctions hs, byte[] root, byte[] leaf, int leafidx, byte[] authpath, int auOff, byte[] masks, int height) {
        int j;
        byte[] buffer = new byte[64];
        if ((leafidx & 1) != 0) {
            j = 0;
            while (j < 32) {
                buffer[32 + j] = leaf[j];
                ++j;
            }
            j = 0;
            while (j < 32) {
                buffer[j] = authpath[auOff + j];
                ++j;
            }
        } else {
            j = 0;
            while (j < 32) {
                buffer[j] = leaf[j];
                ++j;
            }
            j = 0;
            while (j < 32) {
                buffer[32 + j] = authpath[auOff + j];
                ++j;
            }
        }
        int authOff = auOff + 32;
        int i = 0;
        while (i < height - 1) {
            if (((leafidx >>>= 1) & 1) != 0) {
                hs.hash_2n_n_mask(buffer, 32, buffer, 0, masks, 2 * (7 + i) * 32);
                j = 0;
                while (j < 32) {
                    buffer[j] = authpath[authOff + j];
                    ++j;
                }
            } else {
                hs.hash_2n_n_mask(buffer, 0, buffer, 0, masks, 2 * (7 + i) * 32);
                j = 0;
                while (j < 32) {
                    buffer[j + 32] = authpath[authOff + j];
                    ++j;
                }
            }
            authOff += 32;
            ++i;
        }
        hs.hash_2n_n_mask(root, 0, buffer, 0, masks, 2 * (7 + height - 1) * 32);
    }

    static void compute_authpath_wots(HashFunctions hs, byte[] root, byte[] authpath, int authOff, Tree.leafaddr a, byte[] sk, byte[] masks, int height) {
        Tree.leafaddr ta = new Tree.leafaddr(a);
        byte[] tree = new byte[2048];
        byte[] seed = new byte[1024];
        byte[] pk = new byte[68608];
        ta.subleaf = 0L;
        while (ta.subleaf < 32L) {
            Seed.get_seed(hs, seed, (int)(ta.subleaf * 32L), sk, ta);
            ++ta.subleaf;
        }
        Wots w = new Wots();
        ta.subleaf = 0L;
        while (ta.subleaf < 32L) {
            w.wots_pkgen(hs, pk, (int)(ta.subleaf * 67L * 32L), seed, (int)(ta.subleaf * 32L), masks, 0);
            ++ta.subleaf;
        }
        ta.subleaf = 0L;
        while (ta.subleaf < 32L) {
            Tree.l_tree(hs, tree, (int)(1024L + ta.subleaf * 32L), pk, (int)(ta.subleaf * 67L * 32L), masks, 0);
            ++ta.subleaf;
        }
        int level = 0;
        int i = 32;
        while (i > 0) {
            int j = 0;
            while (j < i) {
                hs.hash_2n_n_mask(tree, (i >>> 1) * 32 + (j >>> 1) * 32, tree, i * 32 + j * 32, masks, 2 * (7 + level) * 32);
                j += 2;
            }
            ++level;
            i >>>= 1;
        }
        int idx = (int)a.subleaf;
        i = 0;
        while (i < height) {
            System.arraycopy(tree, (32 >>> i) * 32 + (idx >>> i ^ 1) * 32, authpath, authOff + i * 32, 32);
            ++i;
        }
        System.arraycopy(tree, 32, root, 0, 32);
    }

    byte[] crypto_sign(HashFunctions hs, byte[] m, byte[] sk) {
        byte[] sm = new byte[41000];
        byte[] R = new byte[32];
        byte[] m_h = new byte[64];
        long[] rnd = new long[8];
        byte[] root = new byte[32];
        byte[] seed = new byte[32];
        byte[] masks = new byte[1024];
        byte[] tsk = new byte[1088];
        int i = 0;
        while (i < 1088) {
            tsk[i] = sk[i];
            ++i;
        }
        int scratch = 40968;
        System.arraycopy(tsk, 1056, sm, scratch, 32);
        Digest d = hs.getMessageHash();
        byte[] bRnd = new byte[d.getDigestSize()];
        d.update(sm, scratch, 32);
        d.update(m, 0, m.length);
        d.doFinal(bRnd, 0);
        this.zerobytes(sm, scratch, 32);
        int j = 0;
        while (j != rnd.length) {
            rnd[j] = Pack.littleEndianToLong(bRnd, j * 8);
            ++j;
        }
        long leafidx = rnd[0] & 0xFFFFFFFFFFFFFFFL;
        System.arraycopy(bRnd, 16, R, 0, 32);
        scratch = 39912;
        System.arraycopy(R, 0, sm, scratch, 32);
        Tree.leafaddr b = new Tree.leafaddr();
        b.level = 11;
        b.subtree = 0L;
        b.subleaf = 0L;
        int pk = scratch + 32;
        System.arraycopy(tsk, 32, sm, pk, 1024);
        Tree.treehash(hs, sm, pk + 1024, 5, tsk, b, sm, pk);
        d = hs.getMessageHash();
        d.update(sm, scratch, 1088);
        d.update(m, 0, m.length);
        d.doFinal(m_h, 0);
        Tree.leafaddr a = new Tree.leafaddr();
        a.level = 12;
        a.subleaf = (int)(leafidx & 0x1FL);
        a.subtree = leafidx >>> 5;
        i = 0;
        while (i < 32) {
            sm[i] = R[i];
            ++i;
        }
        int smOff = 32;
        System.arraycopy(tsk, 32, masks, 0, 1024);
        i = 0;
        while (i < 8) {
            sm[smOff + i] = (byte)(leafidx >>> 8 * i & 0xFFL);
            ++i;
        }
        Seed.get_seed(hs, seed, 0, tsk, a);
        Horst ht = new Horst();
        int horst_sigbytes = Horst.horst_sign(hs, sm, smOff += 8, root, seed, masks, m_h);
        smOff += horst_sigbytes;
        Wots w = new Wots();
        i = 0;
        while (i < 12) {
            a.level = i++;
            Seed.get_seed(hs, seed, 0, tsk, a);
            w.wots_sign(hs, sm, smOff, root, seed, masks);
            SPHINCS256Signer.compute_authpath_wots(hs, root, sm, smOff += 2144, a, tsk, masks, 5);
            smOff += 160;
            a.subleaf = (int)(a.subtree & 0x1FL);
            a.subtree >>>= 5;
        }
        this.zerobytes(tsk, 0, 1088);
        return sm;
    }

    private void zerobytes(byte[] tsk, int off, int cryptoSecretkeybytes) {
        int i = 0;
        while (i != cryptoSecretkeybytes) {
            tsk[off + i] = 0;
            ++i;
        }
    }

    boolean verify(HashFunctions hs, byte[] m, byte[] sm, byte[] pk) {
        int smlen = sm.length;
        long leafidx = 0L;
        byte[] wots_pk = new byte[2144];
        byte[] pkhash = new byte[32];
        byte[] root = new byte[32];
        byte[] sig = new byte[41000];
        byte[] tpk = new byte[1056];
        if (smlen != 41000) {
            throw new IllegalArgumentException("signature wrong size");
        }
        byte[] m_h = new byte[64];
        int i = 0;
        while (i < 1056) {
            tpk[i] = pk[i];
            ++i;
        }
        byte[] R = new byte[32];
        i = 0;
        while (i < 32) {
            R[i] = sm[i];
            ++i;
        }
        System.arraycopy(sm, 0, sig, 0, 41000);
        Digest mHash = hs.getMessageHash();
        mHash.update(R, 0, 32);
        mHash.update(tpk, 0, 1056);
        mHash.update(m, 0, m.length);
        mHash.doFinal(m_h, 0);
        int sigp = 0;
        sigp += 32;
        smlen -= 32;
        i = 0;
        while (i < 8) {
            leafidx ^= (long)(sig[sigp + i] & 0xFF) << 8 * i;
            ++i;
        }
        new Horst();
        Horst.horst_verify(hs, root, sig, sigp + 8, tpk, m_h);
        sigp += 8;
        smlen -= 8;
        sigp += 13312;
        smlen -= 13312;
        Wots w = new Wots();
        i = 0;
        while (i < 12) {
            w.wots_verify(hs, wots_pk, sig, sigp, root, tpk);
            smlen -= 2144;
            Tree.l_tree(hs, pkhash, 0, wots_pk, 0, tpk, 0);
            SPHINCS256Signer.validate_authpath(hs, root, pkhash, (int)(leafidx & 0x1FL), sig, sigp += 2144, tpk, 5);
            leafidx >>= 5;
            sigp += 160;
            smlen -= 160;
            ++i;
        }
        boolean verified = true;
        i = 0;
        while (i < 32) {
            if (root[i] != tpk[i + 1024]) {
                verified = false;
            }
            ++i;
        }
        return verified;
    }
}

