/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.test;

import junit.framework.TestCase;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSPublicKeyParameters;
import org.bouncycastle.util.Arrays;

public class XMSSPublicKeyTest
extends TestCase {
    public void testPublicKeyParsingSHA256() {
        XMSSParameters params = new XMSSParameters(10, new SHA256Digest());
        byte[] byArray = new byte[32];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        byArray[8] = 8;
        byArray[9] = 9;
        byArray[10] = 10;
        byArray[11] = 11;
        byArray[12] = 12;
        byArray[13] = 13;
        byArray[14] = 14;
        byArray[15] = 15;
        byArray[16] = 16;
        byArray[17] = 32;
        byArray[18] = 48;
        byArray[19] = 3;
        byArray[20] = 64;
        byArray[21] = 80;
        byArray[22] = 96;
        byArray[23] = 112;
        byArray[24] = -128;
        byArray[25] = -112;
        byArray[26] = -96;
        byArray[27] = -80;
        byArray[28] = -64;
        byArray[29] = -48;
        byArray[30] = -32;
        byArray[31] = -16;
        byte[] root = byArray;
        XMSSPublicKeyParameters publicKey = new XMSSPublicKeyParameters.Builder(params).withRoot(root).build();
        byte[] export = publicKey.toByteArray();
        XMSSPublicKeyParameters publicKey2 = new XMSSPublicKeyParameters.Builder(params).withPublicKey(export).build();
        XMSSPublicKeyTest.assertEquals((boolean)true, (boolean)Arrays.areEqual(publicKey.getRoot(), publicKey2.getRoot()));
        XMSSPublicKeyTest.assertEquals((boolean)true, (boolean)Arrays.areEqual(publicKey.getPublicSeed(), publicKey2.getPublicSeed()));
    }

    public void testPublicKeyParsingSHA512() {
        XMSSParameters params = new XMSSParameters(10, new SHA512Digest());
        byte[] byArray = new byte[64];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        byArray[8] = 8;
        byArray[9] = 9;
        byArray[10] = 10;
        byArray[11] = 11;
        byArray[12] = 12;
        byArray[13] = 13;
        byArray[14] = 14;
        byArray[15] = 15;
        byArray[16] = 16;
        byArray[17] = 32;
        byArray[18] = 48;
        byArray[19] = 3;
        byArray[20] = 64;
        byArray[21] = 80;
        byArray[22] = 96;
        byArray[23] = 112;
        byArray[24] = -128;
        byArray[25] = -112;
        byArray[26] = -96;
        byArray[27] = -80;
        byArray[28] = -64;
        byArray[29] = -48;
        byArray[30] = -32;
        byArray[31] = -16;
        byArray[33] = 1;
        byArray[34] = 2;
        byArray[35] = 3;
        byArray[36] = 4;
        byArray[37] = 5;
        byArray[38] = 6;
        byArray[39] = 7;
        byArray[40] = 8;
        byArray[41] = 9;
        byArray[42] = 10;
        byArray[43] = 11;
        byArray[44] = 12;
        byArray[45] = 13;
        byArray[46] = 14;
        byArray[47] = 15;
        byArray[48] = 16;
        byArray[49] = 32;
        byArray[50] = 48;
        byArray[51] = 3;
        byArray[52] = 64;
        byArray[53] = 80;
        byArray[54] = 96;
        byArray[55] = 112;
        byArray[56] = -128;
        byArray[57] = -112;
        byArray[58] = -96;
        byArray[59] = -80;
        byArray[60] = -64;
        byArray[61] = -48;
        byArray[62] = -32;
        byArray[63] = -16;
        byte[] root = byArray;
        XMSSPublicKeyParameters publicKey = new XMSSPublicKeyParameters.Builder(params).withRoot(root).build();
        byte[] export = publicKey.toByteArray();
        XMSSPublicKeyParameters publicKey2 = new XMSSPublicKeyParameters.Builder(params).withPublicKey(export).build();
        XMSSPublicKeyTest.assertEquals((boolean)true, (boolean)Arrays.areEqual(publicKey.getRoot(), publicKey2.getRoot()));
        XMSSPublicKeyTest.assertEquals((boolean)true, (boolean)Arrays.areEqual(publicKey.getPublicSeed(), publicKey2.getPublicSeed()));
    }

    public void testConstructor() {
        XMSSParameters params = new XMSSParameters(10, new SHA256Digest());
        XMSSPublicKeyParameters pk = new XMSSPublicKeyParameters.Builder(params).build();
        byte[] pkByte = pk.toByteArray();
        int i = 0;
        while (i < pkByte.length) {
            XMSSPublicKeyTest.assertEquals((int)0, (int)pkByte[i]);
            ++i;
        }
    }
}

