/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXSlider;
import com.jfoenix.skins.JFXSliderSkin$$Lambda$1;
import com.jfoenix.skins.JFXSliderSkin$$Lambda$10;
import com.jfoenix.skins.JFXSliderSkin$$Lambda$2;
import com.jfoenix.skins.JFXSliderSkin$$Lambda$3;
import com.jfoenix.skins.JFXSliderSkin$$Lambda$4;
import com.jfoenix.skins.JFXSliderSkin$$Lambda$5;
import com.jfoenix.skins.JFXSliderSkin$$Lambda$6;
import com.jfoenix.skins.JFXSliderSkin$$Lambda$7;
import com.jfoenix.skins.JFXSliderSkin$$Lambda$8;
import com.jfoenix.skins.JFXSliderSkin$$Lambda$9;
import com.sun.javafx.scene.control.skin.SliderSkin;
import java.util.concurrent.Callable;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.geometry.Orientation;
import javafx.scene.control.Slider;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;
import javafx.util.Duration;

public class JFXSliderSkin
extends SliderSkin {
    private final Pane mouseHandlerPane = new Pane();
    private static final PseudoClass MIN_VALUE = PseudoClass.getPseudoClass((String)"min");
    private static final PseudoClass MAX_VALUE = PseudoClass.getPseudoClass((String)"max");
    private Text sliderValue;
    private StackPane coloredTrack;
    private StackPane thumb;
    private StackPane track = (StackPane)((Slider)this.getSkinnable()).lookup(".track");
    private StackPane animatedThumb;
    private Timeline timeline;
    private double indicatorRotation;
    private double horizontalRotation;
    private double shifting;
    private boolean isValid = false;

    public JFXSliderSkin(JFXSlider slider2) {
        super((Slider)slider2);
        this.thumb = (StackPane)((Slider)this.getSkinnable()).lookup(".thumb");
        this.coloredTrack = new StackPane();
        this.coloredTrack.getStyleClass().add((Object)"colored-track");
        this.coloredTrack.setMouseTransparent(true);
        this.sliderValue = new Text();
        this.sliderValue.getStyleClass().setAll((Object[])new String[]{"slider-value"});
        this.animatedThumb = new StackPane();
        this.animatedThumb.getStyleClass().add((Object)"animated-thumb");
        this.animatedThumb.getChildren().add((Object)this.sliderValue);
        this.animatedThumb.setMouseTransparent(true);
        this.animatedThumb.setScaleX(0.0);
        this.animatedThumb.setScaleY(0.0);
        this.getChildren().add(this.getChildren().indexOf((Object)this.thumb), (Object)this.coloredTrack);
        this.getChildren().add(this.getChildren().indexOf((Object)this.thumb), (Object)this.animatedThumb);
        this.getChildren().add(0, (Object)this.mouseHandlerPane);
        this.registerChangeListener((ObservableValue)slider2.valueFactoryProperty(), "VALUE_FACTORY");
        this.initListeners();
    }

    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("VALUE_FACTORY".equals(p)) {
            this.refreshSliderValueBinding();
        }
    }

    private void refreshSliderValueBinding() {
        this.sliderValue.textProperty().unbind();
        if (((JFXSlider)this.getSkinnable()).getValueFactory() != null) {
            this.sliderValue.textProperty().bind((ObservableValue)((JFXSlider)this.getSkinnable()).getValueFactory().call((Object)((JFXSlider)this.getSkinnable())));
        } else {
            this.sliderValue.textProperty().bind((ObservableValue)Bindings.createStringBinding((Callable)JFXSliderSkin$$Lambda$1.lambdaFactory$(this), (Observable[])new Observable[]{((Slider)this.getSkinnable()).valueProperty()}));
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        double layoutY;
        double layoutX;
        double height;
        double width;
        boolean horizontal;
        super.layoutChildren(x, y, w, h);
        if (!this.isValid) {
            this.initializeVariables();
            this.initAnimation(((Slider)this.getSkinnable()).getOrientation());
            this.isValid = true;
        }
        double prefWidth2 = this.animatedThumb.prefWidth(-1.0);
        this.animatedThumb.resize(prefWidth2, this.animatedThumb.prefHeight(prefWidth2));
        boolean bl = horizontal = ((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL;
        if (horizontal) {
            width = this.thumb.getLayoutX() - this.snappedLeftInset();
            height = this.track.getHeight();
            layoutX = this.track.getLayoutX();
            layoutY = this.track.getLayoutY();
            this.animatedThumb.setLayoutX(this.thumb.getLayoutX() + this.thumb.getWidth() / 2.0 - this.animatedThumb.getWidth() / 2.0);
        } else {
            height = this.track.getLayoutBounds().getMaxY() + this.track.getLayoutY() - this.thumb.getLayoutY() - this.snappedBottomInset();
            width = this.track.getWidth();
            layoutX = this.track.getLayoutX();
            layoutY = this.thumb.getLayoutY();
            this.animatedThumb.setLayoutY(this.thumb.getLayoutY() + this.thumb.getHeight() / 2.0 - this.animatedThumb.getHeight() / 2.0);
        }
        this.coloredTrack.resizeRelocate(layoutX, layoutY, width, height);
        this.mouseHandlerPane.resizeRelocate(x, y, w, h);
    }

    private void initializeVariables() {
        this.shifting = 30.0 + this.thumb.getWidth();
        if (((Slider)this.getSkinnable()).getOrientation() != Orientation.HORIZONTAL) {
            this.horizontalRotation = -90.0;
        }
        if (((JFXSlider)this.getSkinnable()).getIndicatorPosition() != JFXSlider.IndicatorPosition.LEFT) {
            this.indicatorRotation = 180.0;
            this.shifting = -this.shifting;
        }
        double rotationAngle = 45.0;
        this.sliderValue.setRotate(45.0 + this.indicatorRotation + 3.0 * this.horizontalRotation);
        this.animatedThumb.setRotate(-45.0 + this.indicatorRotation + this.horizontalRotation);
    }

    private void initListeners() {
        this.mouseHandlerPane.setOnMousePressed(JFXSliderSkin$$Lambda$2.lambdaFactory$(this));
        this.mouseHandlerPane.setOnMouseReleased(JFXSliderSkin$$Lambda$3.lambdaFactory$(this));
        this.mouseHandlerPane.setOnMouseDragged(JFXSliderSkin$$Lambda$4.lambdaFactory$(this));
        this.track.addEventHandler(MouseEvent.MOUSE_PRESSED, JFXSliderSkin$$Lambda$5.lambdaFactory$(this));
        this.track.addEventHandler(MouseEvent.MOUSE_RELEASED, JFXSliderSkin$$Lambda$6.lambdaFactory$(this));
        this.thumb.addEventHandler(MouseEvent.MOUSE_PRESSED, JFXSliderSkin$$Lambda$7.lambdaFactory$(this));
        this.thumb.addEventHandler(MouseEvent.MOUSE_RELEASED, JFXSliderSkin$$Lambda$8.lambdaFactory$(this));
        this.refreshSliderValueBinding();
        this.updateValueStyleClass();
        ((Slider)this.getSkinnable()).valueProperty().addListener(JFXSliderSkin$$Lambda$9.lambdaFactory$(this));
        ((Slider)this.getSkinnable()).orientationProperty().addListener(JFXSliderSkin$$Lambda$10.lambdaFactory$(this));
    }

    private void delegateToTrack(MouseEvent event) {
        if (!event.isConsumed()) {
            event.consume();
            this.track.fireEvent((Event)event);
        }
    }

    private void updateValueStyleClass() {
        ((Slider)this.getSkinnable()).pseudoClassStateChanged(MIN_VALUE, ((Slider)this.getSkinnable()).getMin() == ((Slider)this.getSkinnable()).getValue());
        ((Slider)this.getSkinnable()).pseudoClassStateChanged(MAX_VALUE, ((Slider)this.getSkinnable()).getMax() == ((Slider)this.getSkinnable()).getValue());
    }

    private void initAnimation(Orientation orientation) {
        DoubleProperty layoutProperty;
        double thumbNewPos;
        double thumbPos;
        if (orientation == Orientation.HORIZONTAL) {
            if (((JFXSlider)this.getSkinnable()).getIndicatorPosition() == JFXSlider.IndicatorPosition.RIGHT) {
                thumbPos = this.thumb.getLayoutY() - this.thumb.getHeight();
                thumbNewPos = thumbPos - this.shifting;
            } else {
                double height = this.animatedThumb.prefHeight(this.animatedThumb.prefWidth(-1.0));
                thumbPos = this.thumb.getLayoutY() - height / 2.0;
                thumbNewPos = this.thumb.getLayoutY() - height - this.thumb.getHeight();
            }
            layoutProperty = this.animatedThumb.translateYProperty();
        } else {
            if (((JFXSlider)this.getSkinnable()).getIndicatorPosition() == JFXSlider.IndicatorPosition.RIGHT) {
                thumbPos = this.thumb.getLayoutX() - this.thumb.getWidth();
                thumbNewPos = thumbPos - this.shifting;
            } else {
                double width = this.animatedThumb.prefWidth(-1.0);
                thumbPos = this.thumb.getLayoutX() - width / 2.0;
                thumbNewPos = this.thumb.getLayoutX() - width - this.thumb.getWidth();
            }
            layoutProperty = this.animatedThumb.translateXProperty();
        }
        this.clearAnimation();
        this.timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.animatedThumb.scaleXProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.animatedThumb.scaleYProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)layoutProperty, (Object)thumbPos, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.seconds((double)0.2), new KeyValue[]{new KeyValue((WritableValue)this.animatedThumb.scaleXProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.animatedThumb.scaleYProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)layoutProperty, (Object)thumbNewPos, Interpolator.EASE_BOTH)})});
    }

    public void dispose() {
        super.dispose();
        this.clearAnimation();
    }

    private void clearAnimation() {
        if (this.timeline != null) {
            this.timeline.stop();
            this.timeline.getKeyFrames().clear();
            this.timeline = null;
        }
    }

    static /* synthetic */ void lambda$initListeners$6(JFXSliderSkin this_, Observable observable2) {
        this_.initAnimation(((Slider)this_.getSkinnable()).getOrientation());
    }

    static /* synthetic */ void lambda$initListeners$5(JFXSliderSkin this_, Observable observable2) {
        this_.updateValueStyleClass();
    }

    static /* synthetic */ void lambda$initListeners$4(JFXSliderSkin this_, MouseEvent event) {
        this_.timeline.setRate(-1.0);
        this_.timeline.play();
    }

    static /* synthetic */ void lambda$initListeners$3(JFXSliderSkin this_, MouseEvent event) {
        this_.timeline.setRate(1.0);
        this_.timeline.play();
    }

    static /* synthetic */ void lambda$initListeners$2(JFXSliderSkin this_, MouseEvent event) {
        this_.timeline.setRate(-1.0);
        this_.timeline.play();
    }

    static /* synthetic */ void lambda$initListeners$1(JFXSliderSkin this_, MouseEvent event) {
        this_.timeline.setRate(1.0);
        this_.timeline.play();
    }

    static /* synthetic */ String lambda$refreshSliderValueBinding$0(JFXSliderSkin this_) throws Exception {
        if (((Slider)this_.getSkinnable()).getLabelFormatter() != null) {
            return ((Slider)this_.getSkinnable()).getLabelFormatter().toString((Object)((Slider)this_.getSkinnable()).getValue());
        }
        return String.valueOf(Math.round(((Slider)this_.getSkinnable()).getValue()));
    }

    static /* synthetic */ void access$lambda$0(JFXSliderSkin jFXSliderSkin, MouseEvent mouseEvent) {
        jFXSliderSkin.delegateToTrack(mouseEvent);
    }

    static /* synthetic */ void access$lambda$1(JFXSliderSkin jFXSliderSkin, MouseEvent mouseEvent) {
        jFXSliderSkin.delegateToTrack(mouseEvent);
    }

    static /* synthetic */ void access$lambda$2(JFXSliderSkin jFXSliderSkin, MouseEvent mouseEvent) {
        jFXSliderSkin.delegateToTrack(mouseEvent);
    }
}

