/*
 * Decompiled with CFR 0.152.
 */
package com.wan.noveldownloader.util;

import com.jfoenix.controls.JFXAlert;
import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDialogLayout;
import com.sun.istack.internal.Nullable;
import com.wan.noveldownloader.util.MyUtils;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.Border;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;

public class DialogBuilder {
    private String title;
    private String message;
    private JFXButton negativeBtn = null;
    private JFXButton positiveBtn = null;
    private Window window;
    private Paint negativeBtnPaint = Paint.valueOf((String)"#747474");
    private Paint positiveBtnPaint = Paint.valueOf((String)"#0099ff");
    private Hyperlink hyperlink = null;
    private TextField textField = null;
    private JFXAlert<String> alert;
    private OnInputListener onInputListener = null;

    public DialogBuilder(Control control) {
        this.window = control.getScene().getWindow();
    }

    public DialogBuilder setTitle(String title2) {
        this.title = title2;
        return this;
    }

    public DialogBuilder setMessage(String message2) {
        this.message = message2;
        return this;
    }

    public DialogBuilder setPositiveBtn(String positiveBtnText) {
        return this.setPositiveBtn(positiveBtnText, null, null);
    }

    public DialogBuilder setNegativeBtn(String negativeBtnText) {
        return this.setNegativeBtn(negativeBtnText, null, null);
    }

    public DialogBuilder setNegativeBtn(String negativeBtnText, String color) {
        return this.setNegativeBtn(negativeBtnText, null, color);
    }

    public DialogBuilder setNegativeBtn(String negativeBtnText, @Nullable OnClickListener negativeBtnOnclickListener, String color) {
        if (color != null) {
            this.negativeBtnPaint = Paint.valueOf((String)color);
        }
        return this.setNegativeBtn(negativeBtnText, negativeBtnOnclickListener);
    }

    public DialogBuilder setNegativeBtn(String negativeBtnText, @Nullable OnClickListener negativeBtnOnclickListener) {
        this.negativeBtn = new JFXButton(negativeBtnText);
        this.negativeBtn.setCancelButton(true);
        this.negativeBtn.setTextFill(this.negativeBtnPaint);
        this.negativeBtn.setButtonType(JFXButton.ButtonType.FLAT);
        this.negativeBtn.setOnAction(addEvent -> {
            this.alert.hideWithAnimation();
            if (negativeBtnOnclickListener != null) {
                negativeBtnOnclickListener.onClick();
            }
        });
        return this;
    }

    public DialogBuilder setPositiveBtn(String positiveBtnText, String color) {
        return this.setPositiveBtn(positiveBtnText, null, color);
    }

    public DialogBuilder setPositiveBtn(String positiveBtnText, @Nullable OnClickListener positiveBtnOnclickListener, String color) {
        if (color != null) {
            this.positiveBtnPaint = Paint.valueOf((String)color);
        }
        return this.setPositiveBtn(positiveBtnText, positiveBtnOnclickListener);
    }

    public DialogBuilder setPositiveBtn(String positiveBtnText, @Nullable OnClickListener positiveBtnOnclickListener) {
        this.positiveBtn = new JFXButton(positiveBtnText);
        this.positiveBtn.setDefaultButton(true);
        this.positiveBtn.setTextFill(this.positiveBtnPaint);
        this.positiveBtn.setOnAction(closeEvent -> {
            this.alert.hideWithAnimation();
            if (positiveBtnOnclickListener != null) {
                positiveBtnOnclickListener.onClick();
            }
        });
        return this;
    }

    public DialogBuilder setHyperLink(String text2) {
        this.hyperlink = new Hyperlink(text2);
        this.hyperlink.setBorder(Border.EMPTY);
        this.hyperlink.setOnMouseClicked(event -> MyUtils.setLinkAutoAction(this.hyperlink));
        return this;
    }

    public DialogBuilder setTextFieldText(OnInputListener onInputListener) {
        this.textField = new TextField();
        this.onInputListener = onInputListener;
        return this;
    }

    public JFXAlert<String> create() {
        this.alert = new JFXAlert((Stage)this.window);
        this.alert.initModality(Modality.APPLICATION_MODAL);
        this.alert.setOverlayClose(false);
        JFXDialogLayout layout = new JFXDialogLayout();
        layout.setHeading(new Node[]{new Label(this.title)});
        if (this.hyperlink != null) {
            layout.setBody(new Node[]{new HBox(new Node[]{new Label(this.message), this.hyperlink})});
        } else if (this.textField != null) {
            layout.setBody(new Node[]{new VBox(new Node[]{new Label(this.message), this.textField})});
            this.positiveBtn.setOnAction(event -> {
                this.alert.setResult(this.textField.getText());
                this.alert.hideWithAnimation();
            });
        } else {
            layout.setBody(new Node[]{new VBox(new Node[]{new Label(this.message)})});
        }
        if (this.negativeBtn != null && this.positiveBtn != null) {
            layout.setActions(new Node[]{this.negativeBtn, this.positiveBtn});
        } else if (this.negativeBtn != null) {
            layout.setActions(new Node[]{this.negativeBtn});
        } else if (this.positiveBtn != null) {
            layout.setActions(new Node[]{this.positiveBtn});
        }
        this.alert.setContent(new Node[]{layout});
        if (this.textField != null) {
            Optional input = this.alert.showAndWait();
            input.ifPresent(s -> this.onInputListener.onGetText((String)s));
        } else {
            this.alert.showAndWait();
        }
        return this.alert;
    }

    public static interface OnInputListener {
        public void onGetText(String var1);
    }

    public static interface OnClickListener {
        public void onClick();
    }
}

