/*
 * Decompiled with CFR 0.152.
 */
package com.wan.noveldownloader.util;

import com.wan.noveldownloader.model.DownloadedItem;
import com.wan.noveldownloader.model.DownloadingItem;
import com.wan.noveldownloader.model.NovelMessage;
import com.wan.noveldownloader.util.NovelHandler;
import com.wan.noveldownloader.util.TornadoFxUtil;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 %2\u00020\u0001:\u0001%B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\fJ\u000e\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\fJ\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020\bJ\u0006\u0010#\u001a\u00020$R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R6\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00030\u000bj\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0003`\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/wan/noveldownloader/util/NovelDownloadTool;", "", "url", "", "dir", "(Ljava/lang/String;Ljava/lang/String;)V", "beanItems", "Ljava/util/ArrayList;", "Lcom/wan/noveldownloader/model/DownloadingItem;", "Lkotlin/collections/ArrayList;", "chapterMap", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "getChapterMap", "()Ljava/util/HashMap;", "setChapterMap", "(Ljava/util/HashMap;)V", "downloadedCount", "imgDir", "Ljava/io/File;", "imgUrl", "name", "novelHandler", "Lcom/wan/noveldownloader/util/NovelHandler;", "tempFileHead", "txtDir", "download", "", "threadCount", "downloadChapter", "index", "downloadImage", "Ljava/net/URL;", "getMessage", "mergeFile", "Lcom/wan/noveldownloader/model/DownloadedItem;", "Companion", "NovelDownloader"})
public final class NovelDownloadTool {
    @NotNull
    private HashMap<Integer, String> chapterMap;
    private NovelHandler novelHandler;
    private String name;
    private String imgUrl;
    private String tempFileHead;
    private int downloadedCount;
    private ArrayList<DownloadingItem> beanItems;
    private File txtDir;
    private File imgDir;
    private String url;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final HashMap<Integer, String> getChapterMap() {
        return this.chapterMap;
    }

    public final void setChapterMap(@NotNull HashMap<Integer, String> hashMap) {
        Intrinsics.checkParameterIsNotNull(hashMap, "<set-?>");
        this.chapterMap = hashMap;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DownloadingItem getMessage() {
        void tempFileHead;
        void imgUrl;
        void novelName;
        this.novelHandler = new NovelHandler(this.url);
        NovelMessage novelMessage = new NovelHandler(this.url).getMessage();
        String string2 = novelMessage.component1();
        String string3 = novelMessage.component2();
        String string4 = novelMessage.component3();
        HashMap<Integer, String> chapterMap = novelMessage.component4();
        this.name = novelName;
        this.imgUrl = imgUrl;
        this.tempFileHead = tempFileHead;
        this.chapterMap = chapterMap;
        return new DownloadingItem(this.name, (String)imgUrl, 0.0, "0.00%", "0/" + chapterMap.size(), "\u89e3\u6790\u4fe1\u606f\u4e2d");
    }

    /*
     * WARNING - void declaration
     */
    public final boolean download(int threadCount) {
        CountDownLatch countDownLatch = new CountDownLatch(threadCount);
        int step = this.chapterMap.size() / threadCount;
        int yu = this.chapterMap.size() % threadCount;
        ThreadsKt.thread$default(false, false, null, null, 0, new Function0<Unit>(this, step, countDownLatch){
            final /* synthetic */ NovelDownloadTool this$0;
            final /* synthetic */ int $step;
            final /* synthetic */ CountDownLatch $countDownLatch;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                int n = 0;
                int n2 = this.$step;
                while (n < n2) {
                    void i2;
                    this.this$0.downloadChapter((int)i2);
                    ++i2;
                }
                this.$countDownLatch.countDown();
            }
            {
                this.this$0 = novelDownloadTool;
                this.$step = n;
                this.$countDownLatch = countDownLatch;
                super(0);
            }
        }, 31, null);
        ThreadsKt.thread$default(false, false, null, null, 0, new Function0<Unit>(this, yu, countDownLatch){
            final /* synthetic */ NovelDownloadTool this$0;
            final /* synthetic */ int $yu;
            final /* synthetic */ CountDownLatch $countDownLatch;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                int n = this.this$0.getChapterMap().size() - this.$yu;
                int n2 = this.this$0.getChapterMap().size();
                while (n < n2) {
                    void i2;
                    this.this$0.downloadChapter((int)i2);
                    ++i2;
                }
                this.$countDownLatch.countDown();
            }
            {
                this.this$0 = novelDownloadTool;
                this.$yu = n;
                this.$countDownLatch = countDownLatch;
                super(0);
            }
        }, 31, null);
        int n = 1;
        int n2 = threadCount - 2;
        if (n <= n2) {
            while (true) {
                void i2;
                ThreadsKt.thread$default(false, false, null, null, 0, new Function0<Unit>(this, (int)i2, step, countDownLatch){
                    final /* synthetic */ NovelDownloadTool this$0;
                    final /* synthetic */ int $i;
                    final /* synthetic */ int $step;
                    final /* synthetic */ CountDownLatch $countDownLatch;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        int n = this.$i * this.$step;
                        int n2 = (this.$i + 1) * this.$step;
                        while (n < n2) {
                            void j;
                            this.this$0.downloadChapter((int)j);
                            ++j;
                        }
                        this.$countDownLatch.countDown();
                    }
                    {
                        this.this$0 = novelDownloadTool;
                        this.$i = n;
                        this.$step = n2;
                        this.$countDownLatch = countDownLatch;
                        super(0);
                    }
                }, 31, null);
                if (i2 == n2) break;
                ++i2;
            }
        }
        countDownLatch.await();
        return true;
    }

    public static /* bridge */ /* synthetic */ boolean download$default(NovelDownloadTool novelDownloadTool, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 5;
        }
        return novelDownloadTool.download(n);
    }

    @NotNull
    public final URL downloadImage() {
        String string2 = this.imgDir.getPath();
        Intrinsics.checkExpressionValueIsNotNull(string2, "imgDir.path");
        File file2 = TornadoFxUtil.Companion.downloadImage(this.imgUrl, string2, "");
        URL uRL = file2.toURI().toURL();
        Intrinsics.checkExpressionValueIsNotNull(uRL, "file.toURI().toURL()");
        return uRL;
    }

    @NotNull
    public final DownloadingItem downloadChapter(int index) {
        String fileName = this.tempFileHead + index;
        File file2 = new File(this.txtDir, fileName + ".txt");
        if (!file2.exists()) {
            String content;
            String string2;
            NovelHandler novelHandler = this.novelHandler;
            if (novelHandler != null) {
                String string3 = this.chapterMap.get(index);
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                string2 = novelHandler.getContent(string3);
            } else {
                string2 = null;
            }
            String string4 = content = string2;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            String string5 = "GBK";
            String string6 = string4;
            File file3 = file2;
            Charset charset = Charset.forName(string5);
            Intrinsics.checkExpressionValueIsNotNull(charset, "Charset.forName(charsetName)");
            Charset charset2 = charset;
            FilesKt.writeText(file3, string6, charset2);
        }
        double temp = (double)(this.downloadedCount + 1) / ((double)this.chapterMap.size() * 1.0);
        DecimalFormat df = new DecimalFormat("0.00");
        String progressText = df.format(temp * (double)100) + '%';
        int n = this.downloadedCount;
        this.downloadedCount = n + 1;
        if (temp == 1.0) {
            DownloadingItem item2 = new DownloadingItem(this.name, this.imgUrl, temp, progressText, "" + (this.downloadedCount + 1) + '/' + this.chapterMap.size(), "\u5408\u5e76\u4e2d");
            this.beanItems.add(item2);
            return item2;
        }
        DownloadingItem item3 = new DownloadingItem(this.name, this.imgUrl, temp, progressText, "" + (this.downloadedCount + 1) + '/' + this.chapterMap.size(), "\u4e0b\u8f7d\u4e2d");
        this.beanItems.add(item3);
        return item3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DownloadedItem mergeFile() {
        Object object;
        Comparable<StringBuilder> comparable;
        String string2;
        if (StringsKt.contains$default((CharSequence)this.name, ":", false, 2, null)) {
            string2 = StringsKt.replace$default(this.name, ":", "", false, 4, null) + ".txt";
        } else {
            String string3 = this.name;
            comparable = new StringBuilder();
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            object = ((Object)StringsKt.trim((CharSequence)string4)).toString();
            string2 = comparable.append((String)object).append(".txt").toString();
        }
        String fileName = string2;
        File file2 = new File(this.txtDir, fileName);
        StringBuffer bf = new StringBuffer("");
        int n = 0;
        int n2 = this.chapterMap.size();
        while (n < n2) {
            void i2;
            File tempFile = new File(this.txtDir, this.tempFileHead + (int)i2 + ".txt");
            if (tempFile.exists()) {
                String string5 = "gbk";
                comparable = tempFile;
                Intrinsics.checkExpressionValueIsNotNull(Charset.forName(string5), "Charset.forName(charsetName)");
                String bytes = FilesKt.readText((File)comparable, (Charset)object);
                bf.append(bytes);
                tempFile.delete();
            }
            ++i2;
        }
        String string6 = bf.toString();
        Intrinsics.checkExpressionValueIsNotNull(string6, "bf.toString()");
        String i2 = "gbk";
        object = string6;
        comparable = file2;
        Charset charset = Charset.forName(i2);
        Intrinsics.checkExpressionValueIsNotNull(charset, "Charset.forName(charsetName)");
        Charset charset2 = charset;
        FilesKt.writeText((File)comparable, (String)object, charset2);
        String date = new SimpleDateFormat("yyyy/MM/dd HH:mm").format(new Date(file2.lastModified()));
        double fileSize = (double)file2.length() / 1048576.0;
        DecimalFormat df = new DecimalFormat("0.00");
        String string7 = "\u5927\u5c0f\uff1a" + df.format(fileSize) + "MB";
        File file3 = file2.getParentFile();
        Intrinsics.checkExpressionValueIsNotNull(file3, "file.parentFile");
        String string8 = file3.getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull(string8, "file.parentFile.canonicalPath");
        String string9 = date;
        Intrinsics.checkExpressionValueIsNotNull(string9, "date");
        return new DownloadedItem(this.name, this.imgUrl, string7, string8, string9);
    }

    public NovelDownloadTool(@NotNull String url, @NotNull String dir) {
        Intrinsics.checkParameterIsNotNull(url, "url");
        Intrinsics.checkParameterIsNotNull(dir, "dir");
        this.url = url;
        NovelDownloadTool novelDownloadTool = this;
        Cloneable cloneable2 = new HashMap();
        novelDownloadTool.chapterMap = cloneable2;
        this.name = "";
        this.imgUrl = "";
        this.tempFileHead = "";
        novelDownloadTool = this;
        cloneable2 = new ArrayList();
        novelDownloadTool.beanItems = cloneable2;
        File file2 = this.txtDir = Intrinsics.areEqual(dir, "") ? new File(".", "\u661f\u4e4b\u5c0f\u8bf4\u4e0b\u8f7d\u5668") : new File(dir);
        if (!this.txtDir.exists()) {
            this.txtDir.mkdirs();
        }
        this.imgDir = new File(this.txtDir, "img");
        if (!this.imgDir.exists()) {
            this.imgDir.mkdirs();
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/wan/noveldownloader/util/NovelDownloadTool$Companion;", "", "()V", "readConfig", "Ljava/util/Properties;", "NovelDownloader"})
    public static final class Companion {
        @Nullable
        public final Properties readConfig() {
            File configFile = new File("config.properties");
            if (configFile.exists()) {
                Properties pro = new Properties();
                pro.load(new FileInputStream(configFile));
                return pro;
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

