/*
 * Decompiled with CFR 0.152.
 */
package com.wan.noveldownloader.util;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/wan/noveldownloader/util/TornadoFxUtil;", "", "()V", "Companion", "NovelDownloader"})
public final class TornadoFxUtil {
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006J\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\u0006J \u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\u0006\u00a8\u0006\f"}, d2={"Lcom/wan/noveldownloader/util/TornadoFxUtil$Companion;", "", "()V", "downloadFile", "Ljava/io/File;", "url", "", "file", "fileName", "dir", "downloadImage", "imageName", "NovelDownloader"})
    public static final class Companion {
        @NotNull
        public final File downloadFile(@NotNull String url, @NotNull String fileName) {
            Intrinsics.checkParameterIsNotNull(url, "url");
            Intrinsics.checkParameterIsNotNull(fileName, "fileName");
            return this.downloadFile(url, new File(fileName));
        }

        @NotNull
        public final File downloadFile(@NotNull String url, @NotNull String dir, @NotNull String fileName) {
            Intrinsics.checkParameterIsNotNull(url, "url");
            Intrinsics.checkParameterIsNotNull(dir, "dir");
            Intrinsics.checkParameterIsNotNull(fileName, "fileName");
            return this.downloadFile(url, new File(dir + fileName));
        }

        @NotNull
        public final File downloadFile(@NotNull String url, @NotNull File file2) {
            Intrinsics.checkParameterIsNotNull(url, "url");
            Intrinsics.checkParameterIsNotNull(file2, "file");
            URLConnection openConnection = new URL(url).openConnection();
            openConnection.addRequestProperty("user-agent", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36");
            InputStream inputStream = openConnection.getInputStream();
            Intrinsics.checkExpressionValueIsNotNull(inputStream, "openConnection.getInputStream()");
            byte[] bytes = ByteStreamsKt.readBytes$default(inputStream, 0, 1, null);
            FilesKt.writeBytes(file2, bytes);
            return file2;
        }

        @NotNull
        public final File downloadImage(@NotNull String url, @NotNull File file2) {
            byte[] byArray;
            Intrinsics.checkParameterIsNotNull(url, "url");
            Intrinsics.checkParameterIsNotNull(file2, "file");
            URLConnection openConnection = new URL(url).openConnection();
            openConnection.addRequestProperty("user-agent", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36");
            URLConnection uRLConnection = openConnection;
            Intrinsics.checkExpressionValueIsNotNull(uRLConnection, "openConnection");
            if (Intrinsics.areEqual(uRLConnection.getContentEncoding(), "gzip")) {
                byArray = ByteStreamsKt.readBytes$default(new GZIPInputStream(openConnection.getInputStream()), 0, 1, null);
            } else {
                InputStream inputStream = openConnection.getInputStream();
                Intrinsics.checkExpressionValueIsNotNull(inputStream, "openConnection.getInputStream()");
                byArray = ByteStreamsKt.readBytes$default(inputStream, 0, 1, null);
            }
            byte[] bytes = byArray;
            FilesKt.writeBytes(file2, bytes);
            return file2;
        }

        @NotNull
        public final File downloadImage(@NotNull String url, @NotNull String imageName) {
            Intrinsics.checkParameterIsNotNull(url, "url");
            Intrinsics.checkParameterIsNotNull(imageName, "imageName");
            return this.downloadImage(url, new File(imageName));
        }

        @NotNull
        public static /* bridge */ /* synthetic */ File downloadImage$default(Companion companion, String string2, String string3, int n, Object object) {
            if ((n & 2) != 0) {
                string3 = "";
            }
            return companion.downloadImage(string2, string3);
        }

        @NotNull
        public final File downloadImage(@NotNull String url, @NotNull String dir, @NotNull String imageName) {
            Intrinsics.checkParameterIsNotNull(url, "url");
            Intrinsics.checkParameterIsNotNull(dir, "dir");
            Intrinsics.checkParameterIsNotNull(imageName, "imageName");
            File file2 = StringsKt.isBlank(imageName) ? new File(dir, StringsKt.substringAfterLast$default(url, "/", null, 2, null)) : new File(dir, imageName);
            return this.downloadImage(url, file2);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ File downloadImage$default(Companion companion, String string2, String string3, String string4, int n, Object object) {
            if ((n & 4) != 0) {
                string4 = "";
            }
            return companion.downloadImage(string2, string3, string4);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

