/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.scopes;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindExclude;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DescriptorKindFilter {
    private final int kindMask;
    @NotNull
    private final List<DescriptorKindExclude> excludes;
    private static int nextMaskValue;
    private static final int NON_SINGLETON_CLASSIFIERS_MASK;
    private static final int SINGLETON_CLASSIFIERS_MASK;
    private static final int TYPE_ALIASES_MASK;
    private static final int PACKAGES_MASK;
    private static final int FUNCTIONS_MASK;
    private static final int VARIABLES_MASK;
    private static final int ALL_KINDS_MASK;
    private static final int CLASSIFIERS_MASK;
    private static final int VALUES_MASK;
    private static final int CALLABLES_MASK;
    @JvmField
    @NotNull
    public static final DescriptorKindFilter ALL;
    @JvmField
    @NotNull
    public static final DescriptorKindFilter CALLABLES;
    @JvmField
    @NotNull
    public static final DescriptorKindFilter NON_SINGLETON_CLASSIFIERS;
    @JvmField
    @NotNull
    public static final DescriptorKindFilter SINGLETON_CLASSIFIERS;
    @JvmField
    @NotNull
    public static final DescriptorKindFilter TYPE_ALIASES;
    @JvmField
    @NotNull
    public static final DescriptorKindFilter CLASSIFIERS;
    @JvmField
    @NotNull
    public static final DescriptorKindFilter PACKAGES;
    @JvmField
    @NotNull
    public static final DescriptorKindFilter FUNCTIONS;
    @JvmField
    @NotNull
    public static final DescriptorKindFilter VARIABLES;
    @JvmField
    @NotNull
    public static final DescriptorKindFilter VALUES;
    private static final List<Companion.MaskToName> DEBUG_PREDEFINED_FILTERS_MASK_NAMES;
    private static final List<Companion.MaskToName> DEBUG_MASK_BIT_NAMES;
    public static final Companion Companion;

    public final int getKindMask() {
        return this.kindMask;
    }

    public final boolean acceptsKinds(int kinds) {
        return (this.kindMask & kinds) != 0;
    }

    @Nullable
    public final DescriptorKindFilter restrictedToKindsOrNull(int kinds) {
        int mask = this.kindMask & kinds;
        if (mask == 0) {
            return null;
        }
        return new DescriptorKindFilter(mask, this.excludes);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        Object v0;
        block3: {
            Iterable $receiver$iv = DEBUG_PREDEFINED_FILTERS_MASK_NAMES;
            for (Object element$iv : $receiver$iv) {
                Companion.MaskToName it = (Companion.MaskToName)element$iv;
                if (!(it.getMask() == this.kindMask)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Companion.MaskToName maskToName = v0;
        String predefinedFilterName = maskToName != null ? maskToName.getName() : null;
        String string2 = predefinedFilterName;
        if (string2 == null) {
            void $receiver$iv$iv;
            Object element$iv;
            Iterable $receiver$iv = DEBUG_MASK_BIT_NAMES;
            element$iv = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                String string3;
                Object element$iv$iv = element$iv$iv$iv;
                Companion.MaskToName it = (Companion.MaskToName)element$iv$iv;
                String string4 = this.acceptsKinds(it.getMask()) ? it.getName() : null;
                if (string4 == null) continue;
                String it$iv$iv = string3 = string4;
                destination$iv$iv.add(it$iv$iv);
            }
            string2 = CollectionsKt.joinToString$default((List)destination$iv$iv, " | ", null, null, 0, null, null, 62, null);
        }
        String kindString = string2;
        return "DescriptorKindFilter(" + kindString + ", " + this.excludes + ')';
    }

    @NotNull
    public final List<DescriptorKindExclude> getExcludes() {
        return this.excludes;
    }

    public DescriptorKindFilter(int kindMask, @NotNull List<? extends DescriptorKindExclude> excludes) {
        Intrinsics.checkParameterIsNotNull(excludes, "excludes");
        this.excludes = excludes;
        int mask = kindMask;
        Iterable $receiver$iv = this.excludes;
        for (Object element$iv : $receiver$iv) {
            DescriptorKindExclude it = (DescriptorKindExclude)element$iv;
            mask &= ~it.getFullyExcludedDescriptorKinds();
        }
        this.kindMask = mask;
    }

    public /* synthetic */ DescriptorKindFilter(int n, List list, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(n, list);
    }

    /*
     * WARNING - void declaration
     */
    static {
        Field field2;
        Object element$iv$iv;
        void element$iv$iv$iv;
        void it$iv;
        void $receiver$iv$iv$iv;
        Companion = new Companion(null);
        nextMaskValue = 1;
        NON_SINGLETON_CLASSIFIERS_MASK = DescriptorKindFilter.Companion.nextMask();
        SINGLETON_CLASSIFIERS_MASK = DescriptorKindFilter.Companion.nextMask();
        TYPE_ALIASES_MASK = DescriptorKindFilter.Companion.nextMask();
        PACKAGES_MASK = DescriptorKindFilter.Companion.nextMask();
        FUNCTIONS_MASK = DescriptorKindFilter.Companion.nextMask();
        VARIABLES_MASK = DescriptorKindFilter.Companion.nextMask();
        ALL_KINDS_MASK = DescriptorKindFilter.Companion.nextMask() - 1;
        CLASSIFIERS_MASK = NON_SINGLETON_CLASSIFIERS_MASK | SINGLETON_CLASSIFIERS_MASK | TYPE_ALIASES_MASK;
        VALUES_MASK = SINGLETON_CLASSIFIERS_MASK | FUNCTIONS_MASK | VARIABLES_MASK;
        CALLABLES_MASK = FUNCTIONS_MASK | VARIABLES_MASK;
        ALL = new DescriptorKindFilter(ALL_KINDS_MASK, null, 2, null);
        CALLABLES = new DescriptorKindFilter(CALLABLES_MASK, null, 2, null);
        NON_SINGLETON_CLASSIFIERS = new DescriptorKindFilter(NON_SINGLETON_CLASSIFIERS_MASK, null, 2, null);
        SINGLETON_CLASSIFIERS = new DescriptorKindFilter(SINGLETON_CLASSIFIERS_MASK, null, 2, null);
        TYPE_ALIASES = new DescriptorKindFilter(TYPE_ALIASES_MASK, null, 2, null);
        CLASSIFIERS = new DescriptorKindFilter(CLASSIFIERS_MASK, null, 2, null);
        PACKAGES = new DescriptorKindFilter(PACKAGES_MASK, null, 2, null);
        FUNCTIONS = new DescriptorKindFilter(FUNCTIONS_MASK, null, 2, null);
        VARIABLES = new DescriptorKindFilter(VARIABLES_MASK, null, 2, null);
        VALUES = new DescriptorKindFilter(VALUES_MASK, null, 2, null);
        Companion this_$iv = Companion;
        Field[] fieldArray = DescriptorKindFilter.class.getFields();
        Intrinsics.checkExpressionValueIsNotNull(fieldArray, "T::class.java.fields");
        Object $receiver$iv$iv = fieldArray;
        Field[] fieldArray2 = $receiver$iv$iv;
        Object destination$iv$iv$iv = new ArrayList();
        int n = ((void)$receiver$iv$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void v1 = it$iv = (element$iv$iv$iv = $receiver$iv$iv$iv[j]);
            Intrinsics.checkExpressionValueIsNotNull(v1, "it");
            if (!Modifier.isStatic(v1.getModifiers())) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        Iterable $receiver$iv = (List)destination$iv$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        Object destination$iv$iv = new ArrayList();
        Object $receiver$iv$iv$iv2 = $receiver$iv$iv;
        Iterator iterator2 = $receiver$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            Companion.MaskToName $i$f$filter;
            Companion.MaskToName maskToName;
            DescriptorKindFilter filter2;
            Object element$iv$iv$iv2 = iterator2.next();
            element$iv$iv = element$iv$iv$iv2;
            field2 = (Field)element$iv$iv;
            Object object = field2.get(null);
            if (!(object instanceof DescriptorKindFilter)) {
                object = null;
            }
            if ((filter2 = (DescriptorKindFilter)object) != null) {
                int n2 = filter2.kindMask;
                Field field3 = field2;
                Intrinsics.checkExpressionValueIsNotNull(field3, "field");
                String string2 = field3.getName();
                Intrinsics.checkExpressionValueIsNotNull(string2, "field.name");
                maskToName = new Companion.MaskToName(n2, string2);
            } else {
                maskToName = null;
            }
            if (maskToName == null) continue;
            Companion.MaskToName it$iv$iv = $i$f$filter = maskToName;
            destination$iv$iv.add(it$iv$iv);
        }
        DEBUG_PREDEFINED_FILTERS_MASK_NAMES = CollectionsKt.toList((List)destination$iv$iv);
        this_$iv = Companion;
        Field[] fieldArray3 = DescriptorKindFilter.class.getFields();
        Intrinsics.checkExpressionValueIsNotNull(fieldArray3, "T::class.java.fields");
        destination$iv$iv = $receiver$iv$iv = fieldArray3;
        destination$iv$iv$iv = new ArrayList();
        int n3 = ((void)$receiver$iv$iv$iv).length;
        for (int element$iv$iv$iv2 = 0; element$iv$iv$iv2 < n3; ++element$iv$iv$iv2) {
            void v8 = it$iv = (element$iv$iv$iv = $receiver$iv$iv$iv[element$iv$iv$iv2]);
            Intrinsics.checkExpressionValueIsNotNull(v8, "it");
            if (!Modifier.isStatic(v8.getModifiers())) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        destination$iv$iv$iv = $receiver$iv$iv.iterator();
        while (destination$iv$iv$iv.hasNext()) {
            Field it;
            Object element$iv$iv2 = destination$iv$iv$iv.next();
            Field field4 = it = (Field)element$iv$iv2;
            Intrinsics.checkExpressionValueIsNotNull(field4, "it");
            if (!Intrinsics.areEqual(field4.getType(), Integer.TYPE)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        $receiver$iv$iv$iv2 = $receiver$iv$iv;
        Iterator iterator3 = $receiver$iv$iv$iv2.iterator();
        while (iterator3.hasNext()) {
            Companion.MaskToName maskToName;
            Companion.MaskToName maskToName2;
            boolean isOneBitMask;
            Object element$iv$iv$iv3;
            element$iv$iv = element$iv$iv$iv3 = iterator3.next();
            field2 = (Field)element$iv$iv;
            Object object = field2.get(null);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
            }
            int mask = (Integer)object;
            boolean bl = isOneBitMask = mask == (mask & -mask);
            if (isOneBitMask) {
                Field field5 = field2;
                Intrinsics.checkExpressionValueIsNotNull(field5, "field");
                String string3 = field5.getName();
                Intrinsics.checkExpressionValueIsNotNull(string3, "field.name");
                maskToName2 = new Companion.MaskToName(mask, string3);
            } else {
                maskToName2 = null;
            }
            if (maskToName2 == null) continue;
            Companion.MaskToName it$iv$iv = maskToName = maskToName2;
            destination$iv$iv.add(it$iv$iv);
        }
        DEBUG_MASK_BIT_NAMES = CollectionsKt.toList((List)fieldArray2);
    }

    public static final class Companion {
        private final int nextMask() {
            int n;
            int $receiver = n = nextMaskValue;
            nextMaskValue = nextMaskValue << 1;
            return n;
        }

        public final int getNON_SINGLETON_CLASSIFIERS_MASK() {
            return NON_SINGLETON_CLASSIFIERS_MASK;
        }

        public final int getSINGLETON_CLASSIFIERS_MASK() {
            return SINGLETON_CLASSIFIERS_MASK;
        }

        public final int getTYPE_ALIASES_MASK() {
            return TYPE_ALIASES_MASK;
        }

        public final int getPACKAGES_MASK() {
            return PACKAGES_MASK;
        }

        public final int getFUNCTIONS_MASK() {
            return FUNCTIONS_MASK;
        }

        public final int getVARIABLES_MASK() {
            return VARIABLES_MASK;
        }

        public final int getALL_KINDS_MASK() {
            return ALL_KINDS_MASK;
        }

        public final int getCLASSIFIERS_MASK() {
            return CLASSIFIERS_MASK;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static final class MaskToName {
            private final int mask;
            @NotNull
            private final String name;

            public final int getMask() {
                return this.mask;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            public MaskToName(int mask, @NotNull String name) {
                Intrinsics.checkParameterIsNotNull(name, "name");
                this.mask = mask;
                this.name = name;
            }
        }
    }
}

