/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.NotFoundClasses;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.constants.AnnotationValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.BooleanValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ByteValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.CharValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValueFactory;
import kotlin.reflect.jvm.internal.impl.resolve.constants.DoubleValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.EnumValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ErrorValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.FloatValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.LongValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ShortValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.StringValue;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationDeserializer$WhenMappings;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolverUtilKt;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;

public final class AnnotationDeserializer {
    private final ModuleDescriptor module;
    private final NotFoundClasses notFoundClasses;

    private final KotlinBuiltIns getBuiltIns() {
        return this.module.getBuiltIns();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AnnotationDescriptor deserializeAnnotation(@NotNull ProtoBuf.Annotation proto, @NotNull NameResolver nameResolver) {
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        ClassDescriptor annotationClass = this.resolveClass(NameResolverUtilKt.getClassId(nameResolver, proto.getId()));
        Map<Name, ConstantValue<Object>> arguments2 = MapsKt.emptyMap();
        if (proto.getArgumentCount() != 0 && !ErrorUtils.isError(annotationClass) && DescriptorUtils.isAnnotationClass(annotationClass)) {
            Collection<ClassConstructorDescriptor> collection = annotationClass.getConstructors();
            Intrinsics.checkExpressionValueIsNotNull(collection, "annotationClass.constructors");
            ClassConstructorDescriptor constructor = (ClassConstructorDescriptor)CollectionsKt.singleOrNull((Iterable)collection);
            if (constructor != null) {
                void $receiver$iv$iv;
                void $receiver$iv$iv2;
                List<ValueParameterDescriptor> list = constructor.getValueParameters();
                Intrinsics.checkExpressionValueIsNotNull(list, "constructor.valueParameters");
                Iterable $receiver$iv = list;
                int capacity$iv22 = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10)), 16);
                Iterable iterable = $receiver$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
                for (Object element$iv$iv : $receiver$iv$iv2) {
                    void it;
                    ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)element$iv$iv;
                    Map map2 = destination$iv$iv;
                    void v2 = it;
                    Intrinsics.checkExpressionValueIsNotNull(v2, "it");
                    Name name = v2.getName();
                    map2.put(name, element$iv$iv);
                }
                Map parameterByName = destination$iv$iv;
                List<ProtoBuf.Annotation.Argument> list2 = proto.getArgumentList();
                Intrinsics.checkExpressionValueIsNotNull(list2, "proto.argumentList");
                Iterable capacity$iv22 = $receiver$iv = (Iterable)list2;
                Collection destination$iv$iv2 = new ArrayList();
                void $receiver$iv$iv$iv = $receiver$iv$iv;
                Iterator iterator2 = $receiver$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Pair<Name, ConstantValue<?>> pair;
                    ProtoBuf.Annotation.Argument it;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    ProtoBuf.Annotation.Argument argument = it = (ProtoBuf.Annotation.Argument)element$iv$iv;
                    Intrinsics.checkExpressionValueIsNotNull(argument, "it");
                    if (this.resolveArgument(argument, parameterByName, nameResolver) == null) continue;
                    Pair<Name, ConstantValue<?>> it$iv$iv = pair;
                    destination$iv$iv2.add(it$iv$iv);
                }
                arguments2 = MapsKt.toMap((List)destination$iv$iv2);
            }
        }
        return new AnnotationDescriptorImpl(annotationClass.getDefaultType(), arguments2, SourceElement.NO_SOURCE);
    }

    private final Pair<Name, ConstantValue<?>> resolveArgument(ProtoBuf.Annotation.Argument proto, Map<Name, ? extends ValueParameterDescriptor> parameterByName, NameResolver nameResolver) {
        ValueParameterDescriptor valueParameterDescriptor = parameterByName.get(NameResolverUtilKt.getName(nameResolver, proto.getNameId()));
        if (valueParameterDescriptor == null) {
            return null;
        }
        ValueParameterDescriptor parameter = valueParameterDescriptor;
        Name name = NameResolverUtilKt.getName(nameResolver, proto.getNameId());
        KotlinType kotlinType = parameter.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "parameter.type");
        ProtoBuf.Annotation.Argument.Value value = proto.getValue();
        Intrinsics.checkExpressionValueIsNotNull(value, "proto.value");
        return new Pair(name, this.resolveValue(kotlinType, value, nameResolver));
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final ConstantValue<?> resolveValue(@NotNull KotlinType expectedType, @NotNull ProtoBuf.Annotation.Argument.Value value, @NotNull NameResolver nameResolver) {
        Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
        Intrinsics.checkParameterIsNotNull(value, "value");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        v0 = value.getType();
        if (v0 == null) ** GOTO lbl-1000
        switch (AnnotationDeserializer$WhenMappings.$EnumSwitchMapping$0[v0.ordinal()]) {
            case 1: {
                v1 = new ByteValue((byte)value.getIntValue());
                break;
            }
            case 2: {
                v1 = new CharValue((char)value.getIntValue());
                break;
            }
            case 3: {
                v1 = new ShortValue((short)value.getIntValue());
                break;
            }
            case 4: {
                v1 = new IntValue((int)value.getIntValue());
                break;
            }
            case 5: {
                v1 = new LongValue(value.getIntValue());
                break;
            }
            case 6: {
                v1 = new FloatValue(value.getFloatValue());
                break;
            }
            case 7: {
                v1 = new DoubleValue(value.getDoubleValue());
                break;
            }
            case 8: {
                v1 = new BooleanValue(value.getIntValue() != 0L);
                break;
            }
            case 9: {
                v1 = new StringValue(nameResolver.getString(value.getStringValue()));
                break;
            }
            case 10: {
                v1 = this.resolveClassLiteralValue(NameResolverUtilKt.getClassId(nameResolver, value.getClassId()));
                break;
            }
            case 11: {
                v1 = new EnumValue(NameResolverUtilKt.getClassId(nameResolver, value.getClassId()), NameResolverUtilKt.getName(nameResolver, value.getEnumValueId()));
                break;
            }
            case 12: {
                v2 = value.getAnnotation();
                Intrinsics.checkExpressionValueIsNotNull(v2, "value.annotation");
                v1 = new AnnotationValue(this.deserializeAnnotation(v2, nameResolver));
                break;
            }
            case 13: {
                expectedIsArray = KotlinBuiltIns.isArray(expectedType) != false || KotlinBuiltIns.isPrimitiveArray(expectedType) != false;
                v3 = arrayElements = value.getArrayElementList();
                Intrinsics.checkExpressionValueIsNotNull(v3, "arrayElements");
                var8_7 = v3;
                if (var8_7.isEmpty() == false) {
                    v4 = CollectionsKt.first(arrayElements);
                    Intrinsics.checkExpressionValueIsNotNull(v4, "arrayElements.first()");
                    actualElementType = this.resolveArrayElementType(v4, nameResolver);
                    v5 = this.getBuiltIns().getPrimitiveArrayKotlinTypeByPrimitiveKotlinType(actualElementType);
                    if (v5 != null) {
                        v6 = v5;
                    } else {
                        v7 = this.getBuiltIns().getArrayType(Variance.INVARIANT, actualElementType);
                        Intrinsics.checkExpressionValueIsNotNull(v7, "builtIns.getArrayType(Va\u2026RIANT, actualElementType)");
                        v6 = v7;
                    }
                } else if (expectedIsArray) {
                    v6 = expectedType;
                } else {
                    v8 = this.getBuiltIns().getArrayType(Variance.INVARIANT, this.getBuiltIns().getAnyType());
                    Intrinsics.checkExpressionValueIsNotNull(v8, "builtIns.getArrayType(Va\u2026ARIANT, builtIns.anyType)");
                    v6 = v8;
                }
                actualArrayType = v6;
                expectedElementType = this.getBuiltIns().getArrayElementType(expectedIsArray != false ? expectedType : actualArrayType);
                var9_9 = arrayElements;
                var18_10 = ConstantValueFactory.INSTANCE;
                var10_11 = $receiver$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    var14_15 = (ProtoBuf.Annotation.Argument.Value)item$iv$iv;
                    var19_16 = destination$iv$iv;
                    v9 = expectedElementType;
                    Intrinsics.checkExpressionValueIsNotNull(v9, "expectedElementType");
                    v10 = it;
                    Intrinsics.checkExpressionValueIsNotNull(v10, "it");
                    var20_17 = this.resolveValue(v9, (ProtoBuf.Annotation.Argument.Value)v10, nameResolver);
                    var19_16.add(var20_17);
                }
                var19_16 = (List)destination$iv$iv;
                v1 = var18_10.createArrayValue((List<? extends ConstantValue<?>>)var19_16, actualArrayType);
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                var5_5 = "Unsupported annotation argument type: " + value.getType() + " (expected " + expectedType + ')';
                throw (Throwable)new IllegalStateException(var5_5.toString());
            }
        }
        result = v1;
        return TypeUtilsKt.isSubtypeOf(result.getType(this.module), expectedType) != false ? result : (ConstantValue)ErrorValue.Companion.create("Unexpected argument value");
    }

    private final ConstantValue<?> resolveClassLiteralValue(ClassId classId) {
        SimpleType simpleType2 = this.resolveClass(classId).getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull(simpleType2, "resolveClass(classId).defaultType");
        KotlinType starProjectedType = TypeUtilsKt.replaceArgumentsWithStarProjections(simpleType2);
        ClassId classId2 = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.kClass.toSafe());
        Intrinsics.checkExpressionValueIsNotNull(classId2, "ClassId.topLevel(KotlinB\u2026FQ_NAMES.kClass.toSafe())");
        ClassDescriptor kClass = this.resolveClass(classId2);
        SimpleType type2 = KotlinTypeFactory.simpleNotNullType(Annotations.Companion.getEMPTY(), kClass, CollectionsKt.listOf(new TypeProjectionImpl(starProjectedType)));
        return new KClassValue(type2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final SimpleType resolveArrayElementType(ProtoBuf.Annotation.Argument.Value value, NameResolver nameResolver) {
        KotlinBuiltIns kotlinBuiltIns;
        KotlinBuiltIns $receiver = kotlinBuiltIns = this.getBuiltIns();
        ProtoBuf.Annotation.Argument.Value.Type type2 = value.getType();
        if (type2 != null) {
            switch (AnnotationDeserializer$WhenMappings.$EnumSwitchMapping$1[type2.ordinal()]) {
                case 1: {
                    SimpleType simpleType2 = $receiver.getByteType();
                    SimpleType simpleType3 = simpleType2;
                    Intrinsics.checkExpressionValueIsNotNull(simpleType2, "byteType");
                    return simpleType3;
                }
                case 2: {
                    SimpleType simpleType4 = $receiver.getCharType();
                    SimpleType simpleType3 = simpleType4;
                    Intrinsics.checkExpressionValueIsNotNull(simpleType4, "charType");
                    return simpleType3;
                }
                case 3: {
                    SimpleType simpleType5 = $receiver.getShortType();
                    SimpleType simpleType3 = simpleType5;
                    Intrinsics.checkExpressionValueIsNotNull(simpleType5, "shortType");
                    return simpleType3;
                }
                case 4: {
                    SimpleType simpleType6 = $receiver.getIntType();
                    SimpleType simpleType3 = simpleType6;
                    Intrinsics.checkExpressionValueIsNotNull(simpleType6, "intType");
                    return simpleType3;
                }
                case 5: {
                    SimpleType simpleType7 = $receiver.getLongType();
                    SimpleType simpleType3 = simpleType7;
                    Intrinsics.checkExpressionValueIsNotNull(simpleType7, "longType");
                    return simpleType3;
                }
                case 6: {
                    SimpleType simpleType8 = $receiver.getFloatType();
                    SimpleType simpleType3 = simpleType8;
                    Intrinsics.checkExpressionValueIsNotNull(simpleType8, "floatType");
                    return simpleType3;
                }
                case 7: {
                    SimpleType simpleType9 = $receiver.getDoubleType();
                    SimpleType simpleType3 = simpleType9;
                    Intrinsics.checkExpressionValueIsNotNull(simpleType9, "doubleType");
                    return simpleType3;
                }
                case 8: {
                    SimpleType simpleType10 = $receiver.getBooleanType();
                    SimpleType simpleType3 = simpleType10;
                    Intrinsics.checkExpressionValueIsNotNull(simpleType10, "booleanType");
                    return simpleType3;
                }
                case 9: {
                    SimpleType simpleType11 = $receiver.getStringType();
                    SimpleType simpleType3 = simpleType11;
                    Intrinsics.checkExpressionValueIsNotNull(simpleType11, "stringType");
                    return simpleType3;
                }
                case 10: {
                    String string2 = "Arrays of class literals are not supported yet";
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                case 11: {
                    SimpleType simpleType12 = this.resolveClass(NameResolverUtilKt.getClassId(nameResolver, value.getClassId())).getDefaultType();
                    SimpleType simpleType3 = simpleType12;
                    Intrinsics.checkExpressionValueIsNotNull(simpleType12, "resolveClass(nameResolve\u2026lue.classId)).defaultType");
                    return simpleType3;
                }
                case 12: {
                    ProtoBuf.Annotation annotation = value.getAnnotation();
                    Intrinsics.checkExpressionValueIsNotNull(annotation, "value.annotation");
                    SimpleType simpleType13 = this.resolveClass(NameResolverUtilKt.getClassId(nameResolver, annotation.getId())).getDefaultType();
                    SimpleType simpleType3 = simpleType13;
                    Intrinsics.checkExpressionValueIsNotNull(simpleType13, "resolveClass(nameResolve\u2026notation.id)).defaultType");
                    return simpleType3;
                }
                case 13: {
                    String string3 = "Array of arrays is impossible";
                    throw (Throwable)new IllegalStateException(string3.toString());
                }
            }
        }
        String string4 = "Unknown type: " + value.getType();
        throw (Throwable)new IllegalStateException(string4.toString());
    }

    private final ClassDescriptor resolveClass(ClassId classId) {
        return FindClassInModuleKt.findNonGenericClassAcrossDependencies(this.module, classId, this.notFoundClasses);
    }

    public AnnotationDeserializer(@NotNull ModuleDescriptor module, @NotNull NotFoundClasses notFoundClasses) {
        Intrinsics.checkParameterIsNotNull(module, "module");
        Intrinsics.checkParameterIsNotNull(notFoundClasses, "notFoundClasses");
        this.module = module;
        this.notFoundClasses = notFoundClasses;
    }
}

