/*
 * Decompiled with CFR 0.152.
 */
package tornadofx;

import java.util.Map;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.value.ObservableIntegerValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.Label;
import javafx.scene.layout.StackPane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tornadofx.CSSKt;
import tornadofx.DataGrid;
import tornadofx.DataGridCellFragment;
import tornadofx.DataGridCellSkin;
import tornadofx.FXKt;
import tornadofx.LibKt;
import tornadofx.PropertiesKt;
import tornadofx.Scope;
import tornadofx.Stylesheet;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0014J\r\u0010\u001b\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u001cJ\u001f\u0010\u001d\u001a\u00020\u00182\b\u0010\u001e\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001f\u001a\u00020\u0011H\u0014\u00a2\u0006\u0002\u0010 R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006!"}, d2={"Ltornadofx/DataGridCell;", "T", "Ljavafx/scene/control/IndexedCell;", "dataGrid", "Ltornadofx/DataGrid;", "(Ltornadofx/DataGrid;)V", "cache", "Ljavafx/scene/Node;", "getCache", "()Ljavafx/scene/Node;", "setCache", "(Ljavafx/scene/Node;)V", "cellFragment", "Ltornadofx/DataGridCellFragment;", "getDataGrid", "()Ltornadofx/DataGrid;", "fresh", "", "updating", "getUpdating", "()Z", "setUpdating", "(Z)V", "clearCellFragment", "", "createDefaultSkin", "Ltornadofx/DataGridCellSkin;", "doUpdateItem", "doUpdateItem$tornadofx", "updateItem", "item", "empty", "(Ljava/lang/Object;Z)V", "tornadofx"})
public class DataGridCell<T>
extends IndexedCell<T> {
    @Nullable
    private Node cache;
    private boolean updating;
    private boolean fresh;
    private DataGridCellFragment<T> cellFragment;
    @NotNull
    private final DataGrid<T> dataGrid;

    @Nullable
    public final Node getCache() {
        return this.cache;
    }

    public final void setCache(@Nullable Node node) {
        this.cache = node;
    }

    public final boolean getUpdating() {
        return this.updating;
    }

    public final void setUpdating(boolean bl) {
        this.updating = bl;
    }

    /*
     * WARNING - void declaration
     */
    public final void doUpdateItem$tornadofx() {
        int totalCount;
        int n = this.getIndex();
        Object item2 = 0 > n || (totalCount = this.dataGrid.getItems().size()) <= n ? null : this.dataGrid.getItems().get(this.getIndex());
        Function1<T, Node> cacheProvider = this.dataGrid.getCellCache();
        if (item2 != null) {
            if (cacheProvider != null) {
                Object object;
                void $receiver$iv;
                Map<T, Node> map2 = this.dataGrid.getGraphicCache$tornadofx();
                DataGridCell dataGridCell = this;
                Object value$iv = $receiver$iv.get(item2);
                if (value$iv == null) {
                    Node answer$iv = cacheProvider.invoke(item2);
                    $receiver$iv.put(item2, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                Object v = object;
                dataGridCell.cache = (Node)v;
            }
            this.updateItem(item2, false);
        } else {
            this.cache = null;
            this.updateItem(null, true);
        }
        boolean isActuallySelected = this.dataGrid.getSelectionModel().getSelectedIndices().contains((Object)this.getIndex());
        if (!this.isSelected() && isActuallySelected) {
            this.updateSelected(true);
        } else if (this.isSelected() && !isActuallySelected) {
            this.updateSelected(false);
        }
    }

    protected void updateItem(@Nullable T item2, boolean empty) {
        super.updateItem(item2, empty);
        if (item2 == null || empty) {
            this.setGraphic(null);
            this.setText(null);
            this.clearCellFragment();
        } else {
            Function2<DataGridCell<T>, T, Unit> formatter = this.dataGrid.getCellFormat();
            if (this.fresh) {
                DataGridCellFragment dataGridCellFragment;
                KClass cellFragmentType = (KClass)this.dataGrid.getProperties().get((Object)"tornadofx.cellFragment");
                if (cellFragmentType != null) {
                    Scope scope = this.dataGrid.getScope();
                    if (scope == null) {
                        scope = FXKt.getDefaultScope();
                    }
                    dataGridCellFragment = (DataGridCellFragment)FXKt.find$default(cellFragmentType, scope, null, 4, null);
                } else {
                    dataGridCellFragment = null;
                }
                this.cellFragment = dataGridCellFragment;
                this.fresh = false;
            }
            DataGridCellFragment<T> dataGridCellFragment = this.cellFragment;
            if (dataGridCellFragment != null) {
                DataGridCellFragment<T> dataGridCellFragment2;
                DataGridCellFragment<T> $receiver = dataGridCellFragment2 = dataGridCellFragment;
                Property property = (Property)$receiver.getEditingProperty();
                ReadOnlyBooleanProperty readOnlyBooleanProperty = this.editingProperty();
                Intrinsics.checkExpressionValueIsNotNull(readOnlyBooleanProperty, "editingProperty()");
                PropertiesKt.cleanBind(property, (ObservableValue)readOnlyBooleanProperty);
                $receiver.getItemProperty().setValue(item2);
                $receiver.getCellProperty().setValue((Object)this);
                this.setGraphic((Node)$receiver.getRoot());
            }
            if (this.cache != null) {
                this.setGraphic((Node)new StackPane(new Node[]{this.cache}));
                Function2<DataGridCell<T>, T, Unit> function2 = formatter;
                if (function2 != null) {
                    function2.invoke(this, item2);
                }
            } else if (formatter != null) {
                formatter.invoke(this, item2);
            } else if (this.getGraphic() == null) {
                this.setGraphic((Node)new StackPane(new Node[]{(Node)new Label(item2.toString())}));
            }
        }
    }

    private final void clearCellFragment() {
        block0: {
            DataGridCellFragment<T> dataGridCellFragment;
            DataGridCellFragment<T> dataGridCellFragment2 = this.cellFragment;
            if (dataGridCellFragment2 == null) break block0;
            DataGridCellFragment<T> $receiver = dataGridCellFragment = dataGridCellFragment2;
            $receiver.getCellProperty().setValue(null);
            $receiver.getItemProperty().setValue(null);
            $receiver.getEditingProperty().unbind();
            $receiver.getEditingProperty().setValue(Boolean.valueOf(false));
        }
    }

    @NotNull
    protected DataGridCellSkin<T> createDefaultSkin() {
        return new DataGridCellSkin(this);
    }

    @NotNull
    public final DataGrid<T> getDataGrid() {
        return this.dataGrid;
    }

    public DataGridCell(@NotNull DataGrid<T> dataGrid) {
        Intrinsics.checkParameterIsNotNull(dataGrid, "dataGrid");
        this.dataGrid = dataGrid;
        this.fresh = true;
        CSSKt.addClass(this, Stylesheet.Companion.getDatagridCell());
        ReadOnlyIntegerProperty readOnlyIntegerProperty = this.indexProperty();
        Intrinsics.checkExpressionValueIsNotNull(readOnlyIntegerProperty, "indexProperty()");
        LibKt.onChange((ObservableIntegerValue)readOnlyIntegerProperty, (Function1<? super Integer, Unit>)new Function1<Integer, Unit>(){

            @Override
            public final void invoke(int it) {
                if (it == -1) {
                    this.clearCellFragment();
                }
                if (!this.getUpdating()) {
                    this.doUpdateItem$tornadofx();
                }
            }
        });
    }
}

