/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.util.Collection;
import java.util.Objects;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.MonoSwimable;
import net.sourceforge.plantuml.activitydiagram3.PositionedNote;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileKilled;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import net.sourceforge.plantuml.activitydiagram3.gtile.GtileBox;
import net.sourceforge.plantuml.activitydiagram3.gtile.GtileWithNoteOpale;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.color.Colors;

public class InstructionSimple
extends MonoSwimable
implements Instruction {
    private boolean killed = false;
    private final Display label;
    private final Colors colors;
    private final LinkRendering inlinkRendering;
    private final BoxStyle style;
    private final Url url;
    private final Stereotype stereotype;

    @Override
    public boolean containsBreak() {
        return false;
    }

    public InstructionSimple(Display label, LinkRendering inlinkRendering, Swimlane swimlane, BoxStyle style, Url url, Colors colors, Stereotype stereotype) {
        super(swimlane);
        this.stereotype = stereotype;
        this.url = url;
        this.style = style;
        this.label = label;
        this.inlinkRendering = Objects.requireNonNull(inlinkRendering);
        this.colors = Objects.requireNonNull(colors);
    }

    @Override
    public Gtile createGtile(ISkinParam skinParam, StringBounder stringBounder) {
        GtileBox result = GtileBox.create(stringBounder, this.colors.mute(skinParam), this.label, this.getSwimlaneIn(), this.style, this.stereotype);
        if (this.hasNotes()) {
            Collection notes = this.getPositionedNotes();
            if (notes.size() != 1) {
                throw new UnsupportedOperationException("wip");
            }
            return new GtileWithNoteOpale(result, (PositionedNote)notes.iterator().next(), skinParam, false);
        }
        return result;
    }

    @Override
    public Ftile createFtile(FtileFactory factory) {
        Ftile result = factory.activity(this.label, this.getSwimlaneIn(), this.style, this.colors, this.stereotype);
        if (this.url != null) {
            result = factory.addUrl(result, this.url);
        }
        result = this.eventuallyAddNote(factory, result, result.getSwimlaneIn());
        if (this.killed) {
            return new FtileKilled(result);
        }
        return result;
    }

    @Override
    public CommandExecutionResult add(Instruction other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean kill() {
        this.killed = true;
        return true;
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.inlinkRendering;
    }
}

