/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.gtile;

import java.awt.geom.Dimension2D;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.gtile.GConnection;
import net.sourceforge.plantuml.activitydiagram3.gtile.GConnectionHorizontalThenVerticalDown;
import net.sourceforge.plantuml.activitydiagram3.gtile.GConnectionVerticalDownThenHorizontal;
import net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import net.sourceforge.plantuml.activitydiagram3.gtile.GtileColumns;
import net.sourceforge.plantuml.activitydiagram3.gtile.GtileHexagonInside;
import net.sourceforge.plantuml.activitydiagram3.gtile.Gtiles;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.utils.MathUtils;

public class GtileIfHexagon
extends GtileColumns {
    private final Gtile shape1;
    private final List<Branch> branches;
    private final Gtile shape2;
    private final UTranslate positionShape1;
    private final UTranslate positionShape2;

    @Override
    public String toString() {
        return "GtileIfHexagon " + this.gtiles;
    }

    public GtileIfHexagon(Swimlane swimlane, List<Gtile> gtiles, List<Branch> branches) {
        super(gtiles, swimlane);
        if (branches.size() <= 1) {
            throw new IllegalArgumentException();
        }
        this.branches = branches;
        this.shape1 = this.getShape1(swimlane);
        this.shape2 = Gtiles.diamondEmpty(swimlane, this.getStringBounder(), this.skinParam(), this.getDefaultStyleDefinitionDiamond(), branches.get(0).getColor());
        double height1 = this.shape1.calculateDimension(this.stringBounder).getHeight();
        ListIterator<UTranslate> it = this.positions.listIterator();
        while (it.hasNext()) {
            UTranslate tmp = (UTranslate)it.next();
            it.set(tmp.compose(UTranslate.dy(height1)));
        }
        Dimension2D totalDim = this.calculateDimensionRaw(this.stringBounder);
        this.positionShape1 = UTranslate.dx(totalDim.getWidth() / 2.0).compose(this.shape1.getCoord("NORTH_BORDER").reverse());
        this.positionShape2 = new UTranslate(totalDim.getWidth() / 2.0, totalDim.getHeight()).compose(this.shape2.getCoord("SOUTH_BORDER").reverse());
    }

    @Override
    protected UTranslate getCoordImpl(String name) {
        if (name.equals("NORTH_HOOK")) {
            return this.shape1.getCoord(name).compose(this.positionShape1);
        }
        if (name.equals("SOUTH_HOOK")) {
            return this.shape2.getCoord(name).compose(this.positionShape2);
        }
        return super.getCoordImpl(name);
    }

    private Gtile getShape1(Swimlane swimlane) {
        GtileHexagonInside tmp = Gtiles.hexagonInside(swimlane, this.getStringBounder(), this.skinParam(), this.getDefaultStyleDefinitionDiamond(), this.branches.get(0).getColor(), this.branches.get(0).getLabelTest());
        TextBlock tmp0 = this.branches.get(0).getTextBlockPositive();
        TextBlock tmp1 = this.branches.get(1).getTextBlockPositive();
        return Gtiles.withSouthMargin(tmp.withWestLabel(tmp0).withEastLabel(tmp1), 10.0);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D toto1 = this.calculateDimensionRaw(stringBounder);
        Dimension2D toto2 = this.shape1.calculateDimension(stringBounder);
        return MathUtils.max(toto1, toto2);
    }

    private Dimension2D calculateDimensionRaw(StringBounder stringBounder) {
        double height2 = this.shape2.calculateDimension(stringBounder).getHeight();
        Dimension2D nude = super.calculateDimension(stringBounder);
        return Dimension2DDouble.delta(nude, 0.0, height2);
    }

    public final StyleSignature getDefaultStyleDefinitionActivity() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.activity);
    }

    public final StyleSignature getDefaultStyleDefinitionDiamond() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.activity, SName.diamond);
    }

    public final StyleSignature getDefaultStyleDefinitionArrow() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.arrow);
    }

    @Override
    protected void drawUInternal(UGraphic ug) {
        super.drawUInternal(ug);
        ug.apply(this.positionShape1).draw(this.shape1);
        ug.apply(this.positionShape2).draw(this.shape2);
    }

    @Override
    public Collection<GConnection> getInnerConnections() {
        if (this.branches.size() == 2) {
            GConnectionHorizontalThenVerticalDown arrow1 = new GConnectionHorizontalThenVerticalDown(this.positionShape1, this.shape1.getGPoint("WEST_HOOK"), (UTranslate)this.positions.get(0), ((Gtile)this.gtiles.get(0)).getGPoint("NORTH_HOOK"), TextBlockUtils.EMPTY_TEXT_BLOCK);
            GConnectionHorizontalThenVerticalDown arrow2 = new GConnectionHorizontalThenVerticalDown(this.positionShape1, this.shape1.getGPoint("EAST_HOOK"), (UTranslate)this.positions.get(1), ((Gtile)this.gtiles.get(1)).getGPoint("NORTH_HOOK"), TextBlockUtils.EMPTY_TEXT_BLOCK);
            GConnectionVerticalDownThenHorizontal arrow3 = new GConnectionVerticalDownThenHorizontal((UTranslate)this.positions.get(0), ((Gtile)this.gtiles.get(0)).getGPoint("SOUTH_HOOK"), this.positionShape2, this.shape2.getGPoint("WEST_HOOK"), TextBlockUtils.EMPTY_TEXT_BLOCK);
            GConnectionVerticalDownThenHorizontal arrow4 = new GConnectionVerticalDownThenHorizontal((UTranslate)this.positions.get(1), ((Gtile)this.gtiles.get(1)).getGPoint("SOUTH_HOOK"), this.positionShape2, this.shape2.getGPoint("EAST_HOOK"), TextBlockUtils.EMPTY_TEXT_BLOCK);
            return Arrays.asList(arrow1, arrow2, arrow3, arrow4);
        }
        return super.getInnerConnections();
    }
}

