/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.gtile;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import net.sourceforge.plantuml.activitydiagram3.gtile.GtileColumns;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class GtileSplit
extends GtileColumns {
    private final HColor lineColor;

    public GtileSplit(List<Gtile> gtiles, Swimlane singleSwimlane, HColor lineColor) {
        super(gtiles, singleSwimlane);
        this.lineColor = lineColor;
    }

    public final StyleSignature getDefaultStyleDefinitionActivity() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.activity);
    }

    public static final StyleSignature getDefaultStyleDefinitionDiamond() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.activity, SName.diamond);
    }

    public final StyleSignature getDefaultStyleDefinitionArrow() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.arrow);
    }

    @Override
    protected void drawUInternal(UGraphic ug) {
        super.drawUInternal(ug);
        double x0 = ((Gtile)this.gtiles.get(0)).getCoord("NORTH_HOOK").compose((UTranslate)this.positions.get(0)).getDx();
        assert (this.gtiles.size() == this.positions.size());
        int last = this.gtiles.size() - 1;
        double xLast = ((Gtile)this.gtiles.get(last)).getCoord("NORTH_HOOK").compose((UTranslate)this.positions.get(last)).getDx();
        ULine hline = ULine.hline(xLast - x0);
        ug = ug.apply(this.lineColor).apply(new UStroke(1.5));
        ug.apply(UTranslate.dx(x0)).draw(hline);
        double y = this.getCoord("SOUTH_BORDER").getDy();
        ug.apply(new UTranslate(x0, y)).draw(hline);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return Dimension2DDouble.delta(super.calculateDimension(stringBounder), 0.0, 0.0);
    }
}

