/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jsondiagram;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleLoader;

public class StyleExtractor {
    private final List<String> list = new ArrayList<String>();
    private final List<StringLocated> style = new ArrayList<StringLocated>();
    private String title = null;

    public StyleExtractor(Iterator<StringLocated> data) {
        block0: while (data.hasNext()) {
            StringLocated line = data.next();
            if (this.startStyle(line)) {
                while (data.hasNext()) {
                    this.style.add(line);
                    if (this.endStyle(line)) continue block0;
                    line = data.next();
                }
                continue;
            }
            if (line.getString().trim().startsWith("!pragma ")) continue;
            if (line.getString().trim().startsWith("title ")) {
                this.title = line.getString().trim().substring("title ".length()).trim();
                continue;
            }
            if (line.getString().trim().startsWith("skinparam ")) {
                if (!line.getString().trim().contains("{")) continue;
                while (data.hasNext() && !line.getString().trim().equals("}")) {
                    line = data.next();
                }
                continue;
            }
            this.list.add(line.getString());
        }
    }

    private boolean startStyle(StringLocated line) {
        return line.getString().trim().equals("<style>");
    }

    private boolean endStyle(StringLocated line) {
        return line.getString().trim().equals("</style>");
    }

    public void applyStyles(ISkinParam skinParam) {
        if (this.style.size() > 0) {
            StyleBuilder styleBuilder = skinParam.getCurrentStyleBuilder();
            BlocLines blocLines = BlocLines.from(this.style);
            for (Style modifiedStyle : StyleLoader.getDeclaredStyles(blocLines.subExtract(1, 1), styleBuilder)) {
                skinParam.muteStyle(modifiedStyle);
            }
        }
    }

    public Iterator<String> getIterator() {
        return this.list.iterator();
    }

    public String getTitle() {
        return this.title;
    }
}

