/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import java.util.Objects;
import java.util.Set;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamBackcolored;
import net.sourceforge.plantuml.SpecificBackcolorable;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.sequencediagram.ParticipantType;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.WithStyle;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class Participant
implements SpecificBackcolorable,
WithStyle {
    private final String code;
    private Display display;
    private final ParticipantType type;
    private int initialLife = 0;
    private Stereotype stereotype;
    private boolean stereotypePositionTop;
    private final Set<EntityPortion> hiddenPortions;
    private final int order;
    private final StyleBuilder styleBuilder;
    private SymbolContext liveBackcolors;
    private Colors colors = Colors.empty();
    private Url url;

    @Override
    public StyleSignature getDefaultStyleDefinition() {
        return this.type.getDefaultStyleDefinition().addClickable(this.getUrl());
    }

    @Override
    public Style[] getUsedStyles() {
        if (!UseStyle.useBetaStyle()) {
            return null;
        }
        StyleSignature signature = this.getDefaultStyleDefinition().with(this.stereotype);
        Style tmp = signature.getMergedStyle(this.styleBuilder);
        tmp = tmp.eventuallyOverride(this.getColors(null));
        Style stereo = this.getDefaultStyleDefinition().forStereotypeItself(this.stereotype).getMergedStyle(this.styleBuilder);
        if (tmp != null) {
            stereo = tmp.mergeWith(stereo);
        }
        return new Style[]{tmp, stereo};
    }

    public Participant(ParticipantType type, String code, Display display, Set<EntityPortion> hiddenPortions, int order, StyleBuilder styleBuilder) {
        this.hiddenPortions = hiddenPortions;
        this.styleBuilder = styleBuilder;
        this.order = order;
        this.code = Objects.requireNonNull(code);
        if (code.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (Display.isNull(display) || display.size() == 0) {
            throw new IllegalArgumentException();
        }
        this.type = Objects.requireNonNull(type);
        this.display = display;
    }

    public String getCode() {
        return this.code;
    }

    public String toString() {
        return this.getCode();
    }

    public Display getDisplay(boolean underlined) {
        Display result;
        Display display = result = underlined ? this.display.underlined() : this.display;
        if (this.stereotype != null && !this.hiddenPortions.contains((Object)EntityPortion.STEREOTYPE)) {
            result = this.stereotypePositionTop ? result.addFirst(this.stereotype) : result.add(this.stereotype);
        }
        return result;
    }

    public ParticipantType getType() {
        return this.type;
    }

    public final void setStereotype(Stereotype stereotype, boolean stereotypePositionTop) {
        if (this.stereotype != null) {
            throw new IllegalStateException();
        }
        this.stereotype = Objects.requireNonNull(stereotype);
        this.stereotypePositionTop = stereotypePositionTop;
    }

    public final int getInitialLife() {
        return this.initialLife;
    }

    public final void incInitialLife(SymbolContext colors) {
        ++this.initialLife;
        this.liveBackcolors = colors;
    }

    public SymbolContext getLiveSpecificBackColors() {
        return this.liveBackcolors;
    }

    @Override
    public Colors getColors(ISkinParam skinParam) {
        return this.colors;
    }

    public void setSpecificColorTOBEREMOVED(ColorType type, HColor color) {
        if (color != null) {
            this.colors = this.colors.add(type, color);
        }
    }

    @Override
    public void setColors(Colors colors) {
        this.colors = colors;
    }

    public final Url getUrl() {
        return this.url;
    }

    public final void setUrl(Url url) {
        this.url = url;
    }

    public final Stereotype getStereotype() {
        return this.stereotype;
    }

    public ColorParam getBackgroundColorParam() {
        return this.type.getBackgroundColorParam();
    }

    public SkinParamBackcolored getSkinParamBackcolored(ISkinParam skinParam) {
        ColorParam param = this.getColorParam();
        HColor specificBackColor = this.getColors(skinParam).getColor(ColorType.BACK);
        boolean clickable = this.getUrl() != null;
        HColor stereoBackColor = skinParam.getHtmlColor(this.getBackgroundColorParam(), this.getStereotype(), clickable);
        if (stereoBackColor != null && specificBackColor == null) {
            specificBackColor = stereoBackColor;
        }
        SkinParamBackcolored result = new SkinParamBackcolored(skinParam, specificBackColor, clickable);
        HColor stereoBorderColor = skinParam.getHtmlColor(param, this.getStereotype(), clickable);
        if (stereoBorderColor != null) {
            result.forceColor(param, stereoBorderColor);
        }
        return result;
    }

    public int getOrder() {
        return this.order;
    }

    private ColorParam getColorParam() {
        if (this.getType() == ParticipantType.PARTICIPANT) {
            return ColorParam.participantBorder;
        }
        if (this.getType() == ParticipantType.ACTOR) {
            return ColorParam.actorBorder;
        }
        if (this.getType() == ParticipantType.BOUNDARY) {
            return ColorParam.boundaryBorder;
        }
        if (this.getType() == ParticipantType.CONTROL) {
            return ColorParam.controlBorder;
        }
        if (this.getType() == ParticipantType.ENTITY) {
            return ColorParam.entityBorder;
        }
        if (this.getType() == ParticipantType.QUEUE) {
            return ColorParam.queueBorder;
        }
        if (this.getType() == ParticipantType.DATABASE) {
            return ColorParam.databaseBorder;
        }
        if (this.getType() == ParticipantType.COLLECTIONS) {
            return ColorParam.collectionsBorder;
        }
        return ColorParam.participantBorder;
    }
}

