/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram.command;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.PlayerAnalog;
import net.sourceforge.plantuml.timingdiagram.TimingDiagram;

public class CommandTicks
extends SingleLineCommand2<TimingDiagram> {
    public CommandTicks() {
        super(CommandTicks.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandTicks.class.getName(), RegexLeaf.start(), new RegexLeaf("PLAYER", "([%pLN_.@]+)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("ticks"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("num"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("on"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("multiple"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("NUM", "([0-9]+)"), RegexLeaf.end());
    }

    @Override
    protected final CommandExecutionResult executeArg(TimingDiagram diagram, LineLocation location, RegexResult arg) {
        String code = arg.get("PLAYER", 0);
        Player player = diagram.getPlayer(code);
        if (player == null) {
            return CommandExecutionResult.error("No such participant " + code);
        }
        if (player instanceof PlayerAnalog) {
            ((PlayerAnalog)player).setTicks(Integer.parseInt(arg.get("NUM", 0)));
        }
        return CommandExecutionResult.ok();
    }
}

