/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.color;

import java.awt.Color;
import net.sourceforge.plantuml.svek.DotStringFactory;
import net.sourceforge.plantuml.ugraphic.color.ColorChangerMonochrome;
import net.sourceforge.plantuml.ugraphic.color.ColorOrder;
import net.sourceforge.plantuml.ugraphic.color.ColorUtils;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorAbstract;
import net.sourceforge.plantuml.ugraphic.color.HSLColor;

public class HColorSimple
extends HColorAbstract
implements HColor {
    private final Color color;
    private final boolean monochrome;

    public int hashCode() {
        return this.color.hashCode();
    }

    public String toString() {
        if (this.isTransparent()) {
            return "transparent";
        }
        return this.color.toString() + " alpha=" + this.color.getAlpha() + " monochrome=" + this.monochrome;
    }

    @Override
    public String asString() {
        if (this.isTransparent()) {
            return "transparent";
        }
        if (this.color.getAlpha() == 255) {
            return DotStringFactory.sharp000000(this.color.getRGB());
        }
        return "#" + Integer.toHexString(this.color.getRGB());
    }

    @Override
    public HColor lighten(int ratio) {
        float[] hsl = new HSLColor(this.color).getHSL();
        hsl[2] = (float)((double)hsl[2] + (double)hsl[2] * ((double)ratio / 100.0));
        return new HColorSimple(new HSLColor(hsl).getRGB(), false);
    }

    @Override
    public HColor darken(int ratio) {
        float[] hsl = new HSLColor(this.color).getHSL();
        hsl[2] = (float)((double)hsl[2] - (double)hsl[2] * ((double)ratio / 100.0));
        return new HColorSimple(new HSLColor(hsl).getRGB(), false);
    }

    @Override
    public HColor reverseHsluv() {
        return new HColorSimple(ColorUtils.reverseHsluv(this.color), false);
    }

    @Override
    public HColor reverse() {
        return new HColorSimple(ColorOrder.RGB.getReverse(this.color), false);
    }

    @Override
    public boolean isDark() {
        return ColorUtils.getGrayScale(this.color) < 128;
    }

    public boolean isTransparent() {
        return this.color.getAlpha() == 0;
    }

    public boolean equals(Object other) {
        if (!(other instanceof HColorSimple)) {
            return false;
        }
        return this.color.equals(((HColorSimple)other).color);
    }

    public HColorSimple(Color c, boolean monochrome) {
        this.color = c;
        this.monochrome = monochrome;
    }

    public Color getColor999() {
        return this.color;
    }

    public HColorSimple asMonochrome() {
        if (this.monochrome) {
            throw new IllegalStateException();
        }
        return new HColorSimple(new ColorChangerMonochrome().getChangedColor(this.color), true);
    }

    public HColorSimple opposite() {
        Color mono = new ColorChangerMonochrome().getChangedColor(this.color);
        int grayScale = 255 - mono.getGreen() > 127 ? 255 : 0;
        return new HColorSimple(new Color(grayScale, grayScale, grayScale), true);
    }

    public double distance(HColorSimple other) {
        int diffRed = Math.abs(this.color.getRed() - other.color.getRed());
        int diffGreen = Math.abs(this.color.getGreen() - other.color.getGreen());
        int diffBlue = Math.abs(this.color.getBlue() - other.color.getBlue());
        return (double)diffRed * 0.3 + (double)diffGreen * 0.59 + (double)diffBlue * 0.11;
    }

    public final boolean isMonochrome() {
        return this.monochrome;
    }

    public static HColorSimple unlinear(HColorSimple color1, HColorSimple color2, int completionInt) {
        HSLColor col1 = new HSLColor(color1.color);
        HSLColor col2 = new HSLColor(color2.color);
        float[] hsl1 = col1.getHSL();
        float[] hsl2 = col2.getHSL();
        if (completionInt > 100) {
            completionInt = 100;
        }
        float completion = (float)((double)completionInt / 100.0);
        completion = completion * completion * completion;
        float[] hsl = HColorSimple.linear(completion, hsl1, hsl2);
        HSLColor col = new HSLColor(hsl);
        return new HColorSimple(col.getRGB(), color1.monochrome);
    }

    private static float[] linear(float factor, float[] hsl1, float[] hsl2) {
        float h = HColorSimple.linear(factor, hsl1[0], hsl2[0]);
        float s = HColorSimple.linear(factor, hsl1[1], hsl2[1]);
        float l = HColorSimple.linear(factor, hsl1[2], hsl2[2]);
        return new float[]{h, s, l};
    }

    private static float linear(float factor, float x, float y) {
        return x + (y - x) * factor;
    }
}

