"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PlantUmlPipe = void 0;
var binary_split_1 = __importDefault(require("binary-split"));
var child_process_1 = require("child_process");
var fs = __importStar(require("fs"));
var os_1 = require("os");
var split2_1 = __importDefault(require("split2"));
var drop_empty_chunks_stream_1 = require("./drop_empty_chunks_stream");
var plantuml_pipe_options_1 = require("./plantuml_pipe_options");
/**
 * Class that wraps a PlantUML diagram generator running in pipe mode.
 */
var PlantUmlPipe = /** @class */ (function () {
    /**
     * Creates a new PlantUML pipe.
     * @param userOptions Possible user defined options for the PlantUML generating pipe.
     */
    function PlantUmlPipe(userOptions) {
        if (userOptions === void 0) { userOptions = {}; }
        var options = (0, plantuml_pipe_options_1.addDefaultsToOptions)(userOptions);
        if (!fs.existsSync(options.jarPath)) {
            throw new Error("plantuml JAR file not found: " + options.jarPath);
        }
        var args = (0, plantuml_pipe_options_1.createArgsFromOptions)(options);
        this.javaProcess = (0, child_process_1.spawn)("java", args);
        this.inputStream = this.javaProcess.stdin;
        if (options.split) {
            var splitter = options.outputFormat === "png" ? (0, binary_split_1.default)(options.delimiter + os_1.EOL) : (0, split2_1.default)(options.delimiter + os_1.EOL);
            // PlantUML pipe mode also adds the delimiter to the end of the last created image.
            // This results in the last buffer being empty. DropEmptyChunksStream drops that buffer.
            this.outputStream = this.javaProcess.stdout.pipe(splitter).pipe(new drop_empty_chunks_stream_1.DropEmptyChunksStream());
        }
        else {
            this.outputStream = this.javaProcess.stdout;
        }
    }
    Object.defineProperty(PlantUmlPipe.prototype, "in", {
        /**
         * @returns The input stream into which to write the PlantUML code of the diagrams.
         */
        get: function () {
            return this.inputStream;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(PlantUmlPipe.prototype, "out", {
        /**
         * @returns The output stream from which to read the generated PlantUML diagram images.
         */
        get: function () {
            return this.outputStream;
        },
        enumerable: false,
        configurable: true
    });
    return PlantUmlPipe;
}());
exports.PlantUmlPipe = PlantUmlPipe;
