local BigPopupDialogScreen = require "screens/bigpopupdialog"

local assets =
{
	Asset("ANIM", "anim/volcano.zip"),
}

local prefabs =
{
    "meteor_impact",
}

local function GetVerb(inst)
	return STRINGS.ACTIONS.ACTIVATE.ASCEND
end


local function OnActivate(inst)

	SetPause(true)
	--local level = GetWorld().topology.level_number or 1
	local function head_upwards()
		SaveGameIndex:GetSaveFollowers(GetPlayer())
		SaveGameIndex:SetSaveSeasonData(GetPlayer())
		SaveGameIndex:SetSaveVolcanoData(GetPlayer())

		local function onsaved()
		    SetPause(false)
		    StartNextInstance({reset_action=RESET_ACTION.LOAD_SLOT, save_slot = SaveGameIndex:GetCurrentSaveSlot()}, true)
		end

		--local cave_num =  SaveGameIndex:GetCurrentCaveNum()
		--if level == 1 then
			SaveGameIndex:SaveCurrent(function() SaveGameIndex:EnterVolcano(onsaved) end, "ascend")
		--[[else
			-- Ascend
			local level = level - 1
			
			SaveGameIndex:SaveCurrent(function() SaveGameIndex:EnterCave(onsaved,nil, cave_num, level) end, "ascend", cave_num)
		end]]--
	end
	GetPlayer().HUD:Hide()
	TheFrontEnd:Fade(false, 2, function()
									head_upwards()
								end)
end

local function OnSeasonChange(inst)
    if GetSeasonManager():IsDrySeason() then
        inst.sg:GoToState("active")
    else
        inst.sg:GoToState("dormant")
    end
end 

local function OnWake(inst)
    inst.SoundEmitter:PlaySound("dontstarve_DLC002/common/volcano/volcano_external_amb", "volcano")
    local state = 1.0
    if inst.sg and inst.sg.currentstate == "dormant" then
        state = 0.0
    end
    inst.SoundEmitter:SetParameter("volcano", "volcano_state", state)
end

local function OnSleep(inst)
    inst.SoundEmitter:KillSound("volcano")
end

local function fn()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    local minimap = inst.entity:AddMiniMapEntity()
    inst.entity:AddSoundEmitter()

    inst.entity:AddLight()
    inst.Light:SetFalloff(0.4)
    inst.Light:SetIntensity(.7)
    inst.Light:SetRadius(10)
    inst.Light:SetColour(249/255, 130/255, 117/255)
    inst.Light:Enable(true)

    minimap:SetIcon("volcano.png")

    inst.entity:AddPhysics()
 	inst.Physics:SetMass(0) 
    inst.Physics:SetCollisionGroup(COLLISION.OBSTACLES)
    inst.Physics:ClearCollisionMask()
    inst.Physics:CollidesWith(COLLISION.ITEMS)
    inst.Physics:CollidesWith(COLLISION.CHARACTERS)
    inst.Physics:SetRectangle(17, 5)
    anim:SetBuild("volcano")
    anim:SetBank("volcano")
    anim:PlayAnimation("dormant_idle", true)
	
    inst:AddComponent("inspectable")
 	inst:AddComponent("scenariorunner")
    inst.components.scenariorunner:SetScript("camera_volcano")
    inst.components.scenariorunner:Run()

    inst.OnLoadPostPass = function(inst, ents, data)
    	GetWorld().components.volcanomanager:AddVolcano(inst)
	end

    inst.OnRemoveEntity = function(inst)
    	GetWorld().components.volcanomanager:RemoveVolcano(inst)
	end

    inst:ListenForEvent("OnVolcanoEruptionBegin", function (it)
        if inst and inst.sg then
            inst.sg:GoToState("erupt")
        end
        -- print(">>>OnVolcanoEruptionBegin", inst)
    end, GetWorld())

    inst:ListenForEvent("OnVolcanoEruptionEnd", function (it)
        if inst and inst.sg then
            inst.sg:GoToState("rumble")
        end
        -- print(">>>OnVolcanoEruptionEnd", inst)
    end, GetWorld())

    inst:ListenForEvent("OnVolcanoWarningQuake", function (it)
        if inst and inst.sg then
            inst.sg:GoToState("rumble")
        end
        -- print(">>>OnVolcanoEruptionEnd", inst)
    end, GetWorld())

    inst:SetStateGraph("SGvolcano")

    inst:ListenForEvent("seasonChange", OnSeasonChange)

    inst.OnEntityWake = OnWake
    inst.OnEntitySleep = OnSleep

    inst:AddComponent("inspectable")

	inst:AddComponent("activatable")
    inst.components.activatable.OnActivate = OnActivate
    inst.components.activatable.inactive = true
    inst.components.activatable.getverb = GetVerb
	inst.components.activatable.quickaction = true

	return inst
end




return Prefab( "marsh/objects/volcano", fn, assets, prefabs)
