
local assets=
{
    Asset("ANIM", "anim/lawsword.zip"),
    Asset("ANIM", "anim/swap_lawsword.zip"),
  
    Asset("ATLAS", "images/inventoryimages/lawsword.xml"),
    Asset("IMAGE", "images/inventoryimages/lawsword.tex"),
}

local function doBlindEffect(target)
    local size = 1
    if target:HasTag("smallcreature") then
        size = 0
    elseif target:HasTag("largecreature") then
        size = 2
    end

    local fx = SpawnPrefab("tornado")
    fx.entity:SetParent(target.entity)
    fx.Transform:SetPosition(0, size, 0)
    target.blindEffect = fx
end
local function doBlindEffectEndTask(target)
    if target.blindEffectEndTask ~= nil then
        target.blindEffectEndTask:Cancel()
    end

    local time = 3
    if target.components.health then
        if target.components.health.currenthealth <= 0 then
            time = 0
        end
    end

    target.blindEffectEndTask = target:DoTaskInTime(time, function(target)
        if target.blindEffect ~= nil then
            target.blindEffect:Remove()
            target.blindEffect = nil
        end
    end, target)
end


local function onattack_shusui(inst, atker, target, skipsanity)

    -- ֥饤ɄϴʸĤΈϤΤ
    

        if target.blindEffect ~= nil then
           
            doBlindEffectEndTask(target)
            return
        end

   
        doBlindEffect(target)
        doBlindEffectEndTask(target)

  

    -- ؤǤ⹥Ĥʹʻ؏ͳ褦ˤ
    

end

local function fn()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
	
	inst.AnimState:SetBank("lawsword")
    inst.AnimState:SetBuild("lawsword")
    inst.AnimState:PlayAnimation("idle")
	
	if not TheWorld.ismastersim then
        return inst
    end
 
    local function OnEquip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_object", "swap_lawsword", "swap_lawsword")
        owner.AnimState:Show("ARM_carry")
        owner.AnimState:Hide("ARM_normal")
    end
 
    local function OnUnequip(inst, owner)
        owner.AnimState:Hide("ARM_carry")
        owner.AnimState:Show("ARM_normal")
    end
 
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.keepondeath = true
    inst.components.inventoryitem.imagename = "lawsword"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/lawsword.xml"
     
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
	inst.components.inventoryitem.keepondeath = true
	
	inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(TUNING.SPEAR_USES)
    inst.components.finiteuses:SetUses(TUNING.SPEAR_USES)
	
	inst:AddComponent("inspectable")
		
	inst:AddTag("sharp")
 	inst:AddComponent("weapon")
	inst.components.weapon:SetOnAttack(onattack_shusui)
    inst.components.weapon:SetDamage(60)
    inst.components.weapon:SetRange(8, 10)
	inst.components.weapon:SetProjectile("zoro_projectile")

        
    if not inst.components.characterspecific then
    inst:AddComponent("characterspecific")
end
 
    inst.components.characterspecific:SetOwner("yasuo")
    inst.components.characterspecific:SetStorable(true)
    inst.components.characterspecific:SetComment("These seem heavier than they look.") 
     

    return inst
	
end
	
return  Prefab("common/inventory/shusui", fn, assets)