// This is an Unreal Script
class AWCConfigPromotion extends UIArmory_Promotion 
	config(ChooseableAWC);

//CONFIG SHIZZLE
var config bool ENABLE_RETROACTIVE_FIX;
var config bool ENABLE_INSTANT_AWC;
var config bool ENABLE_COMPLETE_AWC_CHOICE;
var config bool ENABLE_SELF_CLASS_AWC_CHOICE;
var config bool ENABLE_COMPLETE_SELECTION_AWC_CHOICE;

var bool refresh_flag;

var array<SoldierClassAbilityType> all_temp;
var bool all_loaded;

//NEW HAXXY CHEATY METHOD OF UPDATING SETTINGS
//SAVING VARIABLES AND LOADING THEM//
var AWC_UISelectListener execute_listener;

//notification that stuff is being updates and we don't need to be told twice!
var bool update_flag;
var StateObjectReference update_ref;//If it is this do not update
var bool update_ref_handled_flag;

simulated function OnInit()
{
	refresh_flag = false;
	all_loaded = false;
	update_ref_handled_flag = true;
	super.OnInit();
}

//OVERRIDE TO ENSURE (DEBUG MAINLY BUT ALSO FOR OTHER SHIZZLE)
simulated function PopulateData()
{	
	local array<name> AWCAbilityNames;
	super.PopulateData();

	if(!refresh_flag) 
	{	//CALL THE CODE//
		AWCAbilityNames = AwardAWCAbilities();
		if(AWCAbilityNames.Length > 0)
		{
			ShowAWCDialog(AWCAbilityNames);
		}
	}
}

//DISABLED
simulated function ShowAWCDialog(array<name> AWCAbilityNames)
{
	//NADA
}

//Can Call - but differently
simulated function Display_ExecAWCDialog(array<name> AWCAbilityNames)
{
	super.ShowAWCDialog(AWCAbilityNames);
}

////GUI FUNCTIONALITY

function XComPresentationLayerBase GetPresentationLayer()
{
	return XComPlayerController(class'UIInteraction'.static.GetLocalPlayer(0).Actor).Pres;
}

function GUIChoice(array<SoldierClassAbilityType> options,ClassAgnosticAbility ability, int abilityindex)
{
	local AWC_UIChoice choice;
	local bool flag1;
	flag1 = update_flag;//ENSURE NO CHANGES
	if(refresh_flag) {//ALLOW REFRESH WITHOUT SILLYNESS
		return;
	}
	if(ability.bUnlocked) {//ANTI ERROR
		return;
	}
	if(!update_ref_handled_flag) {
		//ENSURE NO DOUBLES
		update_ref_handled_flag = true;
		if(UnitReference == update_ref) {
			return;
		}
	}
	choice = Spawn(class'AWC_UIChoice',self);
	choice.options = options;
	choice.ability_ref = ability;
	choice.superconfig = self;
	choice.ability_ref_index = abilityindex;
	if(flag1)
	{
		choice.insticlose = true;
	}
	//
	self.Movie.Stack.Push(choice);
	//
	choice.build_gui();
	choice.chosen = false;
	choice.Show();
	///SElf anti-double code:
	update_ref = UnitReference;
	update_ref_handled_flag = false;
}


simulated function int hasAWCAbilities(XComGameState_Unit UnitState,XComGameState_HeadquartersXCom XComHQ) {
	local int idx;
	local int targetrank;
	local bool flag1;
	targetrank = -1; //IF NONE GO TO THAT BIT OF CODE
	if(XComHQ.HasFacilityByName('AdvancedWarfareCenter'))
	{
		for(idx = 0; idx < UnitState.AWCAbilities.Length; idx++)
		{
			if(ENABLE_RETROACTIVE_FIX) {
				flag1 = (!UnitState.AWCAbilities[idx].bUnlocked && UnitState.AWCAbilities[idx].iRank <= UnitState.GetRank());
			}else{
				flag1 = (!UnitState.AWCAbilities[idx].bUnlocked && UnitState.AWCAbilities[idx].iRank == UnitState.GetRank());
			}
			if(ENABLE_INSTANT_AWC && !UnitState.AWCAbilities[idx].bUnlocked) {
				flag1 = true;
			}
			if(flag1) {
				return -1;
			}
			targetrank = UnitState.AWCAbilities[idx].iRank;
		}
	}
	return targetrank;
}



//STATE SAVING ATTEMPT VERSION 2 //AND KNOWING MY LUCK IT WILL STILL FAIL MISERABLY
function SetAWCAbility(int index, SoldierClassAbilityType type) {
	///NEW HAXXY WAY :> Register to a screen listener service to push to history
	///Becuase the onclick way never seems to work, no idea why
	///It just accepts the history and does absolutely nothing about it
	execute_listener.update_arr = index;
	execute_listener.update_flag = true;
	execute_listener.update_type = type;
	execute_listener.update_ref = UnitReference;
	execute_listener.update_minion = self;
	update_flag = true;
	/////////
}

///SOME RETROACTIVITY BUG FIXING//
simulated function array<name> AwardAWCAbilities()
{
	//CHANGES:
	//	@Retroactivity
	//	@Choosing AWC Perks

	local bool flag1; //DO SHIZZLE FLAG
	local array<SoldierClassAbilityType> AbilityOptions;

	local XComGameState NewGameState;
	local XComGameState_Unit UnitState;
	local XComGameState_Unit Unit_Original;
	local XComGameState_HeadquartersXCom XComHQ;
	local array<name> AWCAbilityNames;
	local int idx;

	XComHQ = class'UIUtilities_Strategy'.static.GetXComHQ();
	Unit_Original = getUnit();

	idx = hasAWCAbilities(Unit_Original,XComHQ);
	if(idx != -1) {
		//`RedScreen("Debug : No AWC Abilities to award >> " $ idx $ " / " $ Unit_Original.GetRank());
		return AWCAbilityNames; //ENSURES NO UNEEDED GAMESTATES ARE PUSHED
	}else{
		//`RedScreen("Has AWCPerks + Getting em!");
	}
	if(refresh_flag || update_flag) {//IGNORES UPDATE_FLAG Because it is called invalidly i think
		return AWCAbilityNames; //Hack to ensure the dialogue doesn't appear twice
	}
	///OK WE ARE CREATING STUFF
	NewGameState = class'XComGameStateContext_ChangeContainer'.static.CreateChangeState("Unlock AWC Abilities");
	UnitState = XComGameState_Unit(NewGameState.CreateStateObject(class'XComGameState_Unit', UnitReference.ObjectID));
	NewGameState.AddStateObject(UnitState);

	///CALL
	if(XComHQ.HasFacilityByName('AdvancedWarfareCenter'))
	{	
		// if the unit has no AWC abilities, and we have a AWC, give em one (they need one!!!)
		if(UnitState.AWCAbilities.Length == 0)
		{
			UnitState.bRolledForAWCAbility = false;
			UnitState.RollForAWCAbility();
		}

		// if you have the AWC, and have reached the rank for one of your hidden abilities, unlock it
		for(idx = 0; idx < UnitState.AWCAbilities.Length; idx++)
		{	//## Start of Changes ##
															//Change to ensure old rank AWC perks are awarded
															//FROM: == TO: <=
			if(ENABLE_RETROACTIVE_FIX) {
				flag1 = (!UnitState.AWCAbilities[idx].bUnlocked && UnitState.AWCAbilities[idx].iRank <= UnitState.GetRank());
			}else{
				flag1 = (!UnitState.AWCAbilities[idx].bUnlocked && UnitState.AWCAbilities[idx].iRank == UnitState.GetRank());
			}
			if(ENABLE_INSTANT_AWC && !UnitState.AWCAbilities[idx].bUnlocked) {
				flag1 = true;
			}

			if(flag1) {
				//Load Possibilites & Make The User Choose From Them
				if(ENABLE_COMPLETE_AWC_CHOICE) {
					//GET ALL ABILITIES
					AbilityOptions = GetAllAbilityTypes();
				}else{
					if(ENABLE_SELF_CLASS_AWC_CHOICE) {
						AbilityOptions = class'X2SoldierClassTemplateManager'.static.GetSoldierClassTemplateManager().GetCrossClassAbilities();
					}else{
						AbilityOptions = class'X2SoldierClassTemplateManager'.static.GetSoldierClassTemplateManager().GetCrossClassAbilities(UnitState.GetSoldierClassTemplate());
					}
					if(!ENABLE_COMPLETE_SELECTION_AWC_CHOICE) {
						///RANDOMLY LIMIT THE SELECTION
						AbilityOptions = LimitSelection(AbilityOptions);
					}
				}
				//Spin off into GUI based handler
				GUIChoice(AbilityOptions,UnitState.AWCAbilities[idx],idx);
			}
			///## End of Changes ##
		}
	}
	else
	{
		// if you don't have the AWC, remove any AWC abilities that haven't been unlocked
		for(idx = 0; idx < UnitState.AWCAbilities.Length; idx++)
		{
			if(!UnitState.AWCAbilities[idx].bUnlocked)
			{
				UnitState.AWCAbilities.Remove(idx, 1);
				idx--;
			}
		}

		// if the unit has no AWC abilities, mark them as eligible to roll again if another AWC is built
		if(UnitState.AWCAbilities.Length == 0)
		{
			UnitState.bRolledForAWCAbility = false;
		}
	}
	`GAMERULES.SubmitGameState(NewGameState);
	return AWCAbilityNames;
}


simulated function array<SoldierClassAbilityType> LimitSelection(array<SoldierClassAbilityType> selection) {
	local array<SoldierClassAbilityType> dat;
	local int i;
	local int rand;
	for(i = 0; i < selection.Length; i++) {
		if(i > (selection.Length - 5 + dat.Length)) {
			dat.AddItem(selection[i]);
		}else{
			//RANDOMISE
			rand = `SYNC_RAND_STATIC(2);
			if(rand == 0) {
				dat.AddItem(selection[i]);
			}
		}
	}
	return dat;
}


simulated function array<SoldierClassAbilityType> GetAllAbilityTypes() {
	local array<X2DataTemplate> defaultclasses_i;
	local array<X2SoldierClassTemplate> defaultclasses;
	local int i, j, k;
	local X2SoldierClassTemplate sclass;
	local array<SoldierClassAbilityType> rank;
	local SoldierClassAbilityType temp;
	local bool flag1;
	if(all_loaded) {
		return all_temp;
	}
	//GENERATE NORMAL ABILITIES
	defaultclasses_i = class'X2SoldierClass_DefaultClasses'.static.CreateTemplates();
	for(i = 0; i < defaultclasses_i.Length; i++) {
		sclass = X2SoldierClassTemplate(defaultclasses_i[i]);
		defaultclasses.AddItem(sclass);
	}
	for(i = 0; i < defaultclasses.Length; i++) {
		sclass = defaultclasses[i];
		for(j = 0; j < sclass.GetMaxConfiguredRank(); j++) {
			rank = sclass.GetAbilityTree(j);
			for(k = 0; k < rank.Length; k++) {
				all_temp.AddItem(rank[k]);
			}
		}
	}
	//ADD ALL CROSSCLASS ABILITIES
	rank = class'X2SoldierClassTemplateManager'.static.GetSoldierClassTemplateManager().GetCrossClassAbilities();
	for(i = 0; i < rank.Length; i++) {
		temp = rank[i];
		flag1 = true;
		for(j = 0; j < all_temp.Length; j++) {
			if(all_temp[j].AbilityName == temp.AbilityName) {
				flag1 = false;
			}
		}
		if(flag1) {
			all_temp.AddItem(temp);
		}
	}
	all_loaded = true;
	return all_temp;
}