//GUI Choice Screen					   //
//Allows for the selection of AWC perks//
class AWC_UIChoice extends UIScreen;

//AWC Choice Data
var array<SoldierClassAbilityType> options;
var int choice;
var int ability_ref_index;
var ClassAgnosticAbility ability_ref;//REFERENCE TO ABILITY
var bool chosen;

//Super GUI Callback
var AWCConfigPromotion superconfig;
var array<X2AbilityTemplate> a_templates;
var X2AbilityTemplate AbilityTemplate;
var X2AbilityTemplateManager AbilityTemplateManager;
var bool insticlose;

//GUI references///
var array<UI_Adv_Icon> icons;
var UIButton bttn;
var UIBGBox pnl;
var UI_Adv_Icon icon;
var UIText title;
var UIBGBox tpnl;

var bool enabled_mega;
var UIBGBox megabg;

//STUPID
var int i;
var int rownum;//HOW DEEP
var int colnum;//HOW ACCROSS

// Flash Callback
simulated function OnInit()
{
	super.OnInit();
	///PREBUILD DATA
	choice = 0;
	chosen = false;
	ability_ref_index = -1;
	enabled_mega = false;
	insticlose = false;
}

simulated function InitScreen(XComPlayerController InitController, UIMovie InitMovie, optional name InitName)
{
	super.InitScreen(InitController, InitMovie, InitName);
	//SANITY CHECK V2 {insert}
	if(superconfig.update_flag)
	{
		shutdown(); //ERRORED LAUNCH {also ensures that the update service runs};
		return;
	}
	if(insticlose)
	{
		shutdown(); ///Was Just Supposed to be a notifier
		return;
	}
	AbilityTemplateManager = class'X2AbilityTemplateManager'.static.GetAbilityTemplateManager();
	init_outline();
}

public function init_outline() {
	//BACKGROUND
	pnl = Spawn(class'UIBGBox', self);
	pnl.InitBG('SelectChoice_Background');
	pnl.AnchorCenter();
	pnl.setPosition(-350,-175);
	pnl.setSize(700,350);
	pnl.SetBGColor("gray");
	pnl.SetAlpha(50);

	//ACCEPT BUTTON//
	bttn = Spawn(class'UIButton', self);
	bttn.bAnimateOnInit = false;
	bttn.InitButton('SelectChoiceButton_AWC',"Choose This Perk.",button_press);
	bttn.AnchorCenter();
	bttn.setPosition(-70,130);//TODO CHECK
	bttn.setSize(70,35);
	bttn.EnableButton();
	bttn.SetSelected(false);
	bttn.SetTooltipText("Selects This AWC Perk!!!");

	//Decoration >> makes it look better//
	tpnl = Spawn(class'UIBGBox',self);
	tpnl.InitBG('SelectChoice_TitleBackground');
	tpnl.AnchorCenter();
	tpnl.setPosition(-350,-210);
	tpnl.setSize(700,35);
	tpnl.SetBGColor("yellow_highlight");
	tpnl.SetAlpha(80);

	title = Spawn(class'UIText',self);
	title.InitText('SelectAWC_Title',"AWC Perk Unlocked!   Please Select",false);
	title.AnchorCenter();
	title.SetPosition(-345,-205);
	title.SetSize(700,30);
	title.SetColor("#000000");


	//DEBUG CODE
	if(ability_ref_index == -1) {
		init_testing();
	}
}

//DEBUG CODE ONLY
public function init_testing() {
	//DISPLAY
	options = class'X2SoldierClassTemplateManager'.static.GetSoldierClassTemplateManager().GetCrossClassAbilities();
	init_outline();
}

//ACTUAL INITIALISATION
public function build_gui() {
	//SANITY CHECK
	if(superconfig.update_flag)
	{
		shutdown(); //ERRORED LAUNCH {also ensures that the update service runs};
		return;
	}
	if(insticlose)
	{
		shutdown(); ///Was Just Supposed to be a notifier
		return;
	}

	rownum = 0;
	colnum = 0;
	for(i = 0; i < options.Length; i++) {
		AbilityTemplate = AbilityTemplateManager.FindAbilityTemplate(options[i].AbilityName);
		a_templates.AddItem(AbilityTemplate);
	}
	//BUILD SELECTION//
	for(i = 0; i < a_templates.Length; i++) {
		icon = Spawn(class'UI_Adv_Icon', self);
		icon.InitAdvIcon('',a_templates[i].IconImage,true,40,i,icon_press);//TODO NAME ICONS
		icon.AnchorCenter();
		if(rownum > 3) {
			//PUSH ADDITIONALS
			icon.AnchorTopLeft();
			icon.OriginTopLeft();
			icon.SetPosition(colnum * 60, rownum * 60);//THE MINUS IS DUE TO A BUG
			Megamode(a_templates.Length);
		}else{
			icon.SetPosition(-320 + (colnum * 60),-150 + (rownum * 60));
		}
		icon.SetTip(a_templates[i].LocFriendlyName,a_templates[i].LocHelpText);
		colnum++;
		if(rownum > 3) {
			if(colnum > 8) {
				colnum = 0;
				rownum++;
			}
		}else{
			if(colnum > 10) {
				colnum = 0;
				rownum++;
			}
		}
		icons.AddItem(icon);
	}
	//SELECT ONE OF THEM
	icon_press(icon,0);
}


simulated function Megamode(int len) {
	if(enabled_mega) {
		return;
	}
	megabg = Spawn(class'UIBGBox',self);
	megabg.InitBG('SelectChoice_ExtentionBackground');
	megabg.AnchorTopLeft();
	megabg.setPosition(0,0);
	megabg.setSize(700,((len / 10) * 70) + 500);
	megabg.SetBGColor("gray");
	megabg.SetAlpha(50);

	enabled_mega = true;
}



function icon_press(UI_Adv_Icon iconinstance,int valuation) {
	icons[choice].setSelected(false);
	icons[valuation].setSelected(true);
	choice = valuation;
}

public function button_press(UIButton btn) {
	//New call to handler:> attempt to make the stupid state to save in its brain
	superconfig.SetAWCAbility(ability_ref_index,options[choice]);
	//Ensure Handled
	
	//Cleanup
	notifyshutdown();
}

simulated function notifyshutdown() {
	local array<name> names;
	shutdown();
	///CALLBACK THE NOTIFICATION OF YOUR NED ABILITY
	names.addItem(options[choice].AbilityName);
	superconfig.Display_ExecAWCDialog(names);
}

simulated function shutdown() {
	CloseScreen();
	chosen = true;
	//Refresh the screen of data//
	superconfig.refresh_flag = true;
	superconfig.PopulateData();
	superconfig.refresh_flag = false;
}
