// This is an Unreal Script
//ICON BUILT FOR SELECTING THE PERKS
class UI_Adv_Icon extends UIIcon;



var int value;
delegate OnAdvClickDelegate(UI_Adv_Icon iconinstance,int valuation);

simulated function UIIcon InitAdvIcon(name InitName, string initIcon,
											bool initShowIconBG,
											int initIconSize, int val, delegate<OnAdvClickDelegate> del) {
	super.InitIcon(InitName, initIcon, true, initShowIconBG, initIconSize);
	value = val;
	OnAdvClickDelegate = del;
	return self;
}

simulated function setTip(string title,string str) {
	SetTooltipText(str,title,25,20);
}


simulated function setSelected(bool selected) {
	if(selected) {
		SetForegroundColor(class'UIUtilities_Colors'.const.SCIENCE_HTML_COLOR);
	}else{
		SetForegroundColor(class'UIUtilities_Colors'.const.BLACK_HTML_COLOR);
	}
}

simulated function OnMouseEvent(int cmd, array<string> args)
{
	super.OnMouseEvent(cmd, args);

	switch(cmd)
	{
	case class'UIUtilities_Input'.const.FXS_L_MOUSE_IN:
	case class'UIUtilities_Input'.const.FXS_L_MOUSE_DRAG_OVER:
		if( bEnableMouseAutoColor )
		{
			//Swapped while mouse is hovering. 
			SetForegroundColor(DefaultBGColor); 
			SetBGColor(DefaultForegroundColor);
		}
		else if( !bDisableSelectionBrackets )
		{
			mc.FunctionVoid("showSelectionBrackets");
		}
		break;
	case class'UIUtilities_Input'.const.FXS_L_MOUSE_OUT:
	case class'UIUtilities_Input'.const.FXS_L_MOUSE_DRAG_OUT:
		if( bEnableMouseAutoColor )
		{
			SetForegroundColor(DefaultForegroundColor);
			SetBGColor(DefaultBGColor);
		}
		else if( !bDisableSelectionBrackets )
		{
			mc.FunctionVoid("hideSelectionBrackets");
		}
		break;
	case class'UIUtilities_Input'.const.FXS_L_MOUSE_UP_DELAYED:
		if(!IsDisabled && OnAdvClickDelegate != none)
			OnAdvClickDelegate(self,value);
		break;
	//case class'UIUtilities_Input'.const.FXS_L_MOUSE_DOUBLE_UP:
		//if(!IsDisabled && OnDoubleClickedDelegate != none)
			//OnDoubleClickedDelegate();
		//break;
	}
}