﻿//会诊相关的脚本
var huizhenList = [];
var currentHuiZhen = null;

function getHuiZhenListFromServer() {
    var result = window.external.GetHuiZhenList();
    huizhenList = JSON.parse(result).result;

    var yearMonthTpl = '<div class="monthInfo">{0}</div>';
    var huizhenTpl = '<div id="caseItemTemplate" class="caseItem" onclick="showCase({4},this)"><div class="caseItemPatientInfo">患者：{0} {1} {2}岁</div><div class="caseItemZhuSu"><span class="caseItemTime">{5}</span>&nbsp;{3}</div></div>';
    var html = [];
    var existedYear = [];

    $.each(huizhenList, function (i, n) {
        if ($.inArray(n.create_year_month, existedYear) == -1) {
            existedYear.push(n.create_year_month);
            html.push(yearMonthTpl.format(n.create_year_month));
        }
        var illness = n.illness.length > 50 ? n.illness.toString().substring(0, 50) + "..." : n.illness;
        html.push(huizhenTpl.format(n.patient_name, n.patient_sex, n.patient_age, illness, n.id, n.create_time));

    });

    $('#caseListContent').html(html.join(''));
    if (currentHuiZhen == null) {
        $('#caseListContent .caseItem:eq(0)').click();
    }

}

function getHuiZhenById(huizhenId) {
    var huizhen = {};
    $.each(huizhenList, function (i, n) {
        if (n.id == huizhenId) {
            huizhen = n;
            return false;
        }
    });
    return huizhen;
}

function showCase(huizhenId, obj) {
    $('#caseListContent .caseItem').removeClass("selected");
    $(obj).addClass("selected");

    var huizhen = getHuiZhenById(huizhenId);

    $('#details_Studies').html();
    huizhen.study_instance_uid = huizhen.study_instance_uid == null ? "" : huizhen.study_instance_uid;

    var studies = huizhen.study_instance_uid.split(',');
    var studyHtml = [];
    var studyTpl = '<div style="padding:12px 4px;"><a href="javascript:window.external.ShowStudyUrl(\'{0}\')">{0}</a></div>';

    $.each(studies, function (i, n) {
        if (n == '') return true;
        studyHtml.push(studyTpl.format(n));
    });

    $('#details_Studies').html(studyHtml.join(''));



    $('#detailsPatientName').html(huizhen.patient_name);
    $('#detailsPatientAge').html(huizhen.patient_age);
    $('#detailsPatientSex').html(huizhen.patient_sex);

    $('#detailsIllness').html(huizhen.illness);
    $('#detailsAuxiliaryExamine').html(huizhen.auxiliary_examine);
    $('#detailsTreat').html(huizhen.treat);
    $('#detailsFollowUp').html(huizhen.follow_up);

    currentHuiZhen = huizhenId;
}

function showMatchStudyDialog() {
    window.external.ShowMatchStudyDialog(currentHuiZhen);
}