﻿//pacs相关的脚本
var pacsScpList = [];
var currentpacsScp = null;
function getPacsScpListFromServer() {
    var result = window.external.GetPacsSCPResult();
    pacsScpList = JSON.parse(result);

    var yearMonthTpl = '<div class="monthInfo">{0}</div>';
    var pacsScpTpl = '<div id="pacsScpItemTemplate" class="caseItem" onclick="showPacsScpItem(\'{0}\',this)"><div class="caseItemPatientInfo">{0}</div><div class="caseItemZhuSu">图像数量：{2}<br/>接收时间：{1}<br/>影像大小：{3}</div></div>';
    var html = [];
    var existedYear = [];

    $.each(pacsScpList, function (i, n) {
        if ($.inArray(n.year_month, existedYear) == -1) {
            existedYear.push(n.year_month);
            html.push(yearMonthTpl.format(n.year_month));
        } else {
            html.push(pacsScpTpl.format(n.directory_name, n.received_time, n.instance_count, n.size));
        }
    });

    $('#pacsListContent').html(html.join(''));
    if (currentpacsScp == null) {
        $('#pacsListContent .caseItem:eq(0)').click();
    }

}

function getPacsScpByPath(dirPath) {
    var pacsScp = {};
    $.each(pacsScpList, function (i, n) {
        if (n.directory_name == dirPath) {
            pacsScp = n;
            return false;
        }
    });
    return pacsScp;
}

function showPacsScpItem(dirPath, obj) {
    $('#pacsListContent .caseItem').removeClass("selected");
    $(obj).addClass("selected");

    currentpacsScp = dirPath;

    var pacsScp = getPacsScpByPath(dirPath);

    $('#details_pacsScp_title').html('{0}({2}) {1}'.format(pacsScp.directory_name, pacsScp.size, pacsScp.instance_count));

    var files = window.external.GetPacsSCPFiles(dirPath); //
    files = JSON.parse(files);

    var html = [];
    var tpl = '<tr><td width="10" nowrap="nowrap">{0}.</td><td><a href="#">{1} ({2})</a></td></tr>';
    $.each(files, function (i, n) {
        html.push(tpl.format(i + 1, n.name, n.size));
    });

    $('#detailsBody_PacsScpList').html(html.join(''));
}