﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Threading;
using System.Windows.Forms;

namespace 删除微信缓存
{
    public partial class Form1 : Form
    {
        private string _weChatFilesPath;
        private int _num;
        private List<string> _files;
        private int _errFile;
        private bool _saveMsgFolder = false;

        //委托
        public delegate void ChangeProgress(int value); //进度条进度

        public delegate void AddInfo2Box(string value);

        public delegate void ChangeTips(string value);

        //创建上面的委托的变量
        public ChangeProgress changeProgerss;
        public AddInfo2Box addInfo2Box;
        public ChangeTips changeTips;

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            changeProgerss = FunChangeProgress;
            addInfo2Box = FuncAddInfo2Box;
            changeTips = FuncChangeTips;
            _weChatFilesPath = GetMyDocumentsPath() + "\\WeChat Files";
            _files = new List<string>();
            txtCustomPath.Text = $@"{_weChatFilesPath}";
        }

        private void btnStart_Click(object sender, EventArgs e)
        {
            //检测默认目录是否存在
            CheckWeChatDir();
            
            Start();
        }

        private void cbCustom_CheckedChanged(object sender, EventArgs e)
        {
            txtCustomPath.Enabled = cbCustom.Checked;
        }

        private void btnSelectCustomPath_Click(object sender, EventArgs e)
        {
            if (!cbCustom.Checked)
            {
                return;
            }
            var dialog = new FolderBrowserDialog
            {
                Description = $@"请选择微信缓存目录"
            };
            if (dialog.ShowDialog() == DialogResult.OK)
            {
                _weChatFilesPath = dialog.SelectedPath;
            }
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            //强制退出 销毁进程
            Environment.Exit(Environment.ExitCode);
            this.Dispose();
            this.Close();
        }

        private void cbSaveMsgFolder_CheckedChanged(object sender, EventArgs e)
        {
            //保留聊天记录flag
            _saveMsgFolder = cbSaveMsgFolder.Checked;
        }

        private void CheckWeChatDir()
        {
            if (Directory.Exists(_weChatFilesPath)) return;
            MessageBox.Show($@"未检测到默认的微信缓存目录，请手动选择路径后继续！", $@"提示", MessageBoxButtons.OK);
            //打开文件夹选择
            var dialog = new FolderBrowserDialog
            {
                Description = $@"请选择微信缓存目录"
            };
            if (dialog.ShowDialog() == DialogResult.OK)
            {
                _weChatFilesPath = dialog.SelectedPath;
            }
        }

        private void Start()
        {
            //清空打印的信息
            lboxLog.Items.Clear();
            //清空文件路径列表
            _files.Clear();
            //清空计数器
            _num = 0;
            //判断路径是否存在，是否需要手动指定路径
            if (!Directory.Exists(_weChatFilesPath))
            {
                SetUpInfoAndScroll2Bottom($"默认缓存路径不存在，请手动指定路径！");
                return;
            }
            //获取文件列表
            GetFiles(_weChatFilesPath);
            laCount.Text = $@"文件数：{_num}";
            SetUpInfoAndScroll2Bottom($"共找到{_num}个文件，准备执行删除程序...");
            //退出微信防止文件占用删除失败
            if (MessageBox.Show(@"清除前需要退出微信，是否马上退出微信？", @"提示", MessageBoxButtons.YesNo, MessageBoxIcon.Question) == DialogResult.Yes)
            {
                KillWxProcess();
                SetUpInfoAndScroll2Bottom($"微信未打开或微信已安全退出！");
                SetUpInfoAndScroll2Bottom($"准备执行清除操作！");
            }
            else
            {
                SetUpInfoAndScroll2Bottom($"微信未退出。");
                SetUpInfoAndScroll2Bottom($"等待重新开始...");
                return;
            }

            //无缓存文件提示
            if (_num == 0)
            {
                SetUpInfoAndScroll2Bottom($"无缓存文件，无需清理！");
                return;
            }

            //设置进度条最大值
            progressBar1.Maximum = _num;

            //新创建一个线程
            var thr = new Thread(new ParameterizedThreadStart(DeleteFileByPath));
            //开始线程方法
            thr.Start();
        }

        private void DeleteFileByPath(object obj)
        {
            _errFile = 0;
            for (var index = 0; index < _files.Count; index++)
            {
                var file = _files[index];
                file = file.Replace("\\\\", "\\");

                //百分之一
                double onePercent = _files.Count / 100;
                //计算百分比进度
                var current = (index + 1) / onePercent;
                if (index == _files.Count - 1)
                {
                    //避免出现小数，当文件循环到最后一个的时候直接填满百分比
                    current = 100;
                }
                
                if (File.Exists(file))
                {
                    //删除文件
                    File.Delete(file);

                    //打印操作信息
                    lboxLog.Invoke(addInfo2Box, $"成功删除：{file}");
                }
                else
                {
                    //打印操作信息
                    lboxLog.Invoke(addInfo2Box, $"删除失败：{file}");
                    //记录删除失败的文件数
                    _errFile++;
                }
                //更新进度条UI
                progressBar1.Invoke(changeProgerss, index + 1);

                //更新提示信息
                laTips.Invoke(changeTips, current.ToString("0.00"));
            }
            lboxLog.Invoke(addInfo2Box, $"操作完成！！！【文件数：{_num},成功删除：{_num - _errFile}，删除失败：{_errFile}】");
        }

        private void KillWxProcess()
        {
            //获取微信进程的pid
            var weChatProcess = Process.GetProcessesByName("WeChat");
            foreach (var weChat in weChatProcess)
            {
                if (weChat.ProcessName == "WeChat")
                {
                    //结束进程
                    ProcessHelper.EndProcess(weChat.Id, out _);
                }
            }
        }

        private static string GetMyDocumentsPath()
        {
            //获取’我的文档‘的路径
           return Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments);
        }

        //遍历所有文件
        private void GetFiles(string path)
        {
            try
            {
                var folder = new DirectoryInfo(path);

                //遍历文件
                foreach (var file in folder.GetFiles())
                {
                    _files.Add(path + "\\" + file.Name);
                    _num++;
                }

                //遍历文件夹
                foreach (var childFolder in folder.GetDirectories())
                {
                    var childFolderFullName = childFolder.FullName;
                    //根据需求是否保留聊天记录
                    if (_saveMsgFolder)
                    {
                        if (childFolderFullName.Contains("Msg"))
                        {
                            continue;
                        }
                    }
                    GetFiles(childFolderFullName);
                }
            }
            catch (Exception e)
            {
                //Fix Me : 写异常日志
            }
        }

        //写记录并滚动到最下方
        private void SetUpInfoAndScroll2Bottom(string info)
        {
            lboxLog.Items.Add(info);
            lboxLog.SelectedIndex = lboxLog.Items.Count - 1;
        }

        //更新进度条
        public void FunChangeProgress(int value)
        {
            progressBar1.Value = value;
        }

        //写操作记录
        public void FuncAddInfo2Box(string value)
        {
            lboxLog.Items.Add(value);
            lboxLog.SelectedIndex = lboxLog.Items.Count - 1;
        }

        //写进度提示
        public void FuncChangeTips(string value)
        {
            laTips.Text = $@"进度：{value}%";
        }


    }
}
