﻿using System;
using System.Diagnostics;

namespace 删除微信缓存
{
    class ProcessHelper
    {
        /// <summary>
        /// 结束指定进程
        /// </summary>
        /// <param name="pid">进程的 Process ID</param>
        /// <param name="errorMessage"></param>
        public static bool EndProcess(int pid, out string errorMessage)
        {
            try
            {
                var process = Process.GetProcessById(pid);
                process.Kill();
                process.WaitForExit();
                process.Close();
                errorMessage = "";
                return true;
            }
            catch (Exception ex)
            {
                errorMessage = ex.Message;
                return false;
            }
        }
    }
}
